/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.EmailDeserializer;
import org.systinet.uddi.client.v3.serialization.EmailSerializer;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Email
extends UDDIObject
implements Cloneable,
Serializable {
    private String useType;
    private String value;

    public Email() {
    }

    public Email(String value) throws InvalidParameterException {
        this.setValue(value);
    }

    public Email(String value, String useType) throws InvalidParameterException {
        this.setValue(value);
        this.setUseType(useType);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws InvalidParameterException {
        if (value != null) {
            if ((value = StringHelper.whitespaceCollapse(value)).length() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
            }
            if (value.length() > 255) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
            }
        }
        this.value = value;
    }

    public String getUseType() {
        return this.useType;
    }

    public void setUseType(String useType) throws InvalidParameterException {
        if (useType != null && (useType = StringHelper.whitespaceCollapse(useType)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.useType = useType;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "email", EmailSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "email", (Serializer)EmailSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "email", (Serializer)EmailSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "email", (Serializer)EmailSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "email", (Serializer)EmailSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "email", EmailSerializer.getInstance(), tokenWriter, mapping);
    }

    public static Email fromXML(String string) throws InvalidParameterException, WrappedException {
        return (Email)Helper.deserialize("urn:uddi-org:api_v3", "email", (Deserializer)EmailDeserializer.getInstance(), string);
    }

    public static Email fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (Email)Helper.deserialize("urn:uddi-org:api_v3", "email", (Deserializer)EmailDeserializer.getInstance(), element);
    }

    public static Email fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (Email)Helper.deserialize("urn:uddi-org:api_v3", "email", (Deserializer)EmailDeserializer.getInstance(), reader);
    }

    public static Email fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (Email)Helper.deserialize("urn:uddi-org:api_v3", "email", (Deserializer)EmailDeserializer.getInstance(), tokenizer);
    }

    public static Email fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (Email)Helper.deserialize("urn:uddi-org:api_v3", "email", EmailDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.value == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "Email.value"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.value != null) {
            result = false;
        }
        if (this.useType != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Email theClone = (Email)super.clone();
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Email)) {
            return false;
        }
        Email org_systinet_uddi_client_v3_struct_Email = (Email)o;
        boolean bl = this.value != null ? !this.value.equals(org_systinet_uddi_client_v3_struct_Email.value) : org_systinet_uddi_client_v3_struct_Email.value != null;
        if (bl) {
            return false;
        }
        return !(this.useType != null ? !this.useType.equals(org_systinet_uddi_client_v3_struct_Email.useType) : org_systinet_uddi_client_v3_struct_Email.useType != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 29 * result + (this.useType != null ? this.useType.hashCode() : 0);
        return result;
    }
}

