/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.UDDIErrorCodes;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.serialization.DispositionReportDeserializer;
import org.systinet.uddi.client.v3.serialization.DispositionReportSerializer;
import org.systinet.uddi.client.v3.struct.ErrInfo;
import org.systinet.uddi.client.v3.struct.Result;
import org.systinet.uddi.client.v3.struct.ResultArrayList;
import org.systinet.uddi.client.v3.struct.ResultArrayListIterator;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DispositionReport
extends UDDIObject
implements Cloneable,
Serializable {
    protected ResultArrayList resultArrayList;
    protected Boolean truncated;
    public static final DispositionReport DISPOSITION_REPORT_SUCCESS = new DispositionReport();

    public DispositionReport() {
    }

    public DispositionReport(ResultArrayList resultArrayList) throws InvalidParameterException {
        this.setResultArrayList(resultArrayList);
    }

    public DispositionReport(ResultArrayList resultArrayList, Boolean truncated) throws InvalidParameterException {
        this.setResultArrayList(resultArrayList);
        this.setTruncated(truncated);
    }

    public void addResult(Result item) {
        if (this.resultArrayList == null) {
            this.resultArrayList = new ResultArrayList();
        }
        this.resultArrayList.add(item);
    }

    public ResultArrayList getResultArrayList() {
        return this.resultArrayList;
    }

    public void setResultArrayList(ResultArrayList resultArrayList) throws InvalidParameterException {
        if (resultArrayList == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "resultArrayList"));
        }
        this.resultArrayList = resultArrayList;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        if (truncated != null) {
            // empty if block
        }
        this.truncated = truncated;
    }

    public boolean containsErrno(int errno) {
        if (this.resultArrayList != null) {
            ResultArrayListIterator resultArrayListIterator = this.resultArrayList.resultArrayListIterator();
            while (resultArrayListIterator.hasNext()) {
                Result result = resultArrayListIterator.next();
                if (result.getErrno() != errno) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSuccess() {
        return this.resultArrayList != null && this.resultArrayList.size() == 1 && this.containsErrno(0);
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "dispositionReport", DispositionReportSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "dispositionReport", (Serializer)DispositionReportSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "dispositionReport", (Serializer)DispositionReportSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "dispositionReport", (Serializer)DispositionReportSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "dispositionReport", (Serializer)DispositionReportSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "dispositionReport", DispositionReportSerializer.getInstance(), tokenWriter, mapping);
    }

    public static DispositionReport fromXML(String string) throws InvalidParameterException, WrappedException {
        return (DispositionReport)Helper.deserialize("urn:uddi-org:api_v3", "dispositionReport", (Deserializer)DispositionReportDeserializer.getInstance(), string);
    }

    public static DispositionReport fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (DispositionReport)Helper.deserialize("urn:uddi-org:api_v3", "dispositionReport", (Deserializer)DispositionReportDeserializer.getInstance(), element);
    }

    public static DispositionReport fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (DispositionReport)Helper.deserialize("urn:uddi-org:api_v3", "dispositionReport", (Deserializer)DispositionReportDeserializer.getInstance(), reader);
    }

    public static DispositionReport fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (DispositionReport)Helper.deserialize("urn:uddi-org:api_v3", "dispositionReport", (Deserializer)DispositionReportDeserializer.getInstance(), tokenizer);
    }

    public static DispositionReport fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (DispositionReport)Helper.deserialize("urn:uddi-org:api_v3", "dispositionReport", DispositionReportDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.resultArrayList == null || this.resultArrayList.size() < 1) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "DispositionReport.resultArrayList"));
        }
        this.resultArrayList.check();
    }

    public boolean normalize() {
        boolean result = true;
        if (this.resultArrayList != null) {
            if (this.resultArrayList.normalize()) {
                this.resultArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.truncated != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        DispositionReport theClone = (DispositionReport)super.clone();
        if (this.resultArrayList != null) {
            theClone.resultArrayList = (ResultArrayList)this.resultArrayList.clone();
        }
        if (this.truncated != null) {
            theClone.truncated = new Boolean(this.truncated);
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DispositionReport)) {
            return false;
        }
        DispositionReport org_systinet_uddi_client_v3_struct_DispositionReport = (DispositionReport)o;
        boolean bl = this.resultArrayList != null ? !this.resultArrayList.equals(org_systinet_uddi_client_v3_struct_DispositionReport.resultArrayList) : org_systinet_uddi_client_v3_struct_DispositionReport.resultArrayList != null;
        if (bl) {
            return false;
        }
        return !(this.truncated != null ? !this.truncated.equals(org_systinet_uddi_client_v3_struct_DispositionReport.truncated) : org_systinet_uddi_client_v3_struct_DispositionReport.truncated != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.resultArrayList != null ? this.resultArrayList.hashCode() : 0);
        result = 29 * result + (this.truncated != null ? this.truncated.hashCode() : 0);
        return result;
    }

    static {
        try {
            DISPOSITION_REPORT_SUCCESS.setResultArrayList(new ResultArrayList(new Result(0, new ErrInfo(UDDIErrorCodes.getCode(0), UDDIErrorCodes.getMessage(0)), null)));
        }
        catch (InvalidParameterException invalidParameterException) {
            // empty catch block
        }
    }
}

