/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.ContactDeserializer;
import org.systinet.uddi.client.v3.serialization.ContactSerializer;
import org.systinet.uddi.client.v3.struct.Address;
import org.systinet.uddi.client.v3.struct.AddressArrayList;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.Email;
import org.systinet.uddi.client.v3.struct.EmailArrayList;
import org.systinet.uddi.client.v3.struct.PersonName;
import org.systinet.uddi.client.v3.struct.PersonNameArrayList;
import org.systinet.uddi.client.v3.struct.Phone;
import org.systinet.uddi.client.v3.struct.PhoneArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Contact
extends UDDIObject
implements Cloneable,
Serializable {
    protected DescriptionArrayList descriptionArrayList;
    protected PersonNameArrayList personNameArrayList;
    protected PhoneArrayList phoneArrayList;
    protected EmailArrayList emailArrayList;
    protected AddressArrayList addressArrayList;
    protected String useType = "";

    public Contact() {
    }

    public Contact(PersonNameArrayList personNameArrayList) throws InvalidParameterException {
        this.setPersonNameArrayList(personNameArrayList);
    }

    public Contact(PersonNameArrayList personNameArrayList, DescriptionArrayList descriptionArrayList, PhoneArrayList phoneArrayList, EmailArrayList emailArrayList, AddressArrayList addressArrayList, String useType) throws InvalidParameterException {
        this.setPersonNameArrayList(personNameArrayList);
        this.setDescriptionArrayList(descriptionArrayList);
        this.setPhoneArrayList(phoneArrayList);
        this.setEmailArrayList(emailArrayList);
        this.setAddressArrayList(addressArrayList);
        this.setUseType(useType);
    }

    public void addDescription(Description item) {
        if (this.descriptionArrayList == null) {
            this.descriptionArrayList = new DescriptionArrayList();
        }
        this.descriptionArrayList.add(item);
    }

    public DescriptionArrayList getDescriptionArrayList() {
        return this.descriptionArrayList;
    }

    public void setDescriptionArrayList(DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.descriptionArrayList = descriptionArrayList;
    }

    public void addPersonName(PersonName item) {
        if (this.personNameArrayList == null) {
            this.personNameArrayList = new PersonNameArrayList();
        }
        this.personNameArrayList.add(item);
    }

    public PersonNameArrayList getPersonNameArrayList() {
        return this.personNameArrayList;
    }

    public void setPersonNameArrayList(PersonNameArrayList personNameArrayList) throws InvalidParameterException {
        if (personNameArrayList == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "personNameArrayList"));
        }
        this.personNameArrayList = personNameArrayList;
    }

    public void addPhone(Phone item) {
        if (this.phoneArrayList == null) {
            this.phoneArrayList = new PhoneArrayList();
        }
        this.phoneArrayList.add(item);
    }

    public PhoneArrayList getPhoneArrayList() {
        return this.phoneArrayList;
    }

    public void setPhoneArrayList(PhoneArrayList phoneArrayList) throws InvalidParameterException {
        this.phoneArrayList = phoneArrayList;
    }

    public void addEmail(Email item) {
        if (this.emailArrayList == null) {
            this.emailArrayList = new EmailArrayList();
        }
        this.emailArrayList.add(item);
    }

    public EmailArrayList getEmailArrayList() {
        return this.emailArrayList;
    }

    public void setEmailArrayList(EmailArrayList emailArrayList) throws InvalidParameterException {
        this.emailArrayList = emailArrayList;
    }

    public void addAddress(Address item) {
        if (this.addressArrayList == null) {
            this.addressArrayList = new AddressArrayList();
        }
        this.addressArrayList.add(item);
    }

    public AddressArrayList getAddressArrayList() {
        return this.addressArrayList;
    }

    public void setAddressArrayList(AddressArrayList addressArrayList) throws InvalidParameterException {
        this.addressArrayList = addressArrayList;
    }

    public String getUseType() {
        return this.useType;
    }

    public void setUseType(String useType) throws InvalidParameterException {
        if (useType != null && (useType = StringHelper.whitespaceCollapse(useType)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.useType = useType;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "contact", ContactSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "contact", (Serializer)ContactSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "contact", (Serializer)ContactSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "contact", (Serializer)ContactSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "contact", (Serializer)ContactSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "contact", ContactSerializer.getInstance(), tokenWriter, mapping);
    }

    public static Contact fromXML(String string) throws InvalidParameterException, WrappedException {
        return (Contact)Helper.deserialize("urn:uddi-org:api_v3", "contact", (Deserializer)ContactDeserializer.getInstance(), string);
    }

    public static Contact fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (Contact)Helper.deserialize("urn:uddi-org:api_v3", "contact", (Deserializer)ContactDeserializer.getInstance(), element);
    }

    public static Contact fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (Contact)Helper.deserialize("urn:uddi-org:api_v3", "contact", (Deserializer)ContactDeserializer.getInstance(), reader);
    }

    public static Contact fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (Contact)Helper.deserialize("urn:uddi-org:api_v3", "contact", (Deserializer)ContactDeserializer.getInstance(), tokenizer);
    }

    public static Contact fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (Contact)Helper.deserialize("urn:uddi-org:api_v3", "contact", ContactDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.descriptionArrayList != null) {
            this.descriptionArrayList.check();
        }
        if (this.personNameArrayList == null || this.personNameArrayList.size() < 1) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "Contact.personNameArrayList"));
        }
        this.personNameArrayList.check();
        if (this.phoneArrayList != null) {
            this.phoneArrayList.check();
        }
        if (this.emailArrayList != null) {
            this.emailArrayList.check();
        }
        if (this.addressArrayList != null) {
            this.addressArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.descriptionArrayList != null) {
            if (this.descriptionArrayList.normalize()) {
                this.descriptionArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.personNameArrayList != null) {
            if (this.personNameArrayList.normalize()) {
                this.personNameArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.phoneArrayList != null) {
            if (this.phoneArrayList.normalize()) {
                this.phoneArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.emailArrayList != null) {
            if (this.emailArrayList.normalize()) {
                this.emailArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.addressArrayList != null) {
            if (this.addressArrayList.normalize()) {
                this.addressArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.useType != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Contact theClone = (Contact)super.clone();
        if (this.descriptionArrayList != null) {
            theClone.descriptionArrayList = (DescriptionArrayList)this.descriptionArrayList.clone();
        }
        if (this.personNameArrayList != null) {
            theClone.personNameArrayList = (PersonNameArrayList)this.personNameArrayList.clone();
        }
        if (this.phoneArrayList != null) {
            theClone.phoneArrayList = (PhoneArrayList)this.phoneArrayList.clone();
        }
        if (this.emailArrayList != null) {
            theClone.emailArrayList = (EmailArrayList)this.emailArrayList.clone();
        }
        if (this.addressArrayList != null) {
            theClone.addressArrayList = (AddressArrayList)this.addressArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Contact)) {
            return false;
        }
        Contact org_systinet_uddi_client_v3_struct_Contact = (Contact)o;
        boolean bl = this.descriptionArrayList != null ? !this.descriptionArrayList.equals(org_systinet_uddi_client_v3_struct_Contact.descriptionArrayList) : org_systinet_uddi_client_v3_struct_Contact.descriptionArrayList != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.personNameArrayList != null ? !this.personNameArrayList.equals(org_systinet_uddi_client_v3_struct_Contact.personNameArrayList) : org_systinet_uddi_client_v3_struct_Contact.personNameArrayList != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.phoneArrayList != null ? !this.phoneArrayList.equals(org_systinet_uddi_client_v3_struct_Contact.phoneArrayList) : org_systinet_uddi_client_v3_struct_Contact.phoneArrayList != null;
        if (bl3) {
            return false;
        }
        boolean bl4 = this.emailArrayList != null ? !this.emailArrayList.equals(org_systinet_uddi_client_v3_struct_Contact.emailArrayList) : org_systinet_uddi_client_v3_struct_Contact.emailArrayList != null;
        if (bl4) {
            return false;
        }
        boolean bl5 = this.addressArrayList != null ? !this.addressArrayList.equals(org_systinet_uddi_client_v3_struct_Contact.addressArrayList) : org_systinet_uddi_client_v3_struct_Contact.addressArrayList != null;
        if (bl5) {
            return false;
        }
        return !(this.useType != null ? !this.useType.equals(org_systinet_uddi_client_v3_struct_Contact.useType) : org_systinet_uddi_client_v3_struct_Contact.useType != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.descriptionArrayList != null ? this.descriptionArrayList.hashCode() : 0);
        result = 29 * result + (this.personNameArrayList != null ? this.personNameArrayList.hashCode() : 0);
        result = 29 * result + (this.phoneArrayList != null ? this.phoneArrayList.hashCode() : 0);
        result = 29 * result + (this.emailArrayList != null ? this.emailArrayList.hashCode() : 0);
        result = 29 * result + (this.addressArrayList != null ? this.addressArrayList.hashCode() : 0);
        result = 29 * result + (this.useType != null ? this.useType.hashCode() : 0);
        return result;
    }
}

