/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.BusinessServiceDeserializer;
import org.systinet.uddi.client.v3.serialization.BusinessServiceSerializer;
import org.systinet.uddi.client.v3.struct.BindingTemplate;
import org.systinet.uddi.client.v3.struct.BindingTemplateArrayList;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessService
extends UDDIObject
implements Cloneable,
Serializable {
    protected NameArrayList nameArrayList;
    protected DescriptionArrayList descriptionArrayList;
    protected BindingTemplateArrayList bindingTemplateArrayList;
    protected CategoryBag categoryBag;
    protected ElementArrayList SignatureArrayList;
    protected String serviceKey;
    protected String businessKey;

    public BusinessService() {
    }

    public BusinessService(NameArrayList nameArrayList, DescriptionArrayList descriptionArrayList, BindingTemplateArrayList bindingTemplateArrayList, CategoryBag categoryBag, ElementArrayList SignatureArrayList, String serviceKey, String businessKey) throws InvalidParameterException {
        this.setNameArrayList(nameArrayList);
        this.setDescriptionArrayList(descriptionArrayList);
        this.setBindingTemplateArrayList(bindingTemplateArrayList);
        this.setCategoryBag(categoryBag);
        this.setSignatureArrayList(SignatureArrayList);
        this.setServiceKey(serviceKey);
        this.setBusinessKey(businessKey);
    }

    public void addName(Name item) {
        if (this.nameArrayList == null) {
            this.nameArrayList = new NameArrayList();
        }
        this.nameArrayList.add(item);
    }

    public NameArrayList getNameArrayList() {
        return this.nameArrayList;
    }

    public void setNameArrayList(NameArrayList nameArrayList) throws InvalidParameterException {
        this.nameArrayList = nameArrayList;
    }

    public void addDescription(Description item) {
        if (this.descriptionArrayList == null) {
            this.descriptionArrayList = new DescriptionArrayList();
        }
        this.descriptionArrayList.add(item);
    }

    public DescriptionArrayList getDescriptionArrayList() {
        return this.descriptionArrayList;
    }

    public void setDescriptionArrayList(DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.descriptionArrayList = descriptionArrayList;
    }

    public void addBindingTemplate(BindingTemplate item) {
        if (this.bindingTemplateArrayList == null) {
            this.bindingTemplateArrayList = new BindingTemplateArrayList();
        }
        this.bindingTemplateArrayList.add(item);
    }

    public BindingTemplateArrayList getBindingTemplateArrayList() {
        return this.bindingTemplateArrayList;
    }

    public void setBindingTemplateArrayList(BindingTemplateArrayList bindingTemplateArrayList) {
        this.bindingTemplateArrayList = bindingTemplateArrayList;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        if (categoryBag != null) {
            // empty if block
        }
        this.categoryBag = categoryBag;
    }

    public void addSignature(Element item) {
        if (this.SignatureArrayList == null) {
            this.SignatureArrayList = new ElementArrayList();
        }
        this.SignatureArrayList.add(item);
    }

    public ElementArrayList getSignatureArrayList() {
        return this.SignatureArrayList;
    }

    public void setSignatureArrayList(ElementArrayList SignatureArrayList) throws InvalidParameterException {
        this.SignatureArrayList = SignatureArrayList;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) throws InvalidParameterException {
        if (serviceKey != null && (serviceKey = StringHelper.whitespaceCollapse(serviceKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.serviceKey = serviceKey;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) throws InvalidParameterException {
        if (businessKey != null && (businessKey = StringHelper.whitespaceCollapse(businessKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.businessKey = businessKey;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "businessService", BusinessServiceSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessService", (Serializer)BusinessServiceSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessService", (Serializer)BusinessServiceSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessService", (Serializer)BusinessServiceSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessService", (Serializer)BusinessServiceSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "businessService", BusinessServiceSerializer.getInstance(), tokenWriter, mapping);
    }

    public static BusinessService fromXML(String string) throws InvalidParameterException, WrappedException {
        return (BusinessService)Helper.deserialize("urn:uddi-org:api_v3", "businessService", (Deserializer)BusinessServiceDeserializer.getInstance(), string);
    }

    public static BusinessService fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (BusinessService)Helper.deserialize("urn:uddi-org:api_v3", "businessService", (Deserializer)BusinessServiceDeserializer.getInstance(), element);
    }

    public static BusinessService fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (BusinessService)Helper.deserialize("urn:uddi-org:api_v3", "businessService", (Deserializer)BusinessServiceDeserializer.getInstance(), reader);
    }

    public static BusinessService fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (BusinessService)Helper.deserialize("urn:uddi-org:api_v3", "businessService", (Deserializer)BusinessServiceDeserializer.getInstance(), tokenizer);
    }

    public static BusinessService fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (BusinessService)Helper.deserialize("urn:uddi-org:api_v3", "businessService", BusinessServiceDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.nameArrayList != null) {
            this.nameArrayList.check();
        }
        if (this.descriptionArrayList != null) {
            this.descriptionArrayList.check();
        }
        if (this.bindingTemplateArrayList != null) {
            if (this.bindingTemplateArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessService.bindingTemplateArrayList"));
            }
            this.bindingTemplateArrayList.check();
        }
        if (this.categoryBag != null) {
            this.categoryBag.check();
        }
        if (this.SignatureArrayList != null) {
            this.SignatureArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.nameArrayList != null) {
            if (this.nameArrayList.normalize()) {
                this.nameArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.descriptionArrayList != null) {
            if (this.descriptionArrayList.normalize()) {
                this.descriptionArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.bindingTemplateArrayList != null) {
            if (this.bindingTemplateArrayList.normalize()) {
                this.bindingTemplateArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.categoryBag != null) {
            if (this.categoryBag.normalize()) {
                this.categoryBag = null;
            } else {
                result = false;
            }
        }
        if (this.SignatureArrayList != null) {
            if (this.SignatureArrayList.normalize()) {
                this.SignatureArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.serviceKey != null) {
            result = false;
        }
        if (this.businessKey != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        BusinessService theClone = (BusinessService)super.clone();
        if (this.nameArrayList != null) {
            theClone.nameArrayList = (NameArrayList)this.nameArrayList.clone();
        }
        if (this.descriptionArrayList != null) {
            theClone.descriptionArrayList = (DescriptionArrayList)this.descriptionArrayList.clone();
        }
        if (this.bindingTemplateArrayList != null) {
            theClone.bindingTemplateArrayList = (BindingTemplateArrayList)this.bindingTemplateArrayList.clone();
        }
        if (this.categoryBag != null) {
            theClone.categoryBag = (CategoryBag)this.categoryBag.clone();
        }
        if (this.SignatureArrayList != null) {
            theClone.SignatureArrayList = (ElementArrayList)this.SignatureArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BusinessService)) {
            return false;
        }
        BusinessService org_systinet_uddi_client_v3_struct_BusinessService = (BusinessService)o;
        boolean bl = this.nameArrayList != null ? !this.nameArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessService.nameArrayList) : org_systinet_uddi_client_v3_struct_BusinessService.nameArrayList != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.descriptionArrayList != null ? !this.descriptionArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessService.descriptionArrayList) : org_systinet_uddi_client_v3_struct_BusinessService.descriptionArrayList != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.bindingTemplateArrayList != null ? !this.bindingTemplateArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessService.bindingTemplateArrayList) : org_systinet_uddi_client_v3_struct_BusinessService.bindingTemplateArrayList != null;
        if (bl3) {
            return false;
        }
        boolean bl4 = this.categoryBag != null ? !this.categoryBag.equals(org_systinet_uddi_client_v3_struct_BusinessService.categoryBag) : org_systinet_uddi_client_v3_struct_BusinessService.categoryBag != null;
        if (bl4) {
            return false;
        }
        boolean bl5 = this.SignatureArrayList != null ? !this.SignatureArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessService.SignatureArrayList) : org_systinet_uddi_client_v3_struct_BusinessService.SignatureArrayList != null;
        if (bl5) {
            return false;
        }
        boolean bl6 = this.serviceKey != null ? !this.serviceKey.equals(org_systinet_uddi_client_v3_struct_BusinessService.serviceKey) : org_systinet_uddi_client_v3_struct_BusinessService.serviceKey != null;
        if (bl6) {
            return false;
        }
        return !(this.businessKey != null ? !this.businessKey.equals(org_systinet_uddi_client_v3_struct_BusinessService.businessKey) : org_systinet_uddi_client_v3_struct_BusinessService.businessKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.nameArrayList != null ? this.nameArrayList.hashCode() : 0);
        result = 29 * result + (this.descriptionArrayList != null ? this.descriptionArrayList.hashCode() : 0);
        result = 29 * result + (this.bindingTemplateArrayList != null ? this.bindingTemplateArrayList.hashCode() : 0);
        result = 29 * result + (this.categoryBag != null ? this.categoryBag.hashCode() : 0);
        result = 29 * result + (this.SignatureArrayList != null ? this.SignatureArrayList.hashCode() : 0);
        result = 29 * result + (this.serviceKey != null ? this.serviceKey.hashCode() : 0);
        result = 29 * result + (this.businessKey != null ? this.businessKey.hashCode() : 0);
        return result;
    }
}

