/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.serialization.BusinessListDeserializer;
import org.systinet.uddi.client.v3.serialization.BusinessListSerializer;
import org.systinet.uddi.client.v3.struct.BusinessInfo;
import org.systinet.uddi.client.v3.struct.BusinessInfoArrayList;
import org.systinet.uddi.client.v3.struct.ListDescription;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessList
extends UDDIObject
implements Cloneable,
Serializable {
    protected ListDescription listDescription;
    protected BusinessInfoArrayList businessInfoArrayList;
    protected Boolean truncated;

    public BusinessList() {
    }

    public BusinessList(ListDescription listDescription, BusinessInfoArrayList businessInfoArrayList, Boolean truncated) throws InvalidParameterException {
        this.setListDescription(listDescription);
        this.setBusinessInfoArrayList(businessInfoArrayList);
        this.setTruncated(truncated);
    }

    public ListDescription getListDescription() {
        return this.listDescription;
    }

    public void setListDescription(ListDescription listDescription) {
        if (listDescription != null) {
            // empty if block
        }
        this.listDescription = listDescription;
    }

    public void addBusinessInfo(BusinessInfo item) {
        if (this.businessInfoArrayList == null) {
            this.businessInfoArrayList = new BusinessInfoArrayList();
        }
        this.businessInfoArrayList.add(item);
    }

    public BusinessInfoArrayList getBusinessInfoArrayList() {
        return this.businessInfoArrayList;
    }

    public void setBusinessInfoArrayList(BusinessInfoArrayList businessInfoArrayList) {
        this.businessInfoArrayList = businessInfoArrayList;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        if (truncated != null) {
            // empty if block
        }
        this.truncated = truncated;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "businessList", BusinessListSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessList", (Serializer)BusinessListSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessList", (Serializer)BusinessListSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessList", (Serializer)BusinessListSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessList", (Serializer)BusinessListSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "businessList", BusinessListSerializer.getInstance(), tokenWriter, mapping);
    }

    public static BusinessList fromXML(String string) throws InvalidParameterException, WrappedException {
        return (BusinessList)Helper.deserialize("urn:uddi-org:api_v3", "businessList", (Deserializer)BusinessListDeserializer.getInstance(), string);
    }

    public static BusinessList fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (BusinessList)Helper.deserialize("urn:uddi-org:api_v3", "businessList", (Deserializer)BusinessListDeserializer.getInstance(), element);
    }

    public static BusinessList fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (BusinessList)Helper.deserialize("urn:uddi-org:api_v3", "businessList", (Deserializer)BusinessListDeserializer.getInstance(), reader);
    }

    public static BusinessList fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (BusinessList)Helper.deserialize("urn:uddi-org:api_v3", "businessList", (Deserializer)BusinessListDeserializer.getInstance(), tokenizer);
    }

    public static BusinessList fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (BusinessList)Helper.deserialize("urn:uddi-org:api_v3", "businessList", BusinessListDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.listDescription != null) {
            this.listDescription.check();
        }
        if (this.businessInfoArrayList != null) {
            if (this.businessInfoArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessList.businessInfoArrayList"));
            }
            this.businessInfoArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.listDescription != null) {
            if (this.listDescription.normalize()) {
                this.listDescription = null;
            } else {
                result = false;
            }
        }
        if (this.businessInfoArrayList != null) {
            if (this.businessInfoArrayList.normalize()) {
                this.businessInfoArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.truncated != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        BusinessList theClone = (BusinessList)super.clone();
        if (this.listDescription != null) {
            theClone.listDescription = (ListDescription)this.listDescription.clone();
        }
        if (this.businessInfoArrayList != null) {
            theClone.businessInfoArrayList = (BusinessInfoArrayList)this.businessInfoArrayList.clone();
        }
        if (this.truncated != null) {
            theClone.truncated = new Boolean(this.truncated);
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BusinessList)) {
            return false;
        }
        BusinessList org_systinet_uddi_client_v3_struct_BusinessList = (BusinessList)o;
        boolean bl = this.listDescription != null ? !this.listDescription.equals(org_systinet_uddi_client_v3_struct_BusinessList.listDescription) : org_systinet_uddi_client_v3_struct_BusinessList.listDescription != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.businessInfoArrayList != null ? !this.businessInfoArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessList.businessInfoArrayList) : org_systinet_uddi_client_v3_struct_BusinessList.businessInfoArrayList != null;
        if (bl2) {
            return false;
        }
        return !(this.truncated != null ? !this.truncated.equals(org_systinet_uddi_client_v3_struct_BusinessList.truncated) : org_systinet_uddi_client_v3_struct_BusinessList.truncated != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.listDescription != null ? this.listDescription.hashCode() : 0);
        result = 29 * result + (this.businessInfoArrayList != null ? this.businessInfoArrayList.hashCode() : 0);
        result = 29 * result + (this.truncated != null ? this.truncated.hashCode() : 0);
        return result;
    }
}

