/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.BusinessInfoDeserializer;
import org.systinet.uddi.client.v3.serialization.BusinessInfoSerializer;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.uddi.client.v3.struct.ServiceInfo;
import org.systinet.uddi.client.v3.struct.ServiceInfoArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessInfo
extends UDDIObject
implements Cloneable,
Serializable {
    protected NameArrayList nameArrayList;
    protected DescriptionArrayList descriptionArrayList;
    protected ServiceInfoArrayList serviceInfoArrayList;
    protected String businessKey;

    public BusinessInfo() {
    }

    public BusinessInfo(NameArrayList nameArrayList, String businessKey) throws InvalidParameterException {
        this.setNameArrayList(nameArrayList);
        this.setBusinessKey(businessKey);
    }

    public BusinessInfo(NameArrayList nameArrayList, String businessKey, DescriptionArrayList descriptionArrayList, ServiceInfoArrayList serviceInfoArrayList) throws InvalidParameterException {
        this.setNameArrayList(nameArrayList);
        this.setBusinessKey(businessKey);
        this.setDescriptionArrayList(descriptionArrayList);
        this.setServiceInfoArrayList(serviceInfoArrayList);
    }

    public void addName(Name item) {
        if (this.nameArrayList == null) {
            this.nameArrayList = new NameArrayList();
        }
        this.nameArrayList.add(item);
    }

    public NameArrayList getNameArrayList() {
        return this.nameArrayList;
    }

    public void setNameArrayList(NameArrayList nameArrayList) throws InvalidParameterException {
        if (nameArrayList == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "nameArrayList"));
        }
        this.nameArrayList = nameArrayList;
    }

    public void addDescription(Description item) {
        if (this.descriptionArrayList == null) {
            this.descriptionArrayList = new DescriptionArrayList();
        }
        this.descriptionArrayList.add(item);
    }

    public DescriptionArrayList getDescriptionArrayList() {
        return this.descriptionArrayList;
    }

    public void setDescriptionArrayList(DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.descriptionArrayList = descriptionArrayList;
    }

    public void addServiceInfo(ServiceInfo item) {
        if (this.serviceInfoArrayList == null) {
            this.serviceInfoArrayList = new ServiceInfoArrayList();
        }
        this.serviceInfoArrayList.add(item);
    }

    public ServiceInfoArrayList getServiceInfoArrayList() {
        return this.serviceInfoArrayList;
    }

    public void setServiceInfoArrayList(ServiceInfoArrayList serviceInfoArrayList) {
        this.serviceInfoArrayList = serviceInfoArrayList;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) throws InvalidParameterException {
        if (businessKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessInfo.businessKey"));
        }
        if (businessKey != null && (businessKey = StringHelper.whitespaceCollapse(businessKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.businessKey = businessKey;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "businessInfo", BusinessInfoSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessInfo", (Serializer)BusinessInfoSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessInfo", (Serializer)BusinessInfoSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessInfo", (Serializer)BusinessInfoSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessInfo", (Serializer)BusinessInfoSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "businessInfo", BusinessInfoSerializer.getInstance(), tokenWriter, mapping);
    }

    public static BusinessInfo fromXML(String string) throws InvalidParameterException, WrappedException {
        return (BusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "businessInfo", (Deserializer)BusinessInfoDeserializer.getInstance(), string);
    }

    public static BusinessInfo fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (BusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "businessInfo", (Deserializer)BusinessInfoDeserializer.getInstance(), element);
    }

    public static BusinessInfo fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (BusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "businessInfo", (Deserializer)BusinessInfoDeserializer.getInstance(), reader);
    }

    public static BusinessInfo fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (BusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "businessInfo", (Deserializer)BusinessInfoDeserializer.getInstance(), tokenizer);
    }

    public static BusinessInfo fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (BusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "businessInfo", BusinessInfoDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.nameArrayList == null || this.nameArrayList.size() < 1) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessInfo.nameArrayList"));
        }
        this.nameArrayList.check();
        if (this.descriptionArrayList != null) {
            this.descriptionArrayList.check();
        }
        if (this.serviceInfoArrayList != null) {
            if (this.serviceInfoArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessInfo.serviceInfoArrayList"));
            }
            this.serviceInfoArrayList.check();
        }
        if (this.businessKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessInfo.businessKey"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.nameArrayList != null) {
            if (this.nameArrayList.normalize()) {
                this.nameArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.descriptionArrayList != null) {
            if (this.descriptionArrayList.normalize()) {
                this.descriptionArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.serviceInfoArrayList != null) {
            if (this.serviceInfoArrayList.normalize()) {
                this.serviceInfoArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.businessKey != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        BusinessInfo theClone = (BusinessInfo)super.clone();
        if (this.nameArrayList != null) {
            theClone.nameArrayList = (NameArrayList)this.nameArrayList.clone();
        }
        if (this.descriptionArrayList != null) {
            theClone.descriptionArrayList = (DescriptionArrayList)this.descriptionArrayList.clone();
        }
        if (this.serviceInfoArrayList != null) {
            theClone.serviceInfoArrayList = (ServiceInfoArrayList)this.serviceInfoArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BusinessInfo)) {
            return false;
        }
        BusinessInfo org_systinet_uddi_client_v3_struct_BusinessInfo = (BusinessInfo)o;
        boolean bl = this.nameArrayList != null ? !this.nameArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessInfo.nameArrayList) : org_systinet_uddi_client_v3_struct_BusinessInfo.nameArrayList != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.descriptionArrayList != null ? !this.descriptionArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessInfo.descriptionArrayList) : org_systinet_uddi_client_v3_struct_BusinessInfo.descriptionArrayList != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.serviceInfoArrayList != null ? !this.serviceInfoArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessInfo.serviceInfoArrayList) : org_systinet_uddi_client_v3_struct_BusinessInfo.serviceInfoArrayList != null;
        if (bl3) {
            return false;
        }
        return !(this.businessKey != null ? !this.businessKey.equals(org_systinet_uddi_client_v3_struct_BusinessInfo.businessKey) : org_systinet_uddi_client_v3_struct_BusinessInfo.businessKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.nameArrayList != null ? this.nameArrayList.hashCode() : 0);
        result = 29 * result + (this.descriptionArrayList != null ? this.descriptionArrayList.hashCode() : 0);
        result = 29 * result + (this.serviceInfoArrayList != null ? this.serviceInfoArrayList.hashCode() : 0);
        result = 29 * result + (this.businessKey != null ? this.businessKey.hashCode() : 0);
        return result;
    }
}

