/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.BusinessEntityDeserializer;
import org.systinet.uddi.client.v3.serialization.BusinessEntitySerializer;
import org.systinet.uddi.client.v3.struct.BusinessService;
import org.systinet.uddi.client.v3.struct.BusinessServiceArrayList;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Contact;
import org.systinet.uddi.client.v3.struct.ContactArrayList;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DiscoveryURL;
import org.systinet.uddi.client.v3.struct.DiscoveryURLArrayList;
import org.systinet.uddi.client.v3.struct.IdentifierBag;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BusinessEntity
extends UDDIObject
implements Cloneable,
Serializable {
    protected DiscoveryURLArrayList discoveryURLArrayList;
    protected NameArrayList nameArrayList;
    protected DescriptionArrayList descriptionArrayList;
    protected ContactArrayList contactArrayList;
    protected BusinessServiceArrayList businessServiceArrayList;
    protected IdentifierBag identifierBag;
    protected CategoryBag categoryBag;
    protected ElementArrayList SignatureArrayList;
    protected String businessKey;

    public BusinessEntity() {
    }

    public BusinessEntity(NameArrayList nameArrayList) throws InvalidParameterException {
        this.setNameArrayList(nameArrayList);
    }

    public BusinessEntity(NameArrayList nameArrayList, DiscoveryURLArrayList discoveryURLArrayList, DescriptionArrayList descriptionArrayList, ContactArrayList contactArrayList, BusinessServiceArrayList businessServiceArrayList, IdentifierBag identifierBag, CategoryBag categoryBag, ElementArrayList SignatureArrayList, String businessKey) throws InvalidParameterException {
        this.setNameArrayList(nameArrayList);
        this.setDiscoveryURLArrayList(discoveryURLArrayList);
        this.setDescriptionArrayList(descriptionArrayList);
        this.setContactArrayList(contactArrayList);
        this.setBusinessServiceArrayList(businessServiceArrayList);
        this.setIdentifierBag(identifierBag);
        this.setCategoryBag(categoryBag);
        this.setSignatureArrayList(SignatureArrayList);
        this.setBusinessKey(businessKey);
    }

    public void addDiscoveryURL(DiscoveryURL item) {
        if (this.discoveryURLArrayList == null) {
            this.discoveryURLArrayList = new DiscoveryURLArrayList();
        }
        this.discoveryURLArrayList.add(item);
    }

    public DiscoveryURLArrayList getDiscoveryURLArrayList() {
        return this.discoveryURLArrayList;
    }

    public void setDiscoveryURLArrayList(DiscoveryURLArrayList discoveryURLArrayList) {
        this.discoveryURLArrayList = discoveryURLArrayList;
    }

    public void addName(Name item) {
        if (this.nameArrayList == null) {
            this.nameArrayList = new NameArrayList();
        }
        this.nameArrayList.add(item);
    }

    public NameArrayList getNameArrayList() {
        return this.nameArrayList;
    }

    public void setNameArrayList(NameArrayList nameArrayList) throws InvalidParameterException {
        if (nameArrayList == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "nameArrayList"));
        }
        this.nameArrayList = nameArrayList;
    }

    public void addDescription(Description item) {
        if (this.descriptionArrayList == null) {
            this.descriptionArrayList = new DescriptionArrayList();
        }
        this.descriptionArrayList.add(item);
    }

    public DescriptionArrayList getDescriptionArrayList() {
        return this.descriptionArrayList;
    }

    public void setDescriptionArrayList(DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.descriptionArrayList = descriptionArrayList;
    }

    public void addContact(Contact item) {
        if (this.contactArrayList == null) {
            this.contactArrayList = new ContactArrayList();
        }
        this.contactArrayList.add(item);
    }

    public ContactArrayList getContactArrayList() {
        return this.contactArrayList;
    }

    public void setContactArrayList(ContactArrayList contactArrayList) {
        this.contactArrayList = contactArrayList;
    }

    public void addBusinessService(BusinessService item) {
        if (this.businessServiceArrayList == null) {
            this.businessServiceArrayList = new BusinessServiceArrayList();
        }
        this.businessServiceArrayList.add(item);
    }

    public BusinessServiceArrayList getBusinessServiceArrayList() {
        return this.businessServiceArrayList;
    }

    public void setBusinessServiceArrayList(BusinessServiceArrayList businessServiceArrayList) {
        this.businessServiceArrayList = businessServiceArrayList;
    }

    public IdentifierBag getIdentifierBag() {
        return this.identifierBag;
    }

    public void setIdentifierBag(IdentifierBag identifierBag) {
        if (identifierBag != null) {
            // empty if block
        }
        this.identifierBag = identifierBag;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        if (categoryBag != null) {
            // empty if block
        }
        this.categoryBag = categoryBag;
    }

    public void addSignature(Element item) {
        if (this.SignatureArrayList == null) {
            this.SignatureArrayList = new ElementArrayList();
        }
        this.SignatureArrayList.add(item);
    }

    public ElementArrayList getSignatureArrayList() {
        return this.SignatureArrayList;
    }

    public void setSignatureArrayList(ElementArrayList SignatureArrayList) throws InvalidParameterException {
        this.SignatureArrayList = SignatureArrayList;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) throws InvalidParameterException {
        if (businessKey != null && (businessKey = StringHelper.whitespaceCollapse(businessKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.businessKey = businessKey;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "businessEntity", BusinessEntitySerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessEntity", (Serializer)BusinessEntitySerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessEntity", (Serializer)BusinessEntitySerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessEntity", (Serializer)BusinessEntitySerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "businessEntity", (Serializer)BusinessEntitySerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "businessEntity", BusinessEntitySerializer.getInstance(), tokenWriter, mapping);
    }

    public static BusinessEntity fromXML(String string) throws InvalidParameterException, WrappedException {
        return (BusinessEntity)Helper.deserialize("urn:uddi-org:api_v3", "businessEntity", (Deserializer)BusinessEntityDeserializer.getInstance(), string);
    }

    public static BusinessEntity fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (BusinessEntity)Helper.deserialize("urn:uddi-org:api_v3", "businessEntity", (Deserializer)BusinessEntityDeserializer.getInstance(), element);
    }

    public static BusinessEntity fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (BusinessEntity)Helper.deserialize("urn:uddi-org:api_v3", "businessEntity", (Deserializer)BusinessEntityDeserializer.getInstance(), reader);
    }

    public static BusinessEntity fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (BusinessEntity)Helper.deserialize("urn:uddi-org:api_v3", "businessEntity", (Deserializer)BusinessEntityDeserializer.getInstance(), tokenizer);
    }

    public static BusinessEntity fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (BusinessEntity)Helper.deserialize("urn:uddi-org:api_v3", "businessEntity", BusinessEntityDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.discoveryURLArrayList != null) {
            if (this.discoveryURLArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessEntity.discoveryURLArrayList"));
            }
            this.discoveryURLArrayList.check();
        }
        if (this.nameArrayList == null || this.nameArrayList.size() < 1) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessEntity.nameArrayList"));
        }
        this.nameArrayList.check();
        if (this.descriptionArrayList != null) {
            this.descriptionArrayList.check();
        }
        if (this.contactArrayList != null) {
            if (this.contactArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessEntity.contactArrayList"));
            }
            this.contactArrayList.check();
        }
        if (this.businessServiceArrayList != null) {
            if (this.businessServiceArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BusinessEntity.businessServiceArrayList"));
            }
            this.businessServiceArrayList.check();
        }
        if (this.identifierBag != null) {
            this.identifierBag.check();
        }
        if (this.categoryBag != null) {
            this.categoryBag.check();
        }
        if (this.SignatureArrayList != null) {
            this.SignatureArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.discoveryURLArrayList != null) {
            if (this.discoveryURLArrayList.normalize()) {
                this.discoveryURLArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.nameArrayList != null) {
            if (this.nameArrayList.normalize()) {
                this.nameArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.descriptionArrayList != null) {
            if (this.descriptionArrayList.normalize()) {
                this.descriptionArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.contactArrayList != null) {
            if (this.contactArrayList.normalize()) {
                this.contactArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.businessServiceArrayList != null) {
            if (this.businessServiceArrayList.normalize()) {
                this.businessServiceArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.identifierBag != null) {
            if (this.identifierBag.normalize()) {
                this.identifierBag = null;
            } else {
                result = false;
            }
        }
        if (this.categoryBag != null) {
            if (this.categoryBag.normalize()) {
                this.categoryBag = null;
            } else {
                result = false;
            }
        }
        if (this.SignatureArrayList != null) {
            if (this.SignatureArrayList.normalize()) {
                this.SignatureArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.businessKey != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        BusinessEntity theClone = (BusinessEntity)super.clone();
        if (this.discoveryURLArrayList != null) {
            theClone.discoveryURLArrayList = (DiscoveryURLArrayList)this.discoveryURLArrayList.clone();
        }
        if (this.nameArrayList != null) {
            theClone.nameArrayList = (NameArrayList)this.nameArrayList.clone();
        }
        if (this.descriptionArrayList != null) {
            theClone.descriptionArrayList = (DescriptionArrayList)this.descriptionArrayList.clone();
        }
        if (this.contactArrayList != null) {
            theClone.contactArrayList = (ContactArrayList)this.contactArrayList.clone();
        }
        if (this.businessServiceArrayList != null) {
            theClone.businessServiceArrayList = (BusinessServiceArrayList)this.businessServiceArrayList.clone();
        }
        if (this.identifierBag != null) {
            theClone.identifierBag = (IdentifierBag)this.identifierBag.clone();
        }
        if (this.categoryBag != null) {
            theClone.categoryBag = (CategoryBag)this.categoryBag.clone();
        }
        if (this.SignatureArrayList != null) {
            theClone.SignatureArrayList = (ElementArrayList)this.SignatureArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BusinessEntity)) {
            return false;
        }
        BusinessEntity org_systinet_uddi_client_v3_struct_BusinessEntity = (BusinessEntity)o;
        boolean bl = this.discoveryURLArrayList != null ? !this.discoveryURLArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.discoveryURLArrayList) : org_systinet_uddi_client_v3_struct_BusinessEntity.discoveryURLArrayList != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.nameArrayList != null ? !this.nameArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.nameArrayList) : org_systinet_uddi_client_v3_struct_BusinessEntity.nameArrayList != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.descriptionArrayList != null ? !this.descriptionArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.descriptionArrayList) : org_systinet_uddi_client_v3_struct_BusinessEntity.descriptionArrayList != null;
        if (bl3) {
            return false;
        }
        boolean bl4 = this.contactArrayList != null ? !this.contactArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.contactArrayList) : org_systinet_uddi_client_v3_struct_BusinessEntity.contactArrayList != null;
        if (bl4) {
            return false;
        }
        boolean bl5 = this.businessServiceArrayList != null ? !this.businessServiceArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.businessServiceArrayList) : org_systinet_uddi_client_v3_struct_BusinessEntity.businessServiceArrayList != null;
        if (bl5) {
            return false;
        }
        boolean bl6 = this.identifierBag != null ? !this.identifierBag.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.identifierBag) : org_systinet_uddi_client_v3_struct_BusinessEntity.identifierBag != null;
        if (bl6) {
            return false;
        }
        boolean bl7 = this.categoryBag != null ? !this.categoryBag.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.categoryBag) : org_systinet_uddi_client_v3_struct_BusinessEntity.categoryBag != null;
        if (bl7) {
            return false;
        }
        boolean bl8 = this.SignatureArrayList != null ? !this.SignatureArrayList.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.SignatureArrayList) : org_systinet_uddi_client_v3_struct_BusinessEntity.SignatureArrayList != null;
        if (bl8) {
            return false;
        }
        return !(this.businessKey != null ? !this.businessKey.equals(org_systinet_uddi_client_v3_struct_BusinessEntity.businessKey) : org_systinet_uddi_client_v3_struct_BusinessEntity.businessKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.discoveryURLArrayList != null ? this.discoveryURLArrayList.hashCode() : 0);
        result = 29 * result + (this.nameArrayList != null ? this.nameArrayList.hashCode() : 0);
        result = 29 * result + (this.descriptionArrayList != null ? this.descriptionArrayList.hashCode() : 0);
        result = 29 * result + (this.contactArrayList != null ? this.contactArrayList.hashCode() : 0);
        result = 29 * result + (this.businessServiceArrayList != null ? this.businessServiceArrayList.hashCode() : 0);
        result = 29 * result + (this.identifierBag != null ? this.identifierBag.hashCode() : 0);
        result = 29 * result + (this.categoryBag != null ? this.categoryBag.hashCode() : 0);
        result = 29 * result + (this.SignatureArrayList != null ? this.SignatureArrayList.hashCode() : 0);
        result = 29 * result + (this.businessKey != null ? this.businessKey.hashCode() : 0);
        return result;
    }
}

