/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.BindingTemplateDeserializer;
import org.systinet.uddi.client.v3.serialization.BindingTemplateSerializer;
import org.systinet.uddi.client.v3.struct.AccessPoint;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.HostingRedirector;
import org.systinet.uddi.client.v3.struct.TModelInstanceInfo;
import org.systinet.uddi.client.v3.struct.TModelInstanceInfoArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BindingTemplate
extends UDDIObject
implements Cloneable,
Serializable {
    protected DescriptionArrayList descriptionArrayList;
    protected AccessPoint accessPoint;
    protected HostingRedirector hostingRedirector;
    protected TModelInstanceInfoArrayList tModelInstanceInfoArrayList;
    protected CategoryBag categoryBag;
    protected ElementArrayList SignatureArrayList;
    protected String bindingKey;
    protected String serviceKey;

    public BindingTemplate() {
    }

    public BindingTemplate(AccessPoint accessPoint) throws InvalidParameterException {
        this.setAccessPoint(accessPoint);
    }

    public BindingTemplate(AccessPoint accessPoint, DescriptionArrayList descriptionArrayList, TModelInstanceInfoArrayList tModelInstanceInfoArrayList, CategoryBag categoryBag, ElementArrayList SignatureArrayList, String bindingKey, String serviceKey) throws InvalidParameterException {
        this.setAccessPoint(accessPoint);
        this.setDescriptionArrayList(descriptionArrayList);
        this.setTModelInstanceInfoArrayList(tModelInstanceInfoArrayList);
        this.setCategoryBag(categoryBag);
        this.setSignatureArrayList(SignatureArrayList);
        this.setBindingKey(bindingKey);
        this.setServiceKey(serviceKey);
    }

    public BindingTemplate(HostingRedirector hostingRedirector) throws InvalidParameterException {
        this.setHostingRedirector(hostingRedirector);
    }

    public BindingTemplate(HostingRedirector hostingRedirector, DescriptionArrayList descriptionArrayList, TModelInstanceInfoArrayList tModelInstanceInfoArrayList, CategoryBag categoryBag, ElementArrayList SignatureArrayList, String bindingKey, String serviceKey) throws InvalidParameterException {
        this.setHostingRedirector(hostingRedirector);
        this.setDescriptionArrayList(descriptionArrayList);
        this.setTModelInstanceInfoArrayList(tModelInstanceInfoArrayList);
        this.setCategoryBag(categoryBag);
        this.setSignatureArrayList(SignatureArrayList);
        this.setBindingKey(bindingKey);
        this.setServiceKey(serviceKey);
    }

    public void addDescription(Description item) {
        if (this.descriptionArrayList == null) {
            this.descriptionArrayList = new DescriptionArrayList();
        }
        this.descriptionArrayList.add(item);
    }

    public DescriptionArrayList getDescriptionArrayList() {
        return this.descriptionArrayList;
    }

    public void setDescriptionArrayList(DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.descriptionArrayList = descriptionArrayList;
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public void setAccessPoint(AccessPoint accessPoint) throws InvalidParameterException {
        if (accessPoint == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BindingTemplate.accessPoint"));
        }
        this.clearChoice("accessPoint");
        if (accessPoint != null) {
            // empty if block
        }
        this.accessPoint = accessPoint;
    }

    public HostingRedirector getHostingRedirector() {
        return this.hostingRedirector;
    }

    public void setHostingRedirector(HostingRedirector hostingRedirector) throws InvalidParameterException {
        if (hostingRedirector == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BindingTemplate.hostingRedirector"));
        }
        this.clearChoice("hostingRedirector");
        if (hostingRedirector != null) {
            // empty if block
        }
        this.hostingRedirector = hostingRedirector;
    }

    public void addTModelInstanceInfo(TModelInstanceInfo item) {
        if (this.tModelInstanceInfoArrayList == null) {
            this.tModelInstanceInfoArrayList = new TModelInstanceInfoArrayList();
        }
        this.tModelInstanceInfoArrayList.add(item);
    }

    public TModelInstanceInfoArrayList getTModelInstanceInfoArrayList() {
        return this.tModelInstanceInfoArrayList;
    }

    public void setTModelInstanceInfoArrayList(TModelInstanceInfoArrayList tModelInstanceInfoArrayList) {
        this.tModelInstanceInfoArrayList = tModelInstanceInfoArrayList;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        if (categoryBag != null) {
            // empty if block
        }
        this.categoryBag = categoryBag;
    }

    public void addSignature(Element item) {
        if (this.SignatureArrayList == null) {
            this.SignatureArrayList = new ElementArrayList();
        }
        this.SignatureArrayList.add(item);
    }

    public ElementArrayList getSignatureArrayList() {
        return this.SignatureArrayList;
    }

    public void setSignatureArrayList(ElementArrayList SignatureArrayList) throws InvalidParameterException {
        this.SignatureArrayList = SignatureArrayList;
    }

    public String getBindingKey() {
        return this.bindingKey;
    }

    public void setBindingKey(String bindingKey) throws InvalidParameterException {
        if (bindingKey != null && (bindingKey = StringHelper.whitespaceCollapse(bindingKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.bindingKey = bindingKey;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) throws InvalidParameterException {
        if (serviceKey != null && (serviceKey = StringHelper.whitespaceCollapse(serviceKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.serviceKey = serviceKey;
    }

    private void clearChoice(String fieldName) {
        if (fieldName.equals("accessPoint")) {
            this.hostingRedirector = null;
        } else if (fieldName.equals("hostingRedirector")) {
            this.accessPoint = null;
        }
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "bindingTemplate", BindingTemplateSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "bindingTemplate", (Serializer)BindingTemplateSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "bindingTemplate", (Serializer)BindingTemplateSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "bindingTemplate", (Serializer)BindingTemplateSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "bindingTemplate", (Serializer)BindingTemplateSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "bindingTemplate", BindingTemplateSerializer.getInstance(), tokenWriter, mapping);
    }

    public static BindingTemplate fromXML(String string) throws InvalidParameterException, WrappedException {
        return (BindingTemplate)Helper.deserialize("urn:uddi-org:api_v3", "bindingTemplate", (Deserializer)BindingTemplateDeserializer.getInstance(), string);
    }

    public static BindingTemplate fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (BindingTemplate)Helper.deserialize("urn:uddi-org:api_v3", "bindingTemplate", (Deserializer)BindingTemplateDeserializer.getInstance(), element);
    }

    public static BindingTemplate fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (BindingTemplate)Helper.deserialize("urn:uddi-org:api_v3", "bindingTemplate", (Deserializer)BindingTemplateDeserializer.getInstance(), reader);
    }

    public static BindingTemplate fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (BindingTemplate)Helper.deserialize("urn:uddi-org:api_v3", "bindingTemplate", (Deserializer)BindingTemplateDeserializer.getInstance(), tokenizer);
    }

    public static BindingTemplate fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (BindingTemplate)Helper.deserialize("urn:uddi-org:api_v3", "bindingTemplate", BindingTemplateDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.descriptionArrayList != null) {
            this.descriptionArrayList.check();
        }
        if (this.accessPoint != null) {
            this.accessPoint.check();
            if (this.hostingRedirector != null) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_UNSUPPORTED, ResourceBundle.getString("EXC_CheckMethod_P1", "BindingTemplate"));
            }
        } else if (this.hostingRedirector != null) {
            this.hostingRedirector.check();
            if (this.accessPoint != null) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_UNSUPPORTED, ResourceBundle.getString("EXC_CheckMethod_P1", "BindingTemplate"));
            }
        } else {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_UNSUPPORTED, ResourceBundle.getString("EXC_CheckMethod_P1", "BindingTemplate"));
        }
        if (this.tModelInstanceInfoArrayList != null) {
            if (this.tModelInstanceInfoArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "BindingTemplate.tModelInstanceInfoArrayList"));
            }
            this.tModelInstanceInfoArrayList.check();
        }
        if (this.categoryBag != null) {
            this.categoryBag.check();
        }
        if (this.SignatureArrayList != null) {
            this.SignatureArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.descriptionArrayList != null) {
            if (this.descriptionArrayList.normalize()) {
                this.descriptionArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.accessPoint != null) {
            if (this.accessPoint.normalize()) {
                this.accessPoint = null;
            } else {
                result = false;
            }
        }
        if (this.hostingRedirector != null) {
            if (this.hostingRedirector.normalize()) {
                this.hostingRedirector = null;
            } else {
                result = false;
            }
        }
        if (this.tModelInstanceInfoArrayList != null) {
            if (this.tModelInstanceInfoArrayList.normalize()) {
                this.tModelInstanceInfoArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.categoryBag != null) {
            if (this.categoryBag.normalize()) {
                this.categoryBag = null;
            } else {
                result = false;
            }
        }
        if (this.SignatureArrayList != null) {
            if (this.SignatureArrayList.normalize()) {
                this.SignatureArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.bindingKey != null) {
            result = false;
        }
        if (this.serviceKey != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        BindingTemplate theClone = (BindingTemplate)super.clone();
        if (this.descriptionArrayList != null) {
            theClone.descriptionArrayList = (DescriptionArrayList)this.descriptionArrayList.clone();
        }
        if (this.accessPoint != null) {
            theClone.accessPoint = (AccessPoint)this.accessPoint.clone();
        }
        if (this.hostingRedirector != null) {
            theClone.hostingRedirector = (HostingRedirector)this.hostingRedirector.clone();
        }
        if (this.tModelInstanceInfoArrayList != null) {
            theClone.tModelInstanceInfoArrayList = (TModelInstanceInfoArrayList)this.tModelInstanceInfoArrayList.clone();
        }
        if (this.categoryBag != null) {
            theClone.categoryBag = (CategoryBag)this.categoryBag.clone();
        }
        if (this.SignatureArrayList != null) {
            theClone.SignatureArrayList = (ElementArrayList)this.SignatureArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BindingTemplate)) {
            return false;
        }
        BindingTemplate org_systinet_uddi_client_v3_struct_BindingTemplate = (BindingTemplate)o;
        boolean bl = this.descriptionArrayList != null ? !this.descriptionArrayList.equals(org_systinet_uddi_client_v3_struct_BindingTemplate.descriptionArrayList) : org_systinet_uddi_client_v3_struct_BindingTemplate.descriptionArrayList != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.accessPoint != null ? !this.accessPoint.equals(org_systinet_uddi_client_v3_struct_BindingTemplate.accessPoint) : org_systinet_uddi_client_v3_struct_BindingTemplate.accessPoint != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.hostingRedirector != null ? !this.hostingRedirector.equals(org_systinet_uddi_client_v3_struct_BindingTemplate.hostingRedirector) : org_systinet_uddi_client_v3_struct_BindingTemplate.hostingRedirector != null;
        if (bl3) {
            return false;
        }
        boolean bl4 = this.tModelInstanceInfoArrayList != null ? !this.tModelInstanceInfoArrayList.equals(org_systinet_uddi_client_v3_struct_BindingTemplate.tModelInstanceInfoArrayList) : org_systinet_uddi_client_v3_struct_BindingTemplate.tModelInstanceInfoArrayList != null;
        if (bl4) {
            return false;
        }
        boolean bl5 = this.categoryBag != null ? !this.categoryBag.equals(org_systinet_uddi_client_v3_struct_BindingTemplate.categoryBag) : org_systinet_uddi_client_v3_struct_BindingTemplate.categoryBag != null;
        if (bl5) {
            return false;
        }
        boolean bl6 = this.SignatureArrayList != null ? !this.SignatureArrayList.equals(org_systinet_uddi_client_v3_struct_BindingTemplate.SignatureArrayList) : org_systinet_uddi_client_v3_struct_BindingTemplate.SignatureArrayList != null;
        if (bl6) {
            return false;
        }
        boolean bl7 = this.bindingKey != null ? !this.bindingKey.equals(org_systinet_uddi_client_v3_struct_BindingTemplate.bindingKey) : org_systinet_uddi_client_v3_struct_BindingTemplate.bindingKey != null;
        if (bl7) {
            return false;
        }
        return !(this.serviceKey != null ? !this.serviceKey.equals(org_systinet_uddi_client_v3_struct_BindingTemplate.serviceKey) : org_systinet_uddi_client_v3_struct_BindingTemplate.serviceKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.descriptionArrayList != null ? this.descriptionArrayList.hashCode() : 0);
        result = 29 * result + (this.accessPoint != null ? this.accessPoint.hashCode() : 0);
        result = 29 * result + (this.hostingRedirector != null ? this.hostingRedirector.hashCode() : 0);
        result = 29 * result + (this.tModelInstanceInfoArrayList != null ? this.tModelInstanceInfoArrayList.hashCode() : 0);
        result = 29 * result + (this.categoryBag != null ? this.categoryBag.hashCode() : 0);
        result = 29 * result + (this.SignatureArrayList != null ? this.SignatureArrayList.hashCode() : 0);
        result = 29 * result + (this.bindingKey != null ? this.bindingKey.hashCode() : 0);
        result = 29 * result + (this.serviceKey != null ? this.serviceKey.hashCode() : 0);
        return result;
    }
}

