/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.AddressLineDeserializer;
import org.systinet.uddi.client.v3.serialization.AddressLineSerializer;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddressLine
extends UDDIObject
implements Cloneable,
Serializable {
    private String keyName;
    private String keyValue;
    private String value;

    public AddressLine() {
    }

    public AddressLine(String value) throws InvalidParameterException {
        this.setValue(value);
    }

    public AddressLine(String value, String keyName, String keyValue) throws InvalidParameterException {
        this.setValue(value);
        this.setKeyName(keyName);
        this.setKeyValue(keyValue);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws InvalidParameterException {
        if (value != null) {
            if ((value = StringHelper.whitespaceCollapse(value)).length() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
            }
            if (value.length() > 80) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"80"}));
            }
        }
        this.value = value;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) throws InvalidParameterException {
        if (keyName != null && (keyName = StringHelper.whitespaceCollapse(keyName)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.keyName = keyName;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(String keyValue) throws InvalidParameterException {
        if (keyValue != null && (keyValue = StringHelper.whitespaceCollapse(keyValue)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.keyValue = keyValue;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "addressLine", AddressLineSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "addressLine", (Serializer)AddressLineSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "addressLine", (Serializer)AddressLineSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "addressLine", (Serializer)AddressLineSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "addressLine", (Serializer)AddressLineSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "addressLine", AddressLineSerializer.getInstance(), tokenWriter, mapping);
    }

    public static AddressLine fromXML(String string) throws InvalidParameterException, WrappedException {
        return (AddressLine)Helper.deserialize("urn:uddi-org:api_v3", "addressLine", (Deserializer)AddressLineDeserializer.getInstance(), string);
    }

    public static AddressLine fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (AddressLine)Helper.deserialize("urn:uddi-org:api_v3", "addressLine", (Deserializer)AddressLineDeserializer.getInstance(), element);
    }

    public static AddressLine fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (AddressLine)Helper.deserialize("urn:uddi-org:api_v3", "addressLine", (Deserializer)AddressLineDeserializer.getInstance(), reader);
    }

    public static AddressLine fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (AddressLine)Helper.deserialize("urn:uddi-org:api_v3", "addressLine", (Deserializer)AddressLineDeserializer.getInstance(), tokenizer);
    }

    public static AddressLine fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (AddressLine)Helper.deserialize("urn:uddi-org:api_v3", "addressLine", AddressLineDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.value == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "AddressLine.value"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.value != null) {
            result = false;
        }
        if (this.keyName != null) {
            result = false;
        }
        if (this.keyValue != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        AddressLine theClone = (AddressLine)super.clone();
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddressLine)) {
            return false;
        }
        AddressLine org_systinet_uddi_client_v3_struct_AddressLine = (AddressLine)o;
        boolean bl = this.value != null ? !this.value.equals(org_systinet_uddi_client_v3_struct_AddressLine.value) : org_systinet_uddi_client_v3_struct_AddressLine.value != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.keyName != null ? !this.keyName.equals(org_systinet_uddi_client_v3_struct_AddressLine.keyName) : org_systinet_uddi_client_v3_struct_AddressLine.keyName != null;
        if (bl2) {
            return false;
        }
        return !(this.keyValue != null ? !this.keyValue.equals(org_systinet_uddi_client_v3_struct_AddressLine.keyValue) : org_systinet_uddi_client_v3_struct_AddressLine.keyValue != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 29 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
        result = 29 * result + (this.keyValue != null ? this.keyValue.hashCode() : 0);
        return result;
    }
}

