/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.AddressDeserializer;
import org.systinet.uddi.client.v3.serialization.AddressSerializer;
import org.systinet.uddi.client.v3.struct.AddressLine;
import org.systinet.uddi.client.v3.struct.AddressLineArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Address
extends UDDIObject
implements Cloneable,
Serializable {
    protected AddressLineArrayList addressLineArrayList;
    protected String lang;
    protected String useType = "";
    protected String sortCode = "";
    protected String tModelKey;

    public Address() {
    }

    public Address(AddressLineArrayList addressLineArrayList) throws InvalidParameterException {
        this.setAddressLineArrayList(addressLineArrayList);
    }

    public Address(AddressLineArrayList addressLineArrayList, String lang, String useType, String sortCode, String tModelKey) throws InvalidParameterException {
        this.setAddressLineArrayList(addressLineArrayList);
        this.setLang(lang);
        this.setUseType(useType);
        this.setSortCode(sortCode);
        this.setTModelKey(tModelKey);
    }

    public void addAddressLine(AddressLine item) {
        if (this.addressLineArrayList == null) {
            this.addressLineArrayList = new AddressLineArrayList();
        }
        this.addressLineArrayList.add(item);
    }

    public AddressLineArrayList getAddressLineArrayList() {
        return this.addressLineArrayList;
    }

    public void setAddressLineArrayList(AddressLineArrayList addressLineArrayList) throws InvalidParameterException {
        if (addressLineArrayList == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "addressLineArrayList"));
        }
        this.addressLineArrayList = addressLineArrayList;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        if (lang != null) {
            // empty if block
        }
        this.lang = lang;
    }

    public String getUseType() {
        return this.useType;
    }

    public void setUseType(String useType) throws InvalidParameterException {
        if (useType != null && (useType = StringHelper.whitespaceCollapse(useType)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.useType = useType;
    }

    public String getSortCode() {
        return this.sortCode;
    }

    public void setSortCode(String sortCode) throws InvalidParameterException {
        if (sortCode != null && (sortCode = StringHelper.whitespaceCollapse(sortCode)).length() > 10) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"10"}));
        }
        this.sortCode = sortCode;
    }

    public String getTModelKey() {
        return this.tModelKey;
    }

    public void setTModelKey(String tModelKey) throws InvalidParameterException {
        if (tModelKey != null && (tModelKey = StringHelper.whitespaceCollapse(tModelKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.tModelKey = tModelKey;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "address", AddressSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "address", (Serializer)AddressSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "address", (Serializer)AddressSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "address", (Serializer)AddressSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "address", (Serializer)AddressSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "address", AddressSerializer.getInstance(), tokenWriter, mapping);
    }

    public static Address fromXML(String string) throws InvalidParameterException, WrappedException {
        return (Address)Helper.deserialize("urn:uddi-org:api_v3", "address", (Deserializer)AddressDeserializer.getInstance(), string);
    }

    public static Address fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (Address)Helper.deserialize("urn:uddi-org:api_v3", "address", (Deserializer)AddressDeserializer.getInstance(), element);
    }

    public static Address fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (Address)Helper.deserialize("urn:uddi-org:api_v3", "address", (Deserializer)AddressDeserializer.getInstance(), reader);
    }

    public static Address fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (Address)Helper.deserialize("urn:uddi-org:api_v3", "address", (Deserializer)AddressDeserializer.getInstance(), tokenizer);
    }

    public static Address fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (Address)Helper.deserialize("urn:uddi-org:api_v3", "address", AddressDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.addressLineArrayList == null || this.addressLineArrayList.size() < 1) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "Address.addressLineArrayList"));
        }
        this.addressLineArrayList.check();
    }

    public boolean normalize() {
        boolean result = true;
        if (this.addressLineArrayList != null) {
            if (this.addressLineArrayList.normalize()) {
                this.addressLineArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.lang != null) {
            result = false;
        }
        if (this.useType != null) {
            result = false;
        }
        if (this.sortCode != null) {
            result = false;
        }
        if (this.tModelKey != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Address theClone = (Address)super.clone();
        if (this.addressLineArrayList != null) {
            theClone.addressLineArrayList = (AddressLineArrayList)this.addressLineArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address org_systinet_uddi_client_v3_struct_Address = (Address)o;
        boolean bl = this.addressLineArrayList != null ? !this.addressLineArrayList.equals(org_systinet_uddi_client_v3_struct_Address.addressLineArrayList) : org_systinet_uddi_client_v3_struct_Address.addressLineArrayList != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.lang != null ? !this.lang.equals(org_systinet_uddi_client_v3_struct_Address.lang) : org_systinet_uddi_client_v3_struct_Address.lang != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.useType != null ? !this.useType.equals(org_systinet_uddi_client_v3_struct_Address.useType) : org_systinet_uddi_client_v3_struct_Address.useType != null;
        if (bl3) {
            return false;
        }
        boolean bl4 = this.sortCode != null ? !this.sortCode.equals(org_systinet_uddi_client_v3_struct_Address.sortCode) : org_systinet_uddi_client_v3_struct_Address.sortCode != null;
        if (bl4) {
            return false;
        }
        return !(this.tModelKey != null ? !this.tModelKey.equals(org_systinet_uddi_client_v3_struct_Address.tModelKey) : org_systinet_uddi_client_v3_struct_Address.tModelKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.addressLineArrayList != null ? this.addressLineArrayList.hashCode() : 0);
        result = 29 * result + (this.lang != null ? this.lang.hashCode() : 0);
        result = 29 * result + (this.useType != null ? this.useType.hashCode() : 0);
        result = 29 * result + (this.sortCode != null ? this.sortCode.hashCode() : 0);
        result = 29 * result + (this.tModelKey != null ? this.tModelKey.hashCode() : 0);
        return result;
    }
}

