/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.AccessPointDeserializer;
import org.systinet.uddi.client.v3.serialization.AccessPointSerializer;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AccessPoint
extends UDDIObject
implements Cloneable,
Serializable {
    private String useType;
    private String value;

    public AccessPoint() {
    }

    public AccessPoint(String value) throws InvalidParameterException {
        this.setValue(value);
    }

    public AccessPoint(String value, String useType) throws InvalidParameterException {
        this.setValue(value);
        this.setUseType(useType);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws InvalidParameterException {
        if (value != null) {
            if ((value = StringHelper.whitespaceCollapse(value)).length() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
            }
            if (value.length() > 4096) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"4096"}));
            }
        }
        this.value = value;
    }

    public String getUseType() {
        return this.useType;
    }

    public void setUseType(String useType) throws InvalidParameterException {
        if (useType != null && (useType = StringHelper.whitespaceCollapse(useType)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.useType = useType;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "accessPoint", AccessPointSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "accessPoint", (Serializer)AccessPointSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "accessPoint", (Serializer)AccessPointSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "accessPoint", (Serializer)AccessPointSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "accessPoint", (Serializer)AccessPointSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "accessPoint", AccessPointSerializer.getInstance(), tokenWriter, mapping);
    }

    public static AccessPoint fromXML(String string) throws InvalidParameterException, WrappedException {
        return (AccessPoint)Helper.deserialize("urn:uddi-org:api_v3", "accessPoint", (Deserializer)AccessPointDeserializer.getInstance(), string);
    }

    public static AccessPoint fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (AccessPoint)Helper.deserialize("urn:uddi-org:api_v3", "accessPoint", (Deserializer)AccessPointDeserializer.getInstance(), element);
    }

    public static AccessPoint fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (AccessPoint)Helper.deserialize("urn:uddi-org:api_v3", "accessPoint", (Deserializer)AccessPointDeserializer.getInstance(), reader);
    }

    public static AccessPoint fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (AccessPoint)Helper.deserialize("urn:uddi-org:api_v3", "accessPoint", (Deserializer)AccessPointDeserializer.getInstance(), tokenizer);
    }

    public static AccessPoint fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (AccessPoint)Helper.deserialize("urn:uddi-org:api_v3", "accessPoint", AccessPointDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.value == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "AccessPoint.value"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.value != null) {
            result = false;
        }
        if (this.useType != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        AccessPoint theClone = (AccessPoint)super.clone();
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessPoint)) {
            return false;
        }
        AccessPoint org_systinet_uddi_client_v3_struct_AccessPoint = (AccessPoint)o;
        boolean bl = this.value != null ? !this.value.equals(org_systinet_uddi_client_v3_struct_AccessPoint.value) : org_systinet_uddi_client_v3_struct_AccessPoint.value != null;
        if (bl) {
            return false;
        }
        return !(this.useType != null ? !this.useType.equals(org_systinet_uddi_client_v3_struct_AccessPoint.useType) : org_systinet_uddi_client_v3_struct_AccessPoint.useType != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 29 * result + (this.useType != null ? this.useType.hashCode() : 0);
        return result;
    }
}

