/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import org.idoox.wasp.serialization.FaultDeserializer;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xmlrpc.Fault;
import org.systinet.uddi.client.v3.UDDIException;
import org.systinet.uddi.client.v3.struct.DispositionReport;

public class UDDIFaultDeserializer
implements FaultDeserializer {
    public static final String SERIOUS_ERROR = "Serious technical problem.";

    public Exception deserializeFault(Fault fault) {
        String faultCode = fault.getFaultCode().getLocalPart();
        String faultString = fault.getFaultString();
        Tokenizer tokenizer = null;
        try {
            Token t = new Token();
            tokenizer = fault.getDetailTokenizer();
            while (tokenizer.currentState() == 4) {
                tokenizer.next();
            }
            byte tokenType = tokenizer.currentState();
            if (tokenType != 2) {
                return new UDDIException(faultCode, faultString, SERIOUS_ERROR);
            }
            DispositionReport dispositionReport = DispositionReport.fromXML(tokenizer);
            return new UDDIException(dispositionReport, faultCode, faultString);
        }
        catch (Exception e) {
            new RuntimeException("Error while deserializing fault: " + e.getMessage());
            return new UDDIException(SERIOUS_ERROR);
        }
    }
}

