/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.ElementArrayListIterator;
import org.systinet.uddi.client.serialization.BooleanSerializer;
import org.systinet.uddi.client.serialization.ElementSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.CategoryBagSerializer;
import org.systinet.uddi.client.v3.serialization.DescriptionSerializer;
import org.systinet.uddi.client.v3.serialization.IdentifierBagSerializer;
import org.systinet.uddi.client.v3.serialization.NameSerializer;
import org.systinet.uddi.client.v3.serialization.OverviewDocSerializer;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DescriptionArrayListIterator;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.IdentifierBag;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.OverviewDoc;
import org.systinet.uddi.client.v3.struct.OverviewDocArrayList;
import org.systinet.uddi.client.v3.struct.OverviewDocArrayListIterator;
import org.systinet.uddi.client.v3.struct.TModel;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.w3c.dom.Element;

public class TModelSerializer
implements XMLSerializer,
Serializer {
    public static final TModelSerializer serializer = new TModelSerializer();

    public static TModelSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "tModel")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "tModel", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        TModel uddiObject = (TModel)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, TModel uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        Boolean deleted;
        String tModelKey = uddiObject.getTModelKey();
        if (!Helper.isNull(tModelKey)) {
            StringSerializer.serializeAttribute(dataWriter, tModelKey, "", "tModelKey");
        }
        if (!Helper.isNull(deleted = uddiObject.getDeleted())) {
            BooleanSerializer.serializeAttribute(dataWriter, deleted, "", "deleted");
        }
    }

    public void serializeBody(TokenWriter dataWriter, TModel uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        ElementArrayList SignatureArrayList;
        CategoryBag categoryBagField;
        IdentifierBag identifierBagField;
        OverviewDocArrayList overviewDocArrayList;
        SerializationMappingValue serializationMappingValue;
        DescriptionArrayList descriptionArrayList;
        Name nameField = uddiObject.getName();
        if (!Helper.isNull(nameField)) {
            if (mapping.containsKey(new SerializationMappingKey(nameField.getClass().getName(), new QName("urn:uddi-org:api_v3", "name")))) {
                SerializationMappingValue serializationMappingValue2 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(nameField.getClass().getName(), new QName("urn:uddi-org:api_v3", "name")));
                serializationMappingValue2.getSerializer().serialize(dataWriter, nameField, serializationMappingValue2.getElement().getNamespaceURI(), serializationMappingValue2.getElement().getLocalPart(), mapping);
            } else {
                NameSerializer.getInstance().serialize(dataWriter, nameField, "urn:uddi-org:api_v3", "name", mapping);
            }
        }
        if (!Helper.isNull(descriptionArrayList = uddiObject.getDescriptionArrayList()) && descriptionArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            serializationMappingValue = null;
            DescriptionArrayListIterator iterator = descriptionArrayList.descriptionArrayListIterator();
            while (iterator.hasNext()) {
                Description item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "description")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                DescriptionSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "description", mapping);
            }
        }
        if (!Helper.isNull(overviewDocArrayList = uddiObject.getOverviewDocArrayList()) && overviewDocArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue3 = null;
            OverviewDocArrayListIterator iterator = overviewDocArrayList.overviewDocArrayListIterator();
            while (iterator.hasNext()) {
                OverviewDoc item = iterator.next();
                serializationMappingValue3 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "overviewDoc")));
                if (serializationMappingValue3 != null) {
                    serializer = serializationMappingValue3.getSerializer();
                    namespaceURI = serializationMappingValue3.getElement().getNamespaceURI();
                    localPart = serializationMappingValue3.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                OverviewDocSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "overviewDoc", mapping);
            }
        }
        if (!Helper.isNull(identifierBagField = uddiObject.getIdentifierBag())) {
            if (mapping.containsKey(new SerializationMappingKey(identifierBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "identifierBag")))) {
                SerializationMappingValue serializationMappingValue4 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(identifierBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "identifierBag")));
                serializationMappingValue4.getSerializer().serialize(dataWriter, identifierBagField, serializationMappingValue4.getElement().getNamespaceURI(), serializationMappingValue4.getElement().getLocalPart(), mapping);
            } else {
                IdentifierBagSerializer.getInstance().serialize(dataWriter, identifierBagField, "urn:uddi-org:api_v3", "identifierBag", mapping);
            }
        }
        if (!Helper.isNull(categoryBagField = uddiObject.getCategoryBag())) {
            if (mapping.containsKey(new SerializationMappingKey(categoryBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "categoryBag")))) {
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(categoryBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "categoryBag")));
                serializationMappingValue.getSerializer().serialize(dataWriter, categoryBagField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                CategoryBagSerializer.getInstance().serialize(dataWriter, categoryBagField, "urn:uddi-org:api_v3", "categoryBag", mapping);
            }
        }
        if (!Helper.isNull(SignatureArrayList = uddiObject.getSignatureArrayList()) && SignatureArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue5 = null;
            ElementArrayListIterator iterator = SignatureArrayList.elementArrayListIterator();
            while (iterator.hasNext()) {
                Element item = iterator.next();
                serializationMappingValue5 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("http://www.w3.org/2000/09/xmldsig#", "Signature")));
                if (serializationMappingValue5 != null) {
                    serializer = serializationMappingValue5.getSerializer();
                    namespaceURI = serializationMappingValue5.getElement().getNamespaceURI();
                    localPart = serializationMappingValue5.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                ElementSerializer.serialize(dataWriter, item, "http://www.w3.org/2000/09/xmldsig#", "Signature");
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

