/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.serialization.TModelInfoSerializer;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.TModelInfo;
import org.systinet.uddi.client.v3.struct.TModelInfoArrayList;
import org.systinet.uddi.client.v3.struct.TModelInfoArrayListIterator;
import org.systinet.uddi.client.v3.struct.TModelInfos;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class TModelInfosSerializer
implements XMLSerializer,
Serializer {
    public static final TModelInfosSerializer serializer = new TModelInfosSerializer();

    public static TModelInfosSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "tModelInfos")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "tModelInfos", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        TModelInfos uddiObject = (TModelInfos)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, TModelInfos uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
    }

    public void serializeBody(TokenWriter dataWriter, TModelInfos uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        TModelInfoArrayList tModelInfoArrayList = uddiObject.getTModelInfoArrayList();
        if (!Helper.isNull(tModelInfoArrayList) && tModelInfoArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            TModelInfoArrayListIterator iterator = tModelInfoArrayList.tModelInfoArrayListIterator();
            while (iterator.hasNext()) {
                TModelInfo item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "tModelInfo")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                TModelInfoSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "tModelInfo", mapping);
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

