/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.DescriptionSerializer;
import org.systinet.uddi.client.v3.serialization.NameSerializer;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DescriptionArrayListIterator;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.TModelInfo;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class TModelInfoSerializer
implements XMLSerializer,
Serializer {
    public static final TModelInfoSerializer serializer = new TModelInfoSerializer();

    public static TModelInfoSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "tModelInfo")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "tModelInfo", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        TModelInfo uddiObject = (TModelInfo)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, TModelInfo uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        String tModelKey = uddiObject.getTModelKey();
        if (!Helper.isNull(tModelKey)) {
            StringSerializer.serializeAttribute(dataWriter, tModelKey, "", "tModelKey");
        }
    }

    public void serializeBody(TokenWriter dataWriter, TModelInfo uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        DescriptionArrayList descriptionArrayList;
        Name nameField = uddiObject.getName();
        if (!Helper.isNull(nameField)) {
            if (mapping.containsKey(new SerializationMappingKey(nameField.getClass().getName(), new QName("urn:uddi-org:api_v3", "name")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(nameField.getClass().getName(), new QName("urn:uddi-org:api_v3", "name")));
                serializationMappingValue.getSerializer().serialize(dataWriter, nameField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                NameSerializer.getInstance().serialize(dataWriter, nameField, "urn:uddi-org:api_v3", "name", mapping);
            }
        }
        if (!Helper.isNull(descriptionArrayList = uddiObject.getDescriptionArrayList()) && descriptionArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            DescriptionArrayListIterator iterator = descriptionArrayList.descriptionArrayListIterator();
            while (iterator.hasNext()) {
                Description item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "description")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                DescriptionSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "description", mapping);
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

