/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.serialization.DeserializationMappingKey;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.ElementDeserializer;
import org.systinet.uddi.client.serialization.StringDeserializer;
import org.systinet.uddi.client.v3.serialization.CategoryBagDeserializer;
import org.systinet.uddi.client.v3.serialization.DescriptionDeserializer;
import org.systinet.uddi.client.v3.serialization.IdentifierBagDeserializer;
import org.systinet.uddi.client.v3.serialization.NameDeserializer;
import org.systinet.uddi.client.v3.serialization.OverviewDocDeserializer;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.IdentifierBag;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.OverviewDoc;
import org.systinet.uddi.client.v3.struct.OverviewDocArrayList;
import org.systinet.uddi.client.v3.struct.TModel;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.w3c.dom.Element;

public class TModelDeserializer
implements XMLDeserializer,
Deserializer {
    public static final TModelDeserializer deserializer = new TModelDeserializer();

    public static TModelDeserializer getInstance() {
        return deserializer;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Map mapping) throws MessageProcessingException {
        TModel tModel = new TModel();
        Vector<Attribute> usedAttribute = new Vector<Attribute>();
        int i = 0;
        while (i < token.getAttributeCount()) {
            Attribute attribute = token.getAttribute(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                Attribute a = new Attribute();
                attribute.writeTo(a);
                usedAttribute.add(a);
            }
            ++i;
        }
        try {
            int tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            tok = this.deserialize(dataTokenizer, token, mapping, tModel, usedAttribute, true, tok);
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return tModel;
    }

    private int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, TModel tModel, Vector usedAttribute, boolean checkAttribute, int tok) throws MessageProcessingException {
        try {
            Deserializer deserializer = null;
            Name name = null;
            DescriptionArrayList descriptionArrayList = null;
            OverviewDocArrayList overviewDocArrayList = null;
            IdentifierBag identifierBag = null;
            CategoryBag categoryBag = null;
            ElementArrayList SignatureArrayList = null;
            String tModelKey = null;
            Boolean deleted = null;
            Iterator iterator = ((AbstractList)usedAttribute).iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (attribute.value == null || !"tModelKey".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                tModelKey = new String(StringDeserializer.deserialize(attribute.value));
                tModel.setTModelKey(tModelKey);
                iterator.remove();
                break;
            }
            Iterator iterator2 = ((AbstractList)usedAttribute).iterator();
            while (iterator2.hasNext()) {
                Attribute attribute = (Attribute)iterator2.next();
                if (attribute.value == null || !"deleted".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                deleted = new Boolean(StringDeserializer.deserialize(attribute.value));
                tModel.setDeleted(deleted);
                iterator2.remove();
                break;
            }
            if (checkAttribute && usedAttribute.size() != 0) {
                String attributes = "";
                Iterator iterator3 = ((AbstractList)usedAttribute).iterator();
                while (iterator3.hasNext()) {
                    Attribute attribute = (Attribute)iterator3.next();
                    attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                }
                throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
            }
            boolean isNotExtension = false;
            dataTokenizer.readToken(token);
            if (tok != 3 && ((isNotExtension = "name".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "name"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    name = (Name)NameDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    tModel.setName(name);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    name = (Name)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "name"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    tModel.setName(name);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && (isNotExtension = "description".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "description"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "description".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "description"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (descriptionArrayList == null) {
                        descriptionArrayList = new DescriptionArrayList();
                    }
                    if (isNotExtension) {
                        descriptionArrayList.add((Description)DescriptionDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        descriptionArrayList.add((Description)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                tModel.setDescriptionArrayList(descriptionArrayList);
            }
            if (tok != 3 && (isNotExtension = "overviewDoc".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "overviewDoc"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "overviewDoc".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "overviewDoc"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (overviewDocArrayList == null) {
                        overviewDocArrayList = new OverviewDocArrayList();
                    }
                    if (isNotExtension) {
                        overviewDocArrayList.add((OverviewDoc)OverviewDocDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        overviewDocArrayList.add((OverviewDoc)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                tModel.setOverviewDocArrayList(overviewDocArrayList);
            }
            if (tok != 3 && ((isNotExtension = "identifierBag".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "identifierBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    identifierBag = (IdentifierBag)IdentifierBagDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    tModel.setIdentifierBag(identifierBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    identifierBag = (IdentifierBag)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "identifierBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    tModel.setIdentifierBag(identifierBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && ((isNotExtension = "categoryBag".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "categoryBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    categoryBag = (CategoryBag)CategoryBagDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    tModel.setCategoryBag(categoryBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    categoryBag = (CategoryBag)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "categoryBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    tModel.setCategoryBag(categoryBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && (isNotExtension = "Signature".equals(dataTokenizer.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "Signature".equals(dataTokenizer.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (SignatureArrayList == null) {
                        SignatureArrayList = new ElementArrayList();
                    }
                    if (isNotExtension) {
                        SignatureArrayList.add(ElementDeserializer.deserialize(dataTokenizer, token));
                    } else {
                        SignatureArrayList.add((Element)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                tModel.setSignatureArrayList(SignatureArrayList);
            }
            if (name == null) {
                throw new MessageProcessingException("Missing required input element ({urn:uddi-org:api_v3}name).");
            }
            return tok;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, TModel tModel, Vector usedAttribute, int tok) throws MessageProcessingException {
        return this.deserialize(dataTokenizer, token, mapping, tModel, usedAttribute, false, tok);
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("deserializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("deserializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.deserializationMapping;
        }
        try {
            if (mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "tModel"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                return ((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "tModel"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
            }
            return this.deserialize(dataTokenizer, token, mapping);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

