/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.uddi.client.serialization.DeserializationMappingKey;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.StringDeserializer;
import org.systinet.uddi.client.v3.serialization.ListDescriptionDeserializer;
import org.systinet.uddi.client.v3.serialization.ServiceInfoDeserializer;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.ListDescription;
import org.systinet.uddi.client.v3.struct.ServiceInfo;
import org.systinet.uddi.client.v3.struct.ServiceInfoArrayList;
import org.systinet.uddi.client.v3.struct.ServiceList;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ServiceListDeserializer
implements XMLDeserializer,
Deserializer {
    public static final ServiceListDeserializer deserializer = new ServiceListDeserializer();

    public static ServiceListDeserializer getInstance() {
        return deserializer;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Map mapping) throws MessageProcessingException {
        ServiceList serviceList = new ServiceList();
        Vector<Attribute> usedAttribute = new Vector<Attribute>();
        int i = 0;
        while (i < token.getAttributeCount()) {
            Attribute attribute = token.getAttribute(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                Attribute a = new Attribute();
                attribute.writeTo(a);
                usedAttribute.add(a);
            }
            ++i;
        }
        try {
            int tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            tok = this.deserialize(dataTokenizer, token, mapping, serviceList, usedAttribute, true, tok);
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return serviceList;
    }

    private int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, ServiceList serviceList, Vector usedAttribute, boolean checkAttribute, int tok) throws MessageProcessingException {
        try {
            Deserializer deserializer = null;
            ListDescription listDescription = null;
            ServiceInfoArrayList serviceInfoArrayList = null;
            Boolean truncated = null;
            Iterator iterator = ((AbstractList)usedAttribute).iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (attribute.value == null || !"truncated".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                truncated = new Boolean(StringDeserializer.deserialize(attribute.value));
                serviceList.setTruncated(truncated);
                iterator.remove();
                break;
            }
            if (checkAttribute && usedAttribute.size() != 0) {
                String attributes = "";
                Iterator iterator2 = ((AbstractList)usedAttribute).iterator();
                while (iterator2.hasNext()) {
                    Attribute attribute = (Attribute)iterator2.next();
                    attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                }
                throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
            }
            boolean isNotExtension = false;
            dataTokenizer.readToken(token);
            if (tok != 3 && ((isNotExtension = "listDescription".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "listDescription"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    listDescription = (ListDescription)ListDescriptionDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    serviceList.setListDescription(listDescription);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    listDescription = (ListDescription)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "listDescription"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    serviceList.setListDescription(listDescription);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && "serviceInfos".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) {
                dataTokenizer.readToken(token);
                if (token.getAttributeCount() != 0) {
                    throw new MessageProcessingException("Unexpected input attribute {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
                if (tok != 3 && (isNotExtension = "serviceInfo".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "serviceInfo"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                    while (tok != 3 && (isNotExtension = "serviceInfo".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "serviceInfo"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                        if (serviceInfoArrayList == null) {
                            serviceInfoArrayList = new ServiceInfoArrayList();
                        }
                        if (isNotExtension) {
                            serviceInfoArrayList.add((ServiceInfo)ServiceInfoDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                        } else {
                            serviceInfoArrayList.add((ServiceInfo)deserializer.deserialize(dataTokenizer, token, mapping));
                        }
                        tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                        dataTokenizer.readToken(token);
                    }
                    serviceList.setServiceInfoArrayList(serviceInfoArrayList);
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
            }
            return tok;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, ServiceList serviceList, Vector usedAttribute, int tok) throws MessageProcessingException {
        return this.deserialize(dataTokenizer, token, mapping, serviceList, usedAttribute, false, tok);
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("deserializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("deserializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.deserializationMapping;
        }
        try {
            if (mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "serviceList"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                return ((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "serviceList"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
            }
            return this.deserialize(dataTokenizer, token, mapping);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

