/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.EnumHelper;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.IntegerSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.ErrInfoSerializer;
import org.systinet.uddi.client.v3.struct.ErrInfo;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.KeyType;
import org.systinet.uddi.client.v3.struct.Result;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ResultSerializer
implements XMLSerializer,
Serializer {
    public static final ResultSerializer serializer = new ResultSerializer();

    public static ResultSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "result")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "result", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        Result uddiObject = (Result)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, Result uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        KeyType keyType = uddiObject.getKeyType();
        if (!Helper.isNull(keyType)) {
            try {
                StringSerializer.serializeAttribute(dataWriter, EnumHelper.getEnumValue((Object)keyType), "", "keyType");
            }
            catch (Exception e) {
                throw new MessageCreatingException((Throwable)e);
            }
        }
        int errno = uddiObject.getErrno();
        IntegerSerializer.serializeAttribute(dataWriter, errno, "", "errno");
    }

    public void serializeBody(TokenWriter dataWriter, Result uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        ErrInfo errInfoField = uddiObject.getErrInfo();
        if (!Helper.isNull(errInfoField)) {
            if (mapping.containsKey(new SerializationMappingKey(errInfoField.getClass().getName(), new QName("urn:uddi-org:api_v3", "errInfo")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(errInfoField.getClass().getName(), new QName("urn:uddi-org:api_v3", "errInfo")));
                serializationMappingValue.getSerializer().serialize(dataWriter, errInfoField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                ErrInfoSerializer.getInstance().serialize(dataWriter, errInfoField, "urn:uddi-org:api_v3", "errInfo", mapping);
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

