/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.BooleanSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.ListDescriptionSerializer;
import org.systinet.uddi.client.v3.serialization.RelatedBusinessInfoSerializer;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.ListDescription;
import org.systinet.uddi.client.v3.struct.RelatedBusinessInfo;
import org.systinet.uddi.client.v3.struct.RelatedBusinessInfoArrayList;
import org.systinet.uddi.client.v3.struct.RelatedBusinessInfoArrayListIterator;
import org.systinet.uddi.client.v3.struct.RelatedBusinessesList;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class RelatedBusinessesListSerializer
implements XMLSerializer,
Serializer {
    public static final RelatedBusinessesListSerializer serializer = new RelatedBusinessesListSerializer();

    public static RelatedBusinessesListSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "relatedBusinessesList")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "relatedBusinessesList", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        RelatedBusinessesList uddiObject = (RelatedBusinessesList)data;
        try {
            dataWriter.enter(namespace, localName);
            dataWriter.setPrefixForNamespace("", namespace);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, RelatedBusinessesList uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        Boolean truncated = uddiObject.getTruncated();
        if (!Helper.isNull(truncated)) {
            BooleanSerializer.serializeAttribute(dataWriter, truncated, "", "truncated");
        }
    }

    public void serializeBody(TokenWriter dataWriter, RelatedBusinessesList uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        RelatedBusinessInfoArrayList relatedBusinessInfoArrayList;
        String businessKeyField;
        ListDescription listDescriptionField = uddiObject.getListDescription();
        if (!Helper.isNull(listDescriptionField)) {
            if (mapping.containsKey(new SerializationMappingKey(listDescriptionField.getClass().getName(), new QName("urn:uddi-org:api_v3", "listDescription")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(listDescriptionField.getClass().getName(), new QName("urn:uddi-org:api_v3", "listDescription")));
                serializationMappingValue.getSerializer().serialize(dataWriter, listDescriptionField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                ListDescriptionSerializer.getInstance().serialize(dataWriter, listDescriptionField, "urn:uddi-org:api_v3", "listDescription", mapping);
            }
        }
        if (!Helper.isNull(businessKeyField = uddiObject.getBusinessKey())) {
            if (mapping.containsKey(new SerializationMappingKey(businessKeyField.getClass().getName(), new QName("urn:uddi-org:api_v3", "businessKey")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(businessKeyField.getClass().getName(), new QName("urn:uddi-org:api_v3", "businessKey")));
                StringSerializer.serialize(dataWriter, businessKeyField, "urn:uddi-org:api_v3", "businessKey");
            } else {
                StringSerializer.serialize(dataWriter, businessKeyField, "urn:uddi-org:api_v3", "businessKey");
            }
        }
        if (!Helper.isNull(relatedBusinessInfoArrayList = uddiObject.getRelatedBusinessInfoArrayList()) && relatedBusinessInfoArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "relatedBusinessInfos");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            RelatedBusinessInfoArrayListIterator iterator = relatedBusinessInfoArrayList.relatedBusinessInfoArrayListIterator();
            while (iterator.hasNext()) {
                RelatedBusinessInfo item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "relatedBusinessInfo")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                RelatedBusinessInfoSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "relatedBusinessInfo", mapping);
            }
            dataWriter.leave();
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

