/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.uddi.client.serialization.DeserializationMappingKey;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.StringDeserializer;
import org.systinet.uddi.client.v3.serialization.DescriptionDeserializer;
import org.systinet.uddi.client.v3.serialization.NameDeserializer;
import org.systinet.uddi.client.v3.serialization.SharedRelationshipsDeserializer;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.uddi.client.v3.struct.RelatedBusinessInfo;
import org.systinet.uddi.client.v3.struct.SharedRelationships;
import org.systinet.uddi.client.v3.struct.SharedRelationshipsArrayList;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class RelatedBusinessInfoDeserializer
implements XMLDeserializer,
Deserializer {
    public static final RelatedBusinessInfoDeserializer deserializer = new RelatedBusinessInfoDeserializer();

    public static RelatedBusinessInfoDeserializer getInstance() {
        return deserializer;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Map mapping) throws MessageProcessingException {
        RelatedBusinessInfo relatedBusinessInfo = new RelatedBusinessInfo();
        Vector<Attribute> usedAttribute = new Vector<Attribute>();
        int i = 0;
        while (i < token.getAttributeCount()) {
            Attribute attribute = token.getAttribute(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                Attribute a = new Attribute();
                attribute.writeTo(a);
                usedAttribute.add(a);
            }
            ++i;
        }
        try {
            int tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            tok = this.deserialize(dataTokenizer, token, mapping, relatedBusinessInfo, usedAttribute, true, tok);
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return relatedBusinessInfo;
    }

    private int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, RelatedBusinessInfo relatedBusinessInfo, Vector usedAttribute, boolean checkAttribute, int tok) throws MessageProcessingException {
        try {
            Deserializer deserializer = null;
            String businessKey = null;
            NameArrayList nameArrayList = null;
            DescriptionArrayList descriptionArrayList = null;
            SharedRelationshipsArrayList sharedRelationshipsArrayList = null;
            if (checkAttribute && usedAttribute.size() != 0) {
                String attributes = "";
                Iterator iterator = ((AbstractList)usedAttribute).iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                }
                throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
            }
            boolean isNotExtension = false;
            dataTokenizer.readToken(token);
            if (tok != 3 && ((isNotExtension = "businessKey".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "businessKey"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    businessKey = StringDeserializer.deserialize(dataTokenizer, token);
                    relatedBusinessInfo.setBusinessKey(businessKey);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    businessKey = StringDeserializer.deserialize(dataTokenizer, token);
                    relatedBusinessInfo.setBusinessKey(businessKey);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && (isNotExtension = "name".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "name"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "name".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "name"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (nameArrayList == null) {
                        nameArrayList = new NameArrayList();
                    }
                    if (isNotExtension) {
                        nameArrayList.add((Name)NameDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        nameArrayList.add((Name)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                relatedBusinessInfo.setNameArrayList(nameArrayList);
            }
            if (tok != 3 && (isNotExtension = "description".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "description"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "description".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "description"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (descriptionArrayList == null) {
                        descriptionArrayList = new DescriptionArrayList();
                    }
                    if (isNotExtension) {
                        descriptionArrayList.add((Description)DescriptionDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        descriptionArrayList.add((Description)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                relatedBusinessInfo.setDescriptionArrayList(descriptionArrayList);
            }
            if (tok != 3 && (isNotExtension = "sharedRelationships".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "sharedRelationships"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "sharedRelationships".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "sharedRelationships"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (sharedRelationshipsArrayList == null) {
                        sharedRelationshipsArrayList = new SharedRelationshipsArrayList();
                    }
                    if (isNotExtension) {
                        sharedRelationshipsArrayList.add((SharedRelationships)SharedRelationshipsDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        sharedRelationshipsArrayList.add((SharedRelationships)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                relatedBusinessInfo.setSharedRelationshipsArrayList(sharedRelationshipsArrayList);
            }
            if (businessKey == null) {
                throw new MessageProcessingException("Missing required input element ({urn:uddi-org:api_v3}businessKey).");
            }
            if (nameArrayList == null) {
                throw new MessageProcessingException("Missing required input element ({urn:uddi-org:api_v3}nameArrayList).");
            }
            if (sharedRelationshipsArrayList == null) {
                throw new MessageProcessingException("Missing required input element ({urn:uddi-org:api_v3}sharedRelationshipsArrayList).");
            }
            return tok;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, RelatedBusinessInfo relatedBusinessInfo, Vector usedAttribute, int tok) throws MessageProcessingException {
        return this.deserialize(dataTokenizer, token, mapping, relatedBusinessInfo, usedAttribute, false, tok);
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("deserializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("deserializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.deserializationMapping;
        }
        try {
            if (mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "relatedBusinessInfo"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                return ((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "relatedBusinessInfo"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
            }
            return this.deserialize(dataTokenizer, token, mapping);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

