/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.BooleanSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.serialization.BusinessInfoSerializer;
import org.systinet.uddi.client.v3.serialization.TModelInfoSerializer;
import org.systinet.uddi.client.v3.struct.BusinessInfo;
import org.systinet.uddi.client.v3.struct.BusinessInfoArrayList;
import org.systinet.uddi.client.v3.struct.BusinessInfoArrayListIterator;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.RegisteredInfo;
import org.systinet.uddi.client.v3.struct.TModelInfo;
import org.systinet.uddi.client.v3.struct.TModelInfoArrayList;
import org.systinet.uddi.client.v3.struct.TModelInfoArrayListIterator;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class RegisteredInfoSerializer
implements XMLSerializer,
Serializer {
    public static final RegisteredInfoSerializer serializer = new RegisteredInfoSerializer();

    public static RegisteredInfoSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "registeredInfo")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "registeredInfo", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        RegisteredInfo uddiObject = (RegisteredInfo)data;
        try {
            dataWriter.enter(namespace, localName);
            dataWriter.setPrefixForNamespace("", namespace);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, RegisteredInfo uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        Boolean truncated = uddiObject.getTruncated();
        if (!Helper.isNull(truncated)) {
            BooleanSerializer.serializeAttribute(dataWriter, truncated, "", "truncated");
        }
    }

    public void serializeBody(TokenWriter dataWriter, RegisteredInfo uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        TModelInfoArrayList tModelInfoArrayList;
        BusinessInfoArrayList businessInfoArrayList = uddiObject.getBusinessInfoArrayList();
        if (!Helper.isNull(businessInfoArrayList) && businessInfoArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "businessInfos");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            BusinessInfoArrayListIterator iterator = businessInfoArrayList.businessInfoArrayListIterator();
            while (iterator.hasNext()) {
                BusinessInfo item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "businessInfo")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                BusinessInfoSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "businessInfo", mapping);
            }
            dataWriter.leave();
        }
        if (!Helper.isNull(tModelInfoArrayList = uddiObject.getTModelInfoArrayList()) && tModelInfoArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "tModelInfos");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            TModelInfoArrayListIterator iterator = tModelInfoArrayList.tModelInfoArrayListIterator();
            while (iterator.hasNext()) {
                TModelInfo item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "tModelInfo")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                TModelInfoSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "tModelInfo", mapping);
            }
            dataWriter.leave();
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

