/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.ElementArrayListIterator;
import org.systinet.uddi.client.serialization.ElementSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.KeyedReferenceSerializer;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.KeyedReference;
import org.systinet.uddi.client.v3.struct.PublisherAssertion;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.w3c.dom.Element;

public class PublisherAssertionSerializer
implements XMLSerializer,
Serializer {
    public static final PublisherAssertionSerializer serializer = new PublisherAssertionSerializer();

    public static PublisherAssertionSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "publisherAssertion")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "publisherAssertion", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        PublisherAssertion uddiObject = (PublisherAssertion)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, PublisherAssertion uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
    }

    public void serializeBody(TokenWriter dataWriter, PublisherAssertion uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        ElementArrayList SignatureArrayList;
        KeyedReference keyedReferenceField;
        String toKeyField;
        String fromKeyField = uddiObject.getFromKey();
        if (!Helper.isNull(fromKeyField)) {
            if (mapping.containsKey(new SerializationMappingKey(fromKeyField.getClass().getName(), new QName("urn:uddi-org:api_v3", "fromKey")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(fromKeyField.getClass().getName(), new QName("urn:uddi-org:api_v3", "fromKey")));
                StringSerializer.serialize(dataWriter, fromKeyField, "urn:uddi-org:api_v3", "fromKey");
            } else {
                StringSerializer.serialize(dataWriter, fromKeyField, "urn:uddi-org:api_v3", "fromKey");
            }
        }
        if (!Helper.isNull(toKeyField = uddiObject.getToKey())) {
            if (mapping.containsKey(new SerializationMappingKey(toKeyField.getClass().getName(), new QName("urn:uddi-org:api_v3", "toKey")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(toKeyField.getClass().getName(), new QName("urn:uddi-org:api_v3", "toKey")));
                StringSerializer.serialize(dataWriter, toKeyField, "urn:uddi-org:api_v3", "toKey");
            } else {
                StringSerializer.serialize(dataWriter, toKeyField, "urn:uddi-org:api_v3", "toKey");
            }
        }
        if (!Helper.isNull(keyedReferenceField = uddiObject.getKeyedReference())) {
            if (mapping.containsKey(new SerializationMappingKey(keyedReferenceField.getClass().getName(), new QName("urn:uddi-org:api_v3", "keyedReference")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(keyedReferenceField.getClass().getName(), new QName("urn:uddi-org:api_v3", "keyedReference")));
                serializationMappingValue.getSerializer().serialize(dataWriter, keyedReferenceField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                KeyedReferenceSerializer.getInstance().serialize(dataWriter, keyedReferenceField, "urn:uddi-org:api_v3", "keyedReference", mapping);
            }
        }
        if (!Helper.isNull(SignatureArrayList = uddiObject.getSignatureArrayList()) && SignatureArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            ElementArrayListIterator iterator = SignatureArrayList.elementArrayListIterator();
            while (iterator.hasNext()) {
                Element item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("http://www.w3.org/2000/09/xmldsig#", "Signature")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                ElementSerializer.serialize(dataWriter, item, "http://www.w3.org/2000/09/xmldsig#", "Signature");
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

