/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.DateSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.OperationalInfo;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class OperationalInfoSerializer
implements XMLSerializer,
Serializer {
    public static final OperationalInfoSerializer serializer = new OperationalInfoSerializer();

    public static OperationalInfoSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "operationalInfo")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "operationalInfo", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        OperationalInfo uddiObject = (OperationalInfo)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, OperationalInfo uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        String entityKey = uddiObject.getEntityKey();
        if (!Helper.isNull(entityKey)) {
            StringSerializer.serializeAttribute(dataWriter, entityKey, "", "entityKey");
        }
    }

    public void serializeBody(TokenWriter dataWriter, OperationalInfo uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        String authorizedNameField;
        String nodeIDField;
        Date modifiedIncludingChildrenField;
        Date modifiedField;
        Date createdField = uddiObject.getCreated();
        if (!Helper.isNull(createdField)) {
            if (mapping.containsKey(new SerializationMappingKey(createdField.getClass().getName(), new QName("urn:uddi-org:api_v3", "created")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(createdField.getClass().getName(), new QName("urn:uddi-org:api_v3", "created")));
                DateSerializer.serialize(dataWriter, createdField, "urn:uddi-org:api_v3", "created");
            } else {
                DateSerializer.serialize(dataWriter, createdField, "urn:uddi-org:api_v3", "created");
            }
        }
        if (!Helper.isNull(modifiedField = uddiObject.getModified())) {
            if (mapping.containsKey(new SerializationMappingKey(modifiedField.getClass().getName(), new QName("urn:uddi-org:api_v3", "modified")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(modifiedField.getClass().getName(), new QName("urn:uddi-org:api_v3", "modified")));
                DateSerializer.serialize(dataWriter, modifiedField, "urn:uddi-org:api_v3", "modified");
            } else {
                DateSerializer.serialize(dataWriter, modifiedField, "urn:uddi-org:api_v3", "modified");
            }
        }
        if (!Helper.isNull(modifiedIncludingChildrenField = uddiObject.getModifiedIncludingChildren())) {
            if (mapping.containsKey(new SerializationMappingKey(modifiedIncludingChildrenField.getClass().getName(), new QName("urn:uddi-org:api_v3", "modifiedIncludingChildren")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(modifiedIncludingChildrenField.getClass().getName(), new QName("urn:uddi-org:api_v3", "modifiedIncludingChildren")));
                DateSerializer.serialize(dataWriter, modifiedIncludingChildrenField, "urn:uddi-org:api_v3", "modifiedIncludingChildren");
            } else {
                DateSerializer.serialize(dataWriter, modifiedIncludingChildrenField, "urn:uddi-org:api_v3", "modifiedIncludingChildren");
            }
        }
        if (!Helper.isNull(nodeIDField = uddiObject.getNodeID())) {
            if (mapping.containsKey(new SerializationMappingKey(nodeIDField.getClass().getName(), new QName("urn:uddi-org:api_v3", "nodeID")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(nodeIDField.getClass().getName(), new QName("urn:uddi-org:api_v3", "nodeID")));
                StringSerializer.serialize(dataWriter, nodeIDField, "urn:uddi-org:api_v3", "nodeID");
            } else {
                StringSerializer.serialize(dataWriter, nodeIDField, "urn:uddi-org:api_v3", "nodeID");
            }
        }
        if (!Helper.isNull(authorizedNameField = uddiObject.getAuthorizedName())) {
            if (mapping.containsKey(new SerializationMappingKey(authorizedNameField.getClass().getName(), new QName("urn:uddi-org:api_v3", "authorizedName")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(authorizedNameField.getClass().getName(), new QName("urn:uddi-org:api_v3", "authorizedName")));
                StringSerializer.serialize(dataWriter, authorizedNameField, "urn:uddi-org:api_v3", "authorizedName");
            } else {
                StringSerializer.serialize(dataWriter, authorizedNameField, "urn:uddi-org:api_v3", "authorizedName");
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

