/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.uddi.client.serialization.DateDeserializer;
import org.systinet.uddi.client.serialization.DeserializationMappingKey;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.StringDeserializer;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.OperationalInfo;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class OperationalInfoDeserializer
implements XMLDeserializer,
Deserializer {
    public static final OperationalInfoDeserializer deserializer = new OperationalInfoDeserializer();

    public static OperationalInfoDeserializer getInstance() {
        return deserializer;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Map mapping) throws MessageProcessingException {
        OperationalInfo operationalInfo = new OperationalInfo();
        Vector<Attribute> usedAttribute = new Vector<Attribute>();
        int i = 0;
        while (i < token.getAttributeCount()) {
            Attribute attribute = token.getAttribute(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                Attribute a = new Attribute();
                attribute.writeTo(a);
                usedAttribute.add(a);
            }
            ++i;
        }
        try {
            int tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            tok = this.deserialize(dataTokenizer, token, mapping, operationalInfo, usedAttribute, true, tok);
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return operationalInfo;
    }

    private int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, OperationalInfo operationalInfo, Vector usedAttribute, boolean checkAttribute, int tok) throws MessageProcessingException {
        try {
            Object deserializer = null;
            Date created = null;
            Date modified = null;
            Date modifiedIncludingChildren = null;
            String nodeID = null;
            String authorizedName = null;
            String entityKey = null;
            Iterator iterator = ((AbstractList)usedAttribute).iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (attribute.value == null || !"entityKey".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                entityKey = new String(StringDeserializer.deserialize(attribute.value));
                operationalInfo.setEntityKey(entityKey);
                iterator.remove();
                break;
            }
            if (checkAttribute && usedAttribute.size() != 0) {
                String attributes = "";
                Iterator iterator2 = ((AbstractList)usedAttribute).iterator();
                while (iterator2.hasNext()) {
                    Attribute attribute = (Attribute)iterator2.next();
                    attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                }
                throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
            }
            boolean isNotExtension = false;
            dataTokenizer.readToken(token);
            if (tok != 3 && ((isNotExtension = "created".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "created"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    created = DateDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setCreated(created);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    created = DateDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setCreated(created);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && ((isNotExtension = "modified".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "modified"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    modified = DateDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setModified(modified);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    modified = DateDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setModified(modified);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && ((isNotExtension = "modifiedIncludingChildren".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "modifiedIncludingChildren"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    modifiedIncludingChildren = DateDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setModifiedIncludingChildren(modifiedIncludingChildren);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    modifiedIncludingChildren = DateDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setModifiedIncludingChildren(modifiedIncludingChildren);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && ((isNotExtension = "nodeID".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "nodeID"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    nodeID = StringDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setNodeID(nodeID);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    nodeID = StringDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setNodeID(nodeID);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && ((isNotExtension = "authorizedName".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "authorizedName"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    authorizedName = StringDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setAuthorizedName(authorizedName);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    authorizedName = StringDeserializer.deserialize(dataTokenizer, token);
                    operationalInfo.setAuthorizedName(authorizedName);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (entityKey == null) {
                throw new MessageProcessingException("Missing required input attribute (entityKey).");
            }
            return tok;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, OperationalInfo operationalInfo, Vector usedAttribute, int tok) throws MessageProcessingException {
        return this.deserialize(dataTokenizer, token, mapping, operationalInfo, usedAttribute, false, tok);
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("deserializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("deserializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.deserializationMapping;
        }
        try {
            if (mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "operationalInfo"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                return ((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "operationalInfo"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
            }
            return this.deserialize(dataTokenizer, token, mapping);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

