/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.uddi.client.serialization.DeserializationMappingKey;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.IntegerDeserializer;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.ListDescription;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ListDescriptionDeserializer
implements XMLDeserializer,
Deserializer {
    public static final ListDescriptionDeserializer deserializer = new ListDescriptionDeserializer();

    public static ListDescriptionDeserializer getInstance() {
        return deserializer;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Map mapping) throws MessageProcessingException {
        ListDescription listDescription = new ListDescription();
        Vector<Attribute> usedAttribute = new Vector<Attribute>();
        int i = 0;
        while (i < token.getAttributeCount()) {
            Attribute attribute = token.getAttribute(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                Attribute a = new Attribute();
                attribute.writeTo(a);
                usedAttribute.add(a);
            }
            ++i;
        }
        try {
            int tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            tok = this.deserialize(dataTokenizer, token, mapping, listDescription, usedAttribute, true, tok);
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return listDescription;
    }

    private int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, ListDescription listDescription, Vector usedAttribute, boolean checkAttribute, int tok) throws MessageProcessingException {
        try {
            Object deserializer = null;
            int includeCount = 0;
            int actualCount = 0;
            int listHead = 0;
            if (checkAttribute && usedAttribute.size() != 0) {
                String attributes = "";
                Iterator iterator = ((AbstractList)usedAttribute).iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                }
                throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
            }
            boolean isNotExtension = false;
            dataTokenizer.readToken(token);
            if (tok != 3 && ((isNotExtension = "includeCount".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "includeCount"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    includeCount = IntegerDeserializer.deserialize(dataTokenizer, token);
                    listDescription.setIncludeCount(includeCount);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    includeCount = IntegerDeserializer.deserialize(dataTokenizer, token);
                    listDescription.setIncludeCount(includeCount);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && ((isNotExtension = "actualCount".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "actualCount"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    actualCount = IntegerDeserializer.deserialize(dataTokenizer, token);
                    listDescription.setActualCount(actualCount);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    actualCount = IntegerDeserializer.deserialize(dataTokenizer, token);
                    listDescription.setActualCount(actualCount);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && ((isNotExtension = "listHead".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "listHead"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    listHead = IntegerDeserializer.deserialize(dataTokenizer, token);
                    listDescription.setListHead(listHead);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    listHead = IntegerDeserializer.deserialize(dataTokenizer, token);
                    listDescription.setListHead(listHead);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            return tok;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, ListDescription listDescription, Vector usedAttribute, int tok) throws MessageProcessingException {
        return this.deserialize(dataTokenizer, token, mapping, listDescription, usedAttribute, false, tok);
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("deserializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("deserializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.deserializationMapping;
        }
        try {
            if (mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "listDescription"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                return ((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "listDescription"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
            }
            return this.deserialize(dataTokenizer, token, mapping);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

