/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.DescriptionSerializer;
import org.systinet.uddi.client.v3.serialization.OverviewDocSerializer;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DescriptionArrayListIterator;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.InstanceDetails;
import org.systinet.uddi.client.v3.struct.OverviewDoc;
import org.systinet.uddi.client.v3.struct.OverviewDocArrayList;
import org.systinet.uddi.client.v3.struct.OverviewDocArrayListIterator;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class InstanceDetailsSerializer
implements XMLSerializer,
Serializer {
    public static final InstanceDetailsSerializer serializer = new InstanceDetailsSerializer();

    public static InstanceDetailsSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "instanceDetails")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "instanceDetails", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        InstanceDetails uddiObject = (InstanceDetails)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, InstanceDetails uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
    }

    public void serializeBody(TokenWriter dataWriter, InstanceDetails uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        SerializationMappingValue serializationMappingValue;
        String instanceParmsField;
        OverviewDocArrayList overviewDocArrayList;
        DescriptionArrayList descriptionArrayList = uddiObject.getDescriptionArrayList();
        if (!Helper.isNull(descriptionArrayList) && descriptionArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue2 = null;
            DescriptionArrayListIterator iterator = descriptionArrayList.descriptionArrayListIterator();
            while (iterator.hasNext()) {
                Description item = iterator.next();
                serializationMappingValue2 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "description")));
                if (serializationMappingValue2 != null) {
                    serializer = serializationMappingValue2.getSerializer();
                    namespaceURI = serializationMappingValue2.getElement().getNamespaceURI();
                    localPart = serializationMappingValue2.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                DescriptionSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "description", mapping);
            }
        }
        if (!Helper.isNull(overviewDocArrayList = uddiObject.getOverviewDocArrayList()) && overviewDocArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue3 = null;
            OverviewDocArrayListIterator iterator = overviewDocArrayList.overviewDocArrayListIterator();
            while (iterator.hasNext()) {
                OverviewDoc item = iterator.next();
                serializationMappingValue3 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "overviewDoc")));
                if (serializationMappingValue3 != null) {
                    serializer = serializationMappingValue3.getSerializer();
                    namespaceURI = serializationMappingValue3.getElement().getNamespaceURI();
                    localPart = serializationMappingValue3.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                OverviewDocSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "overviewDoc", mapping);
            }
            instanceParmsField = uddiObject.getInstanceParms();
            if (!Helper.isNull(instanceParmsField)) {
                if (mapping.containsKey(new SerializationMappingKey(instanceParmsField.getClass().getName(), new QName("urn:uddi-org:api_v3", "instanceParms")))) {
                    serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(instanceParmsField.getClass().getName(), new QName("urn:uddi-org:api_v3", "instanceParms")));
                    StringSerializer.serialize(dataWriter, instanceParmsField, "urn:uddi-org:api_v3", "instanceParms");
                } else {
                    StringSerializer.serialize(dataWriter, instanceParmsField, "urn:uddi-org:api_v3", "instanceParms");
                }
            }
        } else {
            instanceParmsField = uddiObject.getInstanceParms();
            if (!Helper.isNull(instanceParmsField)) {
                if (mapping.containsKey(new SerializationMappingKey(instanceParmsField.getClass().getName(), new QName("urn:uddi-org:api_v3", "instanceParms")))) {
                    serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(instanceParmsField.getClass().getName(), new QName("urn:uddi-org:api_v3", "instanceParms")));
                    StringSerializer.serialize(dataWriter, instanceParmsField, "urn:uddi-org:api_v3", "instanceParms");
                } else {
                    StringSerializer.serialize(dataWriter, instanceParmsField, "urn:uddi-org:api_v3", "instanceParms");
                }
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

