/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.ElementArrayListIterator;
import org.systinet.uddi.client.serialization.ElementSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.BindingTemplateSerializer;
import org.systinet.uddi.client.v3.serialization.CategoryBagSerializer;
import org.systinet.uddi.client.v3.serialization.DescriptionSerializer;
import org.systinet.uddi.client.v3.serialization.NameSerializer;
import org.systinet.uddi.client.v3.struct.BindingTemplate;
import org.systinet.uddi.client.v3.struct.BindingTemplateArrayList;
import org.systinet.uddi.client.v3.struct.BindingTemplateArrayListIterator;
import org.systinet.uddi.client.v3.struct.BusinessService;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DescriptionArrayListIterator;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.uddi.client.v3.struct.NameArrayListIterator;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.w3c.dom.Element;

public class BusinessServiceSerializer
implements XMLSerializer,
Serializer {
    public static final BusinessServiceSerializer serializer = new BusinessServiceSerializer();

    public static BusinessServiceSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "businessService")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "businessService", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        BusinessService uddiObject = (BusinessService)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, BusinessService uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        String businessKey;
        String serviceKey = uddiObject.getServiceKey();
        if (!Helper.isNull(serviceKey)) {
            StringSerializer.serializeAttribute(dataWriter, serviceKey, "", "serviceKey");
        }
        if (!Helper.isNull(businessKey = uddiObject.getBusinessKey())) {
            StringSerializer.serializeAttribute(dataWriter, businessKey, "", "businessKey");
        }
    }

    public void serializeBody(TokenWriter dataWriter, BusinessService uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        ElementArrayList SignatureArrayList;
        CategoryBag categoryBagField;
        BindingTemplateArrayList bindingTemplateArrayList;
        DescriptionArrayList descriptionArrayList;
        SerializationMappingValue serializationMappingValue;
        NameArrayList nameArrayList = uddiObject.getNameArrayList();
        if (!Helper.isNull(nameArrayList) && nameArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            serializationMappingValue = null;
            NameArrayListIterator iterator = nameArrayList.nameArrayListIterator();
            while (iterator.hasNext()) {
                Name item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "name")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                NameSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "name", mapping);
            }
        }
        if (!Helper.isNull(descriptionArrayList = uddiObject.getDescriptionArrayList()) && descriptionArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue2 = null;
            DescriptionArrayListIterator iterator = descriptionArrayList.descriptionArrayListIterator();
            while (iterator.hasNext()) {
                Description item = iterator.next();
                serializationMappingValue2 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "description")));
                if (serializationMappingValue2 != null) {
                    serializer = serializationMappingValue2.getSerializer();
                    namespaceURI = serializationMappingValue2.getElement().getNamespaceURI();
                    localPart = serializationMappingValue2.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                DescriptionSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "description", mapping);
            }
        }
        if (!Helper.isNull(bindingTemplateArrayList = uddiObject.getBindingTemplateArrayList()) && bindingTemplateArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "bindingTemplates");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue3 = null;
            BindingTemplateArrayListIterator iterator = bindingTemplateArrayList.bindingTemplateArrayListIterator();
            while (iterator.hasNext()) {
                BindingTemplate item = iterator.next();
                serializationMappingValue3 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "bindingTemplate")));
                if (serializationMappingValue3 != null) {
                    serializer = serializationMappingValue3.getSerializer();
                    namespaceURI = serializationMappingValue3.getElement().getNamespaceURI();
                    localPart = serializationMappingValue3.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                BindingTemplateSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "bindingTemplate", mapping);
            }
            dataWriter.leave();
        }
        if (!Helper.isNull(categoryBagField = uddiObject.getCategoryBag())) {
            if (mapping.containsKey(new SerializationMappingKey(categoryBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "categoryBag")))) {
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(categoryBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "categoryBag")));
                serializationMappingValue.getSerializer().serialize(dataWriter, categoryBagField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                CategoryBagSerializer.getInstance().serialize(dataWriter, categoryBagField, "urn:uddi-org:api_v3", "categoryBag", mapping);
            }
        }
        if (!Helper.isNull(SignatureArrayList = uddiObject.getSignatureArrayList()) && SignatureArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue4 = null;
            ElementArrayListIterator iterator = SignatureArrayList.elementArrayListIterator();
            while (iterator.hasNext()) {
                Element item = iterator.next();
                serializationMappingValue4 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("http://www.w3.org/2000/09/xmldsig#", "Signature")));
                if (serializationMappingValue4 != null) {
                    serializer = serializationMappingValue4.getSerializer();
                    namespaceURI = serializationMappingValue4.getElement().getNamespaceURI();
                    localPart = serializationMappingValue4.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                ElementSerializer.serialize(dataWriter, item, "http://www.w3.org/2000/09/xmldsig#", "Signature");
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

