/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.ElementArrayListIterator;
import org.systinet.uddi.client.serialization.ElementSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.BusinessServiceSerializer;
import org.systinet.uddi.client.v3.serialization.CategoryBagSerializer;
import org.systinet.uddi.client.v3.serialization.ContactSerializer;
import org.systinet.uddi.client.v3.serialization.DescriptionSerializer;
import org.systinet.uddi.client.v3.serialization.DiscoveryURLSerializer;
import org.systinet.uddi.client.v3.serialization.IdentifierBagSerializer;
import org.systinet.uddi.client.v3.serialization.NameSerializer;
import org.systinet.uddi.client.v3.struct.BusinessEntity;
import org.systinet.uddi.client.v3.struct.BusinessService;
import org.systinet.uddi.client.v3.struct.BusinessServiceArrayList;
import org.systinet.uddi.client.v3.struct.BusinessServiceArrayListIterator;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Contact;
import org.systinet.uddi.client.v3.struct.ContactArrayList;
import org.systinet.uddi.client.v3.struct.ContactArrayListIterator;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DescriptionArrayListIterator;
import org.systinet.uddi.client.v3.struct.DiscoveryURL;
import org.systinet.uddi.client.v3.struct.DiscoveryURLArrayList;
import org.systinet.uddi.client.v3.struct.DiscoveryURLArrayListIterator;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.IdentifierBag;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.uddi.client.v3.struct.NameArrayListIterator;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.w3c.dom.Element;

public class BusinessEntitySerializer
implements XMLSerializer,
Serializer {
    public static final BusinessEntitySerializer serializer = new BusinessEntitySerializer();

    public static BusinessEntitySerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "businessEntity")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "businessEntity", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        BusinessEntity uddiObject = (BusinessEntity)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, BusinessEntity uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        String businessKey = uddiObject.getBusinessKey();
        if (!Helper.isNull(businessKey)) {
            StringSerializer.serializeAttribute(dataWriter, businessKey, "", "businessKey");
        }
    }

    public void serializeBody(TokenWriter dataWriter, BusinessEntity uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        ElementArrayList SignatureArrayList;
        CategoryBag categoryBagField;
        IdentifierBag identifierBagField;
        BusinessServiceArrayList businessServiceArrayList;
        SerializationMappingValue serializationMappingValue;
        ContactArrayList contactArrayList;
        SerializationMappingValue serializationMappingValue2;
        DescriptionArrayList descriptionArrayList;
        NameArrayList nameArrayList;
        DiscoveryURLArrayList discoveryURLArrayList = uddiObject.getDiscoveryURLArrayList();
        if (!Helper.isNull(discoveryURLArrayList) && discoveryURLArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "discoveryURLs");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue3 = null;
            DiscoveryURLArrayListIterator iterator = discoveryURLArrayList.discoveryURLArrayListIterator();
            while (iterator.hasNext()) {
                DiscoveryURL item = iterator.next();
                serializationMappingValue3 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "discoveryURL")));
                if (serializationMappingValue3 != null) {
                    serializer = serializationMappingValue3.getSerializer();
                    namespaceURI = serializationMappingValue3.getElement().getNamespaceURI();
                    localPart = serializationMappingValue3.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                DiscoveryURLSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "discoveryURL", mapping);
            }
            dataWriter.leave();
        }
        if (!Helper.isNull(nameArrayList = uddiObject.getNameArrayList()) && nameArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue4 = null;
            NameArrayListIterator iterator = nameArrayList.nameArrayListIterator();
            while (iterator.hasNext()) {
                Name item = iterator.next();
                serializationMappingValue4 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "name")));
                if (serializationMappingValue4 != null) {
                    serializer = serializationMappingValue4.getSerializer();
                    namespaceURI = serializationMappingValue4.getElement().getNamespaceURI();
                    localPart = serializationMappingValue4.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                NameSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "name", mapping);
            }
        }
        if (!Helper.isNull(descriptionArrayList = uddiObject.getDescriptionArrayList()) && descriptionArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            serializationMappingValue2 = null;
            DescriptionArrayListIterator iterator = descriptionArrayList.descriptionArrayListIterator();
            while (iterator.hasNext()) {
                Description item = iterator.next();
                serializationMappingValue2 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "description")));
                if (serializationMappingValue2 != null) {
                    serializer = serializationMappingValue2.getSerializer();
                    namespaceURI = serializationMappingValue2.getElement().getNamespaceURI();
                    localPart = serializationMappingValue2.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                DescriptionSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "description", mapping);
            }
        }
        if (!Helper.isNull(contactArrayList = uddiObject.getContactArrayList()) && contactArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "contacts");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            serializationMappingValue = null;
            ContactArrayListIterator iterator = contactArrayList.contactArrayListIterator();
            while (iterator.hasNext()) {
                Contact item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "contact")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                ContactSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "contact", mapping);
            }
            dataWriter.leave();
        }
        if (!Helper.isNull(businessServiceArrayList = uddiObject.getBusinessServiceArrayList()) && businessServiceArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "businessServices");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue5 = null;
            BusinessServiceArrayListIterator iterator = businessServiceArrayList.businessServiceArrayListIterator();
            while (iterator.hasNext()) {
                BusinessService item = iterator.next();
                serializationMappingValue5 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "businessService")));
                if (serializationMappingValue5 != null) {
                    serializer = serializationMappingValue5.getSerializer();
                    namespaceURI = serializationMappingValue5.getElement().getNamespaceURI();
                    localPart = serializationMappingValue5.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                BusinessServiceSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "businessService", mapping);
            }
            dataWriter.leave();
        }
        if (!Helper.isNull(identifierBagField = uddiObject.getIdentifierBag())) {
            if (mapping.containsKey(new SerializationMappingKey(identifierBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "identifierBag")))) {
                serializationMappingValue2 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(identifierBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "identifierBag")));
                serializationMappingValue2.getSerializer().serialize(dataWriter, identifierBagField, serializationMappingValue2.getElement().getNamespaceURI(), serializationMappingValue2.getElement().getLocalPart(), mapping);
            } else {
                IdentifierBagSerializer.getInstance().serialize(dataWriter, identifierBagField, "urn:uddi-org:api_v3", "identifierBag", mapping);
            }
        }
        if (!Helper.isNull(categoryBagField = uddiObject.getCategoryBag())) {
            if (mapping.containsKey(new SerializationMappingKey(categoryBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "categoryBag")))) {
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(categoryBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "categoryBag")));
                serializationMappingValue.getSerializer().serialize(dataWriter, categoryBagField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                CategoryBagSerializer.getInstance().serialize(dataWriter, categoryBagField, "urn:uddi-org:api_v3", "categoryBag", mapping);
            }
        }
        if (!Helper.isNull(SignatureArrayList = uddiObject.getSignatureArrayList()) && SignatureArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue6 = null;
            ElementArrayListIterator iterator = SignatureArrayList.elementArrayListIterator();
            while (iterator.hasNext()) {
                Element item = iterator.next();
                serializationMappingValue6 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("http://www.w3.org/2000/09/xmldsig#", "Signature")));
                if (serializationMappingValue6 != null) {
                    serializer = serializationMappingValue6.getSerializer();
                    namespaceURI = serializationMappingValue6.getElement().getNamespaceURI();
                    localPart = serializationMappingValue6.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                ElementSerializer.serialize(dataWriter, item, "http://www.w3.org/2000/09/xmldsig#", "Signature");
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

