/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.serialization.DeserializationMappingKey;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.ElementDeserializer;
import org.systinet.uddi.client.serialization.StringDeserializer;
import org.systinet.uddi.client.v3.serialization.BusinessServiceDeserializer;
import org.systinet.uddi.client.v3.serialization.CategoryBagDeserializer;
import org.systinet.uddi.client.v3.serialization.ContactDeserializer;
import org.systinet.uddi.client.v3.serialization.DescriptionDeserializer;
import org.systinet.uddi.client.v3.serialization.DiscoveryURLDeserializer;
import org.systinet.uddi.client.v3.serialization.IdentifierBagDeserializer;
import org.systinet.uddi.client.v3.serialization.NameDeserializer;
import org.systinet.uddi.client.v3.struct.BusinessEntity;
import org.systinet.uddi.client.v3.struct.BusinessService;
import org.systinet.uddi.client.v3.struct.BusinessServiceArrayList;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Contact;
import org.systinet.uddi.client.v3.struct.ContactArrayList;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DiscoveryURL;
import org.systinet.uddi.client.v3.struct.DiscoveryURLArrayList;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.IdentifierBag;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.w3c.dom.Element;

public class BusinessEntityDeserializer
implements XMLDeserializer,
Deserializer {
    public static final BusinessEntityDeserializer deserializer = new BusinessEntityDeserializer();

    public static BusinessEntityDeserializer getInstance() {
        return deserializer;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Map mapping) throws MessageProcessingException {
        BusinessEntity businessEntity = new BusinessEntity();
        Vector<Attribute> usedAttribute = new Vector<Attribute>();
        int i = 0;
        while (i < token.getAttributeCount()) {
            Attribute attribute = token.getAttribute(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                Attribute a = new Attribute();
                attribute.writeTo(a);
                usedAttribute.add(a);
            }
            ++i;
        }
        try {
            int tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            tok = this.deserialize(dataTokenizer, token, mapping, businessEntity, usedAttribute, true, tok);
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return businessEntity;
    }

    private int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, BusinessEntity businessEntity, Vector usedAttribute, boolean checkAttribute, int tok) throws MessageProcessingException {
        try {
            Deserializer deserializer = null;
            DiscoveryURLArrayList discoveryURLArrayList = null;
            NameArrayList nameArrayList = null;
            DescriptionArrayList descriptionArrayList = null;
            ContactArrayList contactArrayList = null;
            BusinessServiceArrayList businessServiceArrayList = null;
            IdentifierBag identifierBag = null;
            CategoryBag categoryBag = null;
            ElementArrayList SignatureArrayList = null;
            String businessKey = null;
            Iterator iterator = ((AbstractList)usedAttribute).iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (attribute.value == null || !"businessKey".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                businessKey = new String(StringDeserializer.deserialize(attribute.value));
                businessEntity.setBusinessKey(businessKey);
                iterator.remove();
                break;
            }
            if (checkAttribute && usedAttribute.size() != 0) {
                String attributes = "";
                Iterator iterator2 = ((AbstractList)usedAttribute).iterator();
                while (iterator2.hasNext()) {
                    Attribute attribute = (Attribute)iterator2.next();
                    attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                }
                throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
            }
            boolean isNotExtension = false;
            dataTokenizer.readToken(token);
            if (tok != 3 && "discoveryURLs".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) {
                dataTokenizer.readToken(token);
                if (token.getAttributeCount() != 0) {
                    throw new MessageProcessingException("Unexpected input attribute {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
                if (tok != 3 && (isNotExtension = "discoveryURL".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "discoveryURL"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                    while (tok != 3 && (isNotExtension = "discoveryURL".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "discoveryURL"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                        if (discoveryURLArrayList == null) {
                            discoveryURLArrayList = new DiscoveryURLArrayList();
                        }
                        if (isNotExtension) {
                            discoveryURLArrayList.add((DiscoveryURL)DiscoveryURLDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                        } else {
                            discoveryURLArrayList.add((DiscoveryURL)deserializer.deserialize(dataTokenizer, token, mapping));
                        }
                        tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                        dataTokenizer.readToken(token);
                    }
                    businessEntity.setDiscoveryURLArrayList(discoveryURLArrayList);
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
            }
            if (tok != 3 && (isNotExtension = "name".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "name"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "name".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "name"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (nameArrayList == null) {
                        nameArrayList = new NameArrayList();
                    }
                    if (isNotExtension) {
                        nameArrayList.add((Name)NameDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        nameArrayList.add((Name)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                businessEntity.setNameArrayList(nameArrayList);
            }
            if (tok != 3 && (isNotExtension = "description".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "description"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "description".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "description"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (descriptionArrayList == null) {
                        descriptionArrayList = new DescriptionArrayList();
                    }
                    if (isNotExtension) {
                        descriptionArrayList.add((Description)DescriptionDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        descriptionArrayList.add((Description)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                businessEntity.setDescriptionArrayList(descriptionArrayList);
            }
            if (tok != 3 && "contacts".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) {
                dataTokenizer.readToken(token);
                if (token.getAttributeCount() != 0) {
                    throw new MessageProcessingException("Unexpected input attribute {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
                if (tok != 3 && (isNotExtension = "contact".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "contact"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                    while (tok != 3 && (isNotExtension = "contact".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "contact"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                        if (contactArrayList == null) {
                            contactArrayList = new ContactArrayList();
                        }
                        if (isNotExtension) {
                            contactArrayList.add((Contact)ContactDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                        } else {
                            contactArrayList.add((Contact)deserializer.deserialize(dataTokenizer, token, mapping));
                        }
                        tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                        dataTokenizer.readToken(token);
                    }
                    businessEntity.setContactArrayList(contactArrayList);
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
            }
            if (tok != 3 && "businessServices".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) {
                dataTokenizer.readToken(token);
                if (token.getAttributeCount() != 0) {
                    throw new MessageProcessingException("Unexpected input attribute {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
                if (tok != 3 && (isNotExtension = "businessService".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "businessService"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                    while (tok != 3 && (isNotExtension = "businessService".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "businessService"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                        if (businessServiceArrayList == null) {
                            businessServiceArrayList = new BusinessServiceArrayList();
                        }
                        if (isNotExtension) {
                            businessServiceArrayList.add((BusinessService)BusinessServiceDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                        } else {
                            businessServiceArrayList.add((BusinessService)deserializer.deserialize(dataTokenizer, token, mapping));
                        }
                        tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                        dataTokenizer.readToken(token);
                    }
                    businessEntity.setBusinessServiceArrayList(businessServiceArrayList);
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
            }
            if (tok != 3 && ((isNotExtension = "identifierBag".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "identifierBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    identifierBag = (IdentifierBag)IdentifierBagDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    businessEntity.setIdentifierBag(identifierBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    identifierBag = (IdentifierBag)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "identifierBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    businessEntity.setIdentifierBag(identifierBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && ((isNotExtension = "categoryBag".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "categoryBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    categoryBag = (CategoryBag)CategoryBagDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    businessEntity.setCategoryBag(categoryBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    categoryBag = (CategoryBag)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "categoryBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    businessEntity.setCategoryBag(categoryBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && (isNotExtension = "Signature".equals(dataTokenizer.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "Signature".equals(dataTokenizer.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (SignatureArrayList == null) {
                        SignatureArrayList = new ElementArrayList();
                    }
                    if (isNotExtension) {
                        SignatureArrayList.add(ElementDeserializer.deserialize(dataTokenizer, token));
                    } else {
                        SignatureArrayList.add((Element)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                businessEntity.setSignatureArrayList(SignatureArrayList);
            }
            if (nameArrayList == null) {
                throw new MessageProcessingException("Missing required input element ({urn:uddi-org:api_v3}nameArrayList).");
            }
            return tok;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, BusinessEntity businessEntity, Vector usedAttribute, int tok) throws MessageProcessingException {
        return this.deserialize(dataTokenizer, token, mapping, businessEntity, usedAttribute, false, tok);
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("deserializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("deserializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.deserializationMapping;
        }
        try {
            if (mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "businessEntity"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                return ((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "businessEntity"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
            }
            return this.deserialize(dataTokenizer, token, mapping);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

