/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.ElementArrayListIterator;
import org.systinet.uddi.client.serialization.ElementSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.serialization.AccessPointSerializer;
import org.systinet.uddi.client.v3.serialization.CategoryBagSerializer;
import org.systinet.uddi.client.v3.serialization.DescriptionSerializer;
import org.systinet.uddi.client.v3.serialization.HostingRedirectorSerializer;
import org.systinet.uddi.client.v3.serialization.TModelInstanceInfoSerializer;
import org.systinet.uddi.client.v3.struct.AccessPoint;
import org.systinet.uddi.client.v3.struct.BindingTemplate;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DescriptionArrayListIterator;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.HostingRedirector;
import org.systinet.uddi.client.v3.struct.TModelInstanceInfo;
import org.systinet.uddi.client.v3.struct.TModelInstanceInfoArrayList;
import org.systinet.uddi.client.v3.struct.TModelInstanceInfoArrayListIterator;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.w3c.dom.Element;

public class BindingTemplateSerializer
implements XMLSerializer,
Serializer {
    public static final BindingTemplateSerializer serializer = new BindingTemplateSerializer();

    public static BindingTemplateSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "bindingTemplate")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "bindingTemplate", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        BindingTemplate uddiObject = (BindingTemplate)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, BindingTemplate uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        String serviceKey;
        String bindingKey = uddiObject.getBindingKey();
        if (!Helper.isNull(bindingKey)) {
            StringSerializer.serializeAttribute(dataWriter, bindingKey, "", "bindingKey");
        }
        if (!Helper.isNull(serviceKey = uddiObject.getServiceKey())) {
            StringSerializer.serializeAttribute(dataWriter, serviceKey, "", "serviceKey");
        }
    }

    public void serializeBody(TokenWriter dataWriter, BindingTemplate uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        ElementArrayList SignatureArrayList;
        CategoryBag categoryBagField;
        AccessPoint accessPointField;
        SerializationMappingValue serializationMappingValue;
        DescriptionArrayList descriptionArrayList = uddiObject.getDescriptionArrayList();
        if (!Helper.isNull(descriptionArrayList) && descriptionArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            serializationMappingValue = null;
            DescriptionArrayListIterator iterator = descriptionArrayList.descriptionArrayListIterator();
            while (iterator.hasNext()) {
                Description item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "description")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                DescriptionSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "description", mapping);
            }
        }
        if (!Helper.isNull(accessPointField = uddiObject.getAccessPoint())) {
            if (mapping.containsKey(new SerializationMappingKey(accessPointField.getClass().getName(), new QName("urn:uddi-org:api_v3", "accessPoint")))) {
                SerializationMappingValue serializationMappingValue2 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(accessPointField.getClass().getName(), new QName("urn:uddi-org:api_v3", "accessPoint")));
                serializationMappingValue2.getSerializer().serialize(dataWriter, accessPointField, serializationMappingValue2.getElement().getNamespaceURI(), serializationMappingValue2.getElement().getLocalPart(), mapping);
            } else {
                AccessPointSerializer.getInstance().serialize(dataWriter, accessPointField, "urn:uddi-org:api_v3", "accessPoint", mapping);
            }
        } else {
            HostingRedirector hostingRedirectorField = uddiObject.getHostingRedirector();
            if (!Helper.isNull(hostingRedirectorField)) {
                if (mapping.containsKey(new SerializationMappingKey(hostingRedirectorField.getClass().getName(), new QName("urn:uddi-org:api_v3", "hostingRedirector")))) {
                    SerializationMappingValue serializationMappingValue3 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(hostingRedirectorField.getClass().getName(), new QName("urn:uddi-org:api_v3", "hostingRedirector")));
                    serializationMappingValue3.getSerializer().serialize(dataWriter, hostingRedirectorField, serializationMappingValue3.getElement().getNamespaceURI(), serializationMappingValue3.getElement().getLocalPart(), mapping);
                } else {
                    HostingRedirectorSerializer.getInstance().serialize(dataWriter, hostingRedirectorField, "urn:uddi-org:api_v3", "hostingRedirector", mapping);
                }
            }
        }
        TModelInstanceInfoArrayList tModelInstanceInfoArrayList = uddiObject.getTModelInstanceInfoArrayList();
        if (!Helper.isNull(tModelInstanceInfoArrayList) && tModelInstanceInfoArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "tModelInstanceDetails");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue4 = null;
            TModelInstanceInfoArrayListIterator iterator = tModelInstanceInfoArrayList.tModelInstanceInfoArrayListIterator();
            while (iterator.hasNext()) {
                TModelInstanceInfo item = iterator.next();
                serializationMappingValue4 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "tModelInstanceInfo")));
                if (serializationMappingValue4 != null) {
                    serializer = serializationMappingValue4.getSerializer();
                    namespaceURI = serializationMappingValue4.getElement().getNamespaceURI();
                    localPart = serializationMappingValue4.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                TModelInstanceInfoSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "tModelInstanceInfo", mapping);
            }
            dataWriter.leave();
        }
        if (!Helper.isNull(categoryBagField = uddiObject.getCategoryBag())) {
            if (mapping.containsKey(new SerializationMappingKey(categoryBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "categoryBag")))) {
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(categoryBagField.getClass().getName(), new QName("urn:uddi-org:api_v3", "categoryBag")));
                serializationMappingValue.getSerializer().serialize(dataWriter, categoryBagField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                CategoryBagSerializer.getInstance().serialize(dataWriter, categoryBagField, "urn:uddi-org:api_v3", "categoryBag", mapping);
            }
        }
        if (!Helper.isNull(SignatureArrayList = uddiObject.getSignatureArrayList()) && SignatureArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue5 = null;
            ElementArrayListIterator iterator = SignatureArrayList.elementArrayListIterator();
            while (iterator.hasNext()) {
                Element item = iterator.next();
                serializationMappingValue5 = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("http://www.w3.org/2000/09/xmldsig#", "Signature")));
                if (serializationMappingValue5 != null) {
                    serializer = serializationMappingValue5.getSerializer();
                    namespaceURI = serializationMappingValue5.getElement().getNamespaceURI();
                    localPart = serializationMappingValue5.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                ElementSerializer.serialize(dataWriter, item, "http://www.w3.org/2000/09/xmldsig#", "Signature");
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

