/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.serialization.DeserializationMappingKey;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.ElementDeserializer;
import org.systinet.uddi.client.serialization.StringDeserializer;
import org.systinet.uddi.client.v3.serialization.AccessPointDeserializer;
import org.systinet.uddi.client.v3.serialization.CategoryBagDeserializer;
import org.systinet.uddi.client.v3.serialization.DescriptionDeserializer;
import org.systinet.uddi.client.v3.serialization.HostingRedirectorDeserializer;
import org.systinet.uddi.client.v3.serialization.TModelInstanceInfoDeserializer;
import org.systinet.uddi.client.v3.struct.AccessPoint;
import org.systinet.uddi.client.v3.struct.BindingTemplate;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.HostingRedirector;
import org.systinet.uddi.client.v3.struct.TModelInstanceInfo;
import org.systinet.uddi.client.v3.struct.TModelInstanceInfoArrayList;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.w3c.dom.Element;

public class BindingTemplateDeserializer
implements XMLDeserializer,
Deserializer {
    public static final BindingTemplateDeserializer deserializer = new BindingTemplateDeserializer();

    public static BindingTemplateDeserializer getInstance() {
        return deserializer;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Map mapping) throws MessageProcessingException {
        BindingTemplate bindingTemplate = new BindingTemplate();
        Vector<Attribute> usedAttribute = new Vector<Attribute>();
        int i = 0;
        while (i < token.getAttributeCount()) {
            Attribute attribute = token.getAttribute(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                Attribute a = new Attribute();
                attribute.writeTo(a);
                usedAttribute.add(a);
            }
            ++i;
        }
        try {
            int tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            tok = this.deserialize(dataTokenizer, token, mapping, bindingTemplate, usedAttribute, true, tok);
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return bindingTemplate;
    }

    private int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, BindingTemplate bindingTemplate, Vector usedAttribute, boolean checkAttribute, int tok) throws MessageProcessingException {
        try {
            Deserializer deserializer = null;
            DescriptionArrayList descriptionArrayList = null;
            AccessPoint accessPoint = null;
            HostingRedirector hostingRedirector = null;
            TModelInstanceInfoArrayList tModelInstanceInfoArrayList = null;
            CategoryBag categoryBag = null;
            ElementArrayList SignatureArrayList = null;
            String bindingKey = null;
            String serviceKey = null;
            Iterator iterator = ((AbstractList)usedAttribute).iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (attribute.value == null || !"bindingKey".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                bindingKey = new String(StringDeserializer.deserialize(attribute.value));
                bindingTemplate.setBindingKey(bindingKey);
                iterator.remove();
                break;
            }
            Iterator iterator2 = ((AbstractList)usedAttribute).iterator();
            while (iterator2.hasNext()) {
                Attribute attribute = (Attribute)iterator2.next();
                if (attribute.value == null || !"serviceKey".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                serviceKey = new String(StringDeserializer.deserialize(attribute.value));
                bindingTemplate.setServiceKey(serviceKey);
                iterator2.remove();
                break;
            }
            if (checkAttribute && usedAttribute.size() != 0) {
                String attributes = "";
                Iterator iterator3 = ((AbstractList)usedAttribute).iterator();
                while (iterator3.hasNext()) {
                    Attribute attribute = (Attribute)iterator3.next();
                    attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                }
                throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
            }
            boolean isNotExtension = false;
            dataTokenizer.readToken(token);
            if (tok != 3 && (isNotExtension = "description".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "description"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "description".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "description"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (descriptionArrayList == null) {
                        descriptionArrayList = new DescriptionArrayList();
                    }
                    if (isNotExtension) {
                        descriptionArrayList.add((Description)DescriptionDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        descriptionArrayList.add((Description)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                bindingTemplate.setDescriptionArrayList(descriptionArrayList);
            }
            if (tok != 3 && ((isNotExtension = "accessPoint".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "accessPoint"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    accessPoint = (AccessPoint)AccessPointDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    bindingTemplate.setAccessPoint(accessPoint);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    accessPoint = (AccessPoint)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "accessPoint"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    bindingTemplate.setAccessPoint(accessPoint);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            } else if (tok != 3 && ((isNotExtension = "hostingRedirector".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "hostingRedirector"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    hostingRedirector = (HostingRedirector)HostingRedirectorDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    bindingTemplate.setHostingRedirector(hostingRedirector);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    hostingRedirector = (HostingRedirector)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "hostingRedirector"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    bindingTemplate.setHostingRedirector(hostingRedirector);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && "tModelInstanceDetails".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) {
                dataTokenizer.readToken(token);
                if (token.getAttributeCount() != 0) {
                    throw new MessageProcessingException("Unexpected input attribute {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
                if (tok != 3 && (isNotExtension = "tModelInstanceInfo".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "tModelInstanceInfo"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                    while (tok != 3 && (isNotExtension = "tModelInstanceInfo".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "tModelInstanceInfo"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                        if (tModelInstanceInfoArrayList == null) {
                            tModelInstanceInfoArrayList = new TModelInstanceInfoArrayList();
                        }
                        if (isNotExtension) {
                            tModelInstanceInfoArrayList.add((TModelInstanceInfo)TModelInstanceInfoDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                        } else {
                            tModelInstanceInfoArrayList.add((TModelInstanceInfo)deserializer.deserialize(dataTokenizer, token, mapping));
                        }
                        tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                        dataTokenizer.readToken(token);
                    }
                    bindingTemplate.setTModelInstanceInfoArrayList(tModelInstanceInfoArrayList);
                }
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                dataTokenizer.readToken(token);
            }
            if (tok != 3 && ((isNotExtension = "categoryBag".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "categoryBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()))))) {
                if (isNotExtension) {
                    categoryBag = (CategoryBag)CategoryBagDeserializer.getInstance().deserialize(dataTokenizer, token, mapping);
                    bindingTemplate.setCategoryBag(categoryBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                } else {
                    categoryBag = (CategoryBag)((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "categoryBag"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
                    bindingTemplate.setCategoryBag(categoryBag);
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
            }
            if (tok != 3 && (isNotExtension = "Signature".equals(dataTokenizer.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "Signature".equals(dataTokenizer.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (SignatureArrayList == null) {
                        SignatureArrayList = new ElementArrayList();
                    }
                    if (isNotExtension) {
                        SignatureArrayList.add(ElementDeserializer.deserialize(dataTokenizer, token));
                    } else {
                        SignatureArrayList.add((Element)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                bindingTemplate.setSignatureArrayList(SignatureArrayList);
            }
            if (accessPoint == null && hostingRedirector == null) {
                throw new MessageProcessingException("Missing required input element. The following elements from the choice must be set better ({urn:uddi-org:api_v3}accessPoint, {urn:uddi-org:api_v3}hostingRedirector).");
            }
            return tok;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, BindingTemplate bindingTemplate, Vector usedAttribute, int tok) throws MessageProcessingException {
        return this.deserialize(dataTokenizer, token, mapping, bindingTemplate, usedAttribute, false, tok);
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("deserializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("deserializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.deserializationMapping;
        }
        try {
            if (mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "bindingTemplate"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                return ((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "bindingTemplate"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
            }
            return this.deserialize(dataTokenizer, token, mapping);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

