/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.BooleanSerializer;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.serialization.BindingTemplateSerializer;
import org.systinet.uddi.client.v3.serialization.ListDescriptionSerializer;
import org.systinet.uddi.client.v3.struct.BindingDetail;
import org.systinet.uddi.client.v3.struct.BindingTemplate;
import org.systinet.uddi.client.v3.struct.BindingTemplateArrayList;
import org.systinet.uddi.client.v3.struct.BindingTemplateArrayListIterator;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.struct.ListDescription;
import org.systinet.uddi.client.v3.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class BindingDetailSerializer
implements XMLSerializer,
Serializer {
    public static final BindingDetailSerializer serializer = new BindingDetailSerializer();

    public static BindingDetailSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("urn:uddi-org:api_v3", "bindingDetail")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "urn:uddi-org:api_v3", "bindingDetail", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        BindingDetail uddiObject = (BindingDetail)data;
        try {
            dataWriter.enter(namespace, localName);
            dataWriter.setPrefixForNamespace("", namespace);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, BindingDetail uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        Boolean truncated = uddiObject.getTruncated();
        if (!Helper.isNull(truncated)) {
            BooleanSerializer.serializeAttribute(dataWriter, truncated, "", "truncated");
        }
    }

    public void serializeBody(TokenWriter dataWriter, BindingDetail uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        BindingTemplateArrayList bindingTemplateArrayList;
        ListDescription listDescriptionField = uddiObject.getListDescription();
        if (!Helper.isNull(listDescriptionField)) {
            if (mapping.containsKey(new SerializationMappingKey(listDescriptionField.getClass().getName(), new QName("urn:uddi-org:api_v3", "listDescription")))) {
                SerializationMappingValue serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(listDescriptionField.getClass().getName(), new QName("urn:uddi-org:api_v3", "listDescription")));
                serializationMappingValue.getSerializer().serialize(dataWriter, listDescriptionField, serializationMappingValue.getElement().getNamespaceURI(), serializationMappingValue.getElement().getLocalPart(), mapping);
            } else {
                ListDescriptionSerializer.getInstance().serialize(dataWriter, listDescriptionField, "urn:uddi-org:api_v3", "listDescription", mapping);
            }
        }
        if (!Helper.isNull(bindingTemplateArrayList = uddiObject.getBindingTemplateArrayList()) && bindingTemplateArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            BindingTemplateArrayListIterator iterator = bindingTemplateArrayList.bindingTemplateArrayListIterator();
            while (iterator.hasNext()) {
                BindingTemplate item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "bindingTemplate")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, item, namespaceURI, localPart, mapping);
                    continue;
                }
                BindingTemplateSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "bindingTemplate", mapping);
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

