/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.uddi.client.serialization.DeserializationMappingKey;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.StringDeserializer;
import org.systinet.uddi.client.v3.serialization.AddressLineDeserializer;
import org.systinet.uddi.client.v3.struct.Address;
import org.systinet.uddi.client.v3.struct.AddressLine;
import org.systinet.uddi.client.v3.struct.AddressLineArrayList;
import org.systinet.uddi.client.v3.struct.ExtensionMapping;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class AddressDeserializer
implements XMLDeserializer,
Deserializer {
    public static final AddressDeserializer deserializer = new AddressDeserializer();

    public static AddressDeserializer getInstance() {
        return deserializer;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Map mapping) throws MessageProcessingException {
        Address address = new Address();
        Vector<Attribute> usedAttribute = new Vector<Attribute>();
        int i = 0;
        while (i < token.getAttributeCount()) {
            Attribute attribute = token.getAttribute(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                Attribute a = new Attribute();
                attribute.writeTo(a);
                usedAttribute.add(a);
            }
            ++i;
        }
        try {
            int tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            tok = this.deserialize(dataTokenizer, token, mapping, address, usedAttribute, true, tok);
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return address;
    }

    private int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, Address address, Vector usedAttribute, boolean checkAttribute, int tok) throws MessageProcessingException {
        try {
            Deserializer deserializer = null;
            AddressLineArrayList addressLineArrayList = null;
            String lang = null;
            String useType = null;
            String sortCode = null;
            String tModelKey = null;
            Iterator iterator = ((AbstractList)usedAttribute).iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (attribute.value == null || !"lang".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "http://www.w3.org/XML/1998/namespace".length() != 0) && (attribute.uri == null || !attribute.uri.equals("http://www.w3.org/XML/1998/namespace"))) continue;
                lang = new String(StringDeserializer.deserialize(attribute.value));
                address.setLang(lang);
                iterator.remove();
                break;
            }
            Iterator iterator2 = ((AbstractList)usedAttribute).iterator();
            while (iterator2.hasNext()) {
                Attribute attribute = (Attribute)iterator2.next();
                if (attribute.value == null || !"useType".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                useType = new String(StringDeserializer.deserialize(attribute.value));
                address.setUseType(useType);
                iterator2.remove();
                break;
            }
            Iterator iterator3 = ((AbstractList)usedAttribute).iterator();
            while (iterator3.hasNext()) {
                Attribute attribute = (Attribute)iterator3.next();
                if (attribute.value == null || !"sortCode".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                sortCode = new String(StringDeserializer.deserialize(attribute.value));
                address.setSortCode(sortCode);
                iterator3.remove();
                break;
            }
            Iterator iterator4 = ((AbstractList)usedAttribute).iterator();
            while (iterator4.hasNext()) {
                Attribute attribute = (Attribute)iterator4.next();
                if (attribute.value == null || !"tModelKey".equals(attribute.localName) || (attribute.uri != null && attribute.uri.length() != 0 || "".length() != 0) && (attribute.uri == null || !attribute.uri.equals(""))) continue;
                tModelKey = new String(StringDeserializer.deserialize(attribute.value));
                address.setTModelKey(tModelKey);
                iterator4.remove();
                break;
            }
            if (checkAttribute && usedAttribute.size() != 0) {
                String attributes = "";
                Iterator iterator5 = ((AbstractList)usedAttribute).iterator();
                while (iterator5.hasNext()) {
                    Attribute attribute = (Attribute)iterator5.next();
                    attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                }
                throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
            }
            boolean isNotExtension = false;
            dataTokenizer.readToken(token);
            if (tok != 3 && (isNotExtension = "addressLine".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "addressLine"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                while (tok != 3 && (isNotExtension = "addressLine".equals(dataTokenizer.getLocalName()) && "urn:uddi-org:api_v3".equals(dataTokenizer.getNamespace())) || (deserializer = (Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "addressLine"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) != null) {
                    if (addressLineArrayList == null) {
                        addressLineArrayList = new AddressLineArrayList();
                    }
                    if (isNotExtension) {
                        addressLineArrayList.add((AddressLine)AddressLineDeserializer.getInstance().deserialize(dataTokenizer, token, mapping));
                    } else {
                        addressLineArrayList.add((AddressLine)deserializer.deserialize(dataTokenizer, token, mapping));
                    }
                    tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
                    dataTokenizer.readToken(token);
                }
                address.setAddressLineArrayList(addressLineArrayList);
            }
            if (addressLineArrayList == null) {
                throw new MessageProcessingException("Missing required input element ({urn:uddi-org:api_v3}addressLineArrayList).");
            }
            return tok;
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public int deserialize(Tokenizer dataTokenizer, Token token, Map mapping, Address address, Vector usedAttribute, int tok) throws MessageProcessingException {
        return this.deserialize(dataTokenizer, token, mapping, address, usedAttribute, false, tok);
    }

    public Object deserialize(Tokenizer dataTokenizer, Token token, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("deserializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("deserializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.deserializationMapping;
        }
        try {
            if (mapping.containsKey(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "address"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))) {
                return ((Deserializer)mapping.get(new DeserializationMappingKey(new QName("urn:uddi-org:api_v3", "address"), new QName(dataTokenizer.getNamespace(), dataTokenizer.getLocalName())))).deserialize(dataTokenizer, token, mapping);
            }
            return this.deserialize(dataTokenizer, token, mapping);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

