/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3;

import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.client.UDDIErrorCodes;
import org.systinet.uddi.client.v3.struct.DispositionReport;
import org.systinet.uddi.client.v3.struct.ErrInfo;
import org.systinet.uddi.client.v3.struct.Result;
import org.systinet.uddi.client.v3.struct.ResultArrayList;
import org.systinet.uddi.client.v3.struct.ResultArrayListIterator;

public class UDDIException
extends org.systinet.uddi.client.UDDIException {
    protected DispositionReport dispositionReport;

    protected UDDIException() {
    }

    public UDDIException(DispositionReport dispositionReport) {
        this.dispositionReport = dispositionReport;
    }

    public UDDIException(DispositionReport dispositionReport, String faultCode, String faultString) {
        this.dispositionReport = dispositionReport;
        this.faultCode = faultCode;
        this.faultString = faultString;
    }

    public UDDIException(String message, String faultCode, String faultString) {
        this(message);
        this.faultCode = faultCode;
        this.faultString = faultString;
    }

    public UDDIException(Exception e) {
        this(e.getMessage());
    }

    public UDDIException(String message) {
        this(10500, message);
    }

    public UDDIException(int errno) {
        try {
            this.dispositionReport = new DispositionReport(new ResultArrayList(new Result(errno, new ErrInfo(UDDIErrorCodes.getCode(errno), UDDIErrorCodes.getMessage(errno)), null)));
        }
        catch (InvalidParameterException invalidParameterException) {
            // empty catch block
        }
    }

    public UDDIException(int errno, String message) {
        this.setDispositionReport(errno, message);
    }

    public UDDIException(InvalidParameterException invalidParameterException) {
        InvalidParameterErrorCodes errorCodes = invalidParameterException.getErrorCodes();
        if (InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT.equals(errorCodes)) {
            this.setDispositionReport(10050, invalidParameterException.getMessage());
        } else if (InvalidParameterErrorCodes.E_NAME_TOO_LONG.equals(errorCodes)) {
            this.setDispositionReport(10050, invalidParameterException.getMessage());
        } else if (InvalidParameterErrorCodes.E_NAME_TOO_SHORT.equals(errorCodes)) {
            this.setDispositionReport(10050, invalidParameterException.getMessage());
        } else if (InvalidParameterErrorCodes.E_UNSUPPORTED.equals(errorCodes)) {
            this.setDispositionReport(10050, invalidParameterException.getMessage());
        } else {
            this.setDispositionReport(10500, UDDIErrorCodes.getMessage(10500));
        }
    }

    protected void setDispositionReport(int errno, String message) {
        if (message == null) {
            message = "";
        }
        try {
            this.dispositionReport = new DispositionReport(new ResultArrayList(new Result(errno, new ErrInfo(UDDIErrorCodes.getCode(errno), message), null)));
        }
        catch (InvalidParameterException invalidParameterException) {
            // empty catch block
        }
    }

    public DispositionReport getDispositionReport() {
        return this.dispositionReport;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getMessage() {
        return this.dispositionReport.toXML();
    }

    public int getErrno() {
        ResultArrayList results = this.dispositionReport.getResultArrayList();
        if (results != null) {
            ResultArrayListIterator resultArrayListIterator = results.resultArrayListIterator();
            if (resultArrayListIterator.hasNext()) {
                Result result = resultArrayListIterator.next();
                return result.getErrno();
            }
        }
        return 0;
    }
}

