/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.OutputPropertyUtils;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.Trie;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToHTMLStream
extends ToStream {
    protected BoolStack m_isRawStack = new BoolStack();
    private boolean m_inBlockElem = false;
    protected static CharInfo m_htmlcharInfo = CharInfo.getCharInfo(CharInfo.HTML_ENTITIES_RESOURCE);
    static Trie m_elementFlags = new Trie();
    private static ElemDesc m_dummy;
    private boolean m_specialEscapeURLs = true;
    private boolean m_omitMetaTag = false;
    private ElemDesc m_elementDesc = null;

    public void setSpecialEscapeURLs(boolean bool) {
        this.m_specialEscapeURLs = bool;
    }

    public void setOmitMetaTag(boolean bool) {
        this.m_omitMetaTag = bool;
    }

    public void setOutputFormat(Properties format) {
        this.m_specialEscapeURLs = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}use-url-escaping", format);
        this.m_omitMetaTag = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}omit-meta-tag", format);
        super.setOutputFormat(format);
    }

    private final boolean getSpecialEscapeURLs() {
        return this.m_specialEscapeURLs;
    }

    private final boolean getOmitMetaTag() {
        return this.m_omitMetaTag;
    }

    private final ElemDesc getElemDesc(String name) {
        Object obj;
        if (null != name && null != (obj = m_elementFlags.get(name))) {
            return (ElemDesc)obj;
        }
        return m_dummy;
    }

    public ToHTMLStream() {
        this.m_charInfo = m_htmlcharInfo;
        this.m_prefixMap = new NamespaceMappings();
    }

    protected void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        this.setOmitXMLDeclaration(true);
        if (this.m_needToOutputDocTypeDecl) {
            String doctypeSystem = this.getDoctypeSystem();
            String doctypePublic = this.getDoctypePublic();
            if (null != doctypeSystem || null != doctypePublic) {
                try {
                    this.m_writer.write("<!DOCTYPE HTML");
                    if (null != doctypePublic) {
                        this.m_writer.write(" PUBLIC \"");
                        this.m_writer.write(doctypePublic);
                        this.m_writer.write("\"");
                    }
                    if (null != doctypeSystem) {
                        if (null == doctypePublic) {
                            this.m_writer.write(" SYSTEM \"");
                        } else {
                            this.m_writer.write(" \"");
                        }
                        this.m_writer.write(doctypeSystem);
                        this.m_writer.write("\"");
                    }
                    this.m_writer.write(">");
                    this.outputLineSep();
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }
        this.m_needToOutputDocTypeDecl = false;
    }

    public final void endDocument() throws SAXException {
        this.flushPending();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        if (null != namespaceURI && namespaceURI.length() > 0) {
            super.startElement(namespaceURI, localName, name, atts);
            return;
        }
        try {
            boolean savedDoIndent = this.m_doIndent;
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            ElemDesc elemDesc = this.getElemDesc(name);
            boolean isBlockElement = elemDesc.is(8);
            boolean isHeadElement = elemDesc.is(0x400000);
            if (this.m_ispreserve) {
                this.m_ispreserve = false;
            } else if (this.m_doIndent && null != this.m_elementName && (!this.m_inBlockElem || isBlockElement)) {
                this.m_startNewLine = true;
                this.indent();
            }
            this.m_inBlockElem = !isBlockElement;
            this.m_elementLocalName = localName;
            this.m_elementURI = namespaceURI;
            this.m_elementName = name;
            this.m_elementDesc = elemDesc;
            this.m_isRawStack.push(elemDesc.is(256));
            this.m_writer.write(60);
            this.m_writer.write(name);
            if (atts != null) {
                this.addAttributes(atts);
            }
            this.m_startTagOpen = true;
            ++this.m_currentElemDepth;
            this.m_isprevtext = false;
            this.m_doIndent = savedDoIndent;
            if (isHeadElement) {
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                }
                if (!this.m_omitMetaTag) {
                    if (this.m_doIndent) {
                        this.indent();
                    }
                    this.m_writer.write("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
                    String encoding = this.getEncoding();
                    String encode = Encodings.getMimeEncoding(encoding);
                    this.m_writer.write(encode);
                    this.m_writer.write(34);
                    this.m_writer.write(62);
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public final void endElement(String namespaceURI, String localName, String name) throws SAXException {
        ElemDesc elemDesc;
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (null != namespaceURI && namespaceURI.length() > 0) {
            super.endElement(namespaceURI, localName, name);
            return;
        }
        --this.m_currentElemDepth;
        this.m_isRawStack.pop();
        this.m_elementDesc = elemDesc = this.getElemDesc(name);
        boolean isBlockElement = elemDesc.is(8);
        boolean shouldIndent = false;
        if (this.m_ispreserve) {
            this.m_ispreserve = false;
        } else if (this.m_doIndent && (!this.m_inBlockElem || isBlockElement)) {
            this.m_startNewLine = true;
            shouldIndent = true;
        }
        this.m_inBlockElem = !isBlockElement;
        try {
            if (!this.m_startTagOpen) {
                if (shouldIndent) {
                    this.indent();
                }
                this.m_writer.write("</");
                this.m_writer.write(name);
                this.m_writer.write(62);
                this.m_elementName = name;
                if (this.m_cdataSectionElements != null) {
                    this.m_cdataSectionStates.pop();
                }
                if (this.m_doIndent && !this.m_preserves.isEmpty()) {
                    this.m_preserves.pop();
                }
            } else {
                int nAttrs;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elementName);
                }
                if ((nAttrs = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(nAttrs);
                }
                if (!elemDesc.is(2)) {
                    this.m_writer.write(62);
                    this.m_writer.write(60);
                    this.m_writer.write(47);
                    this.m_writer.write(name);
                    this.m_writer.write(62);
                } else {
                    this.m_writer.write(62);
                }
            }
            if (elemDesc.is(0x200000)) {
                this.m_ispreserve = true;
            }
            this.m_startTagOpen = false;
            this.m_isprevtext = false;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.m_elementURI = null;
        this.m_elementLocalName = null;
        if (this.m_tracer != null) {
            super.fireEndElem(name);
        }
    }

    protected void processAttribute(String name, String value, ElemDesc elemDesc) throws IOException {
        this.m_writer.write(32);
        if ((value.length() == 0 || value.equalsIgnoreCase(name)) && elemDesc != null && elemDesc.isAttrFlagSet(name, 4)) {
            this.m_writer.write(name);
        } else {
            this.m_writer.write(name);
            this.m_writer.write(61);
            this.m_writer.write(34);
            if (elemDesc != null && elemDesc.isAttrFlagSet(name, 2)) {
                this.writeAttrURI(value, this.m_specialEscapeURLs);
            } else {
                this.writeAttrString(value, this.getEncoding());
            }
            this.m_writer.write(34);
        }
    }

    private boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private String makeHHString(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    private boolean isHHSign(String str) {
        boolean sign = true;
        try {
            char r = (char)Integer.parseInt(str, 16);
        }
        catch (NumberFormatException e) {
            sign = false;
        }
        return sign;
    }

    public void writeAttrURI(String string, boolean doURLEscaping) throws IOException {
        char[] stringArray = string.toCharArray();
        int len = stringArray.length;
        int i = 0;
        while (i < len) {
            char ch = stringArray[i];
            if (ch < ' ' || ch > '~') {
                if (doURLEscaping) {
                    int high;
                    if (ch <= '\u007f') {
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(ch));
                    } else if (ch <= '\u07ff') {
                        high = ch >> 6 | 0xC0;
                        int low = ch & 0x3F | 0x80;
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(high));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(low));
                    } else if (ToStream.isUTF16Surrogate(ch)) {
                        int highSurrogate = ch & 0x3FF;
                        int wwww = (highSurrogate & 0x3C0) >> 6;
                        int uuuuu = wwww + 1;
                        int zzzz = (highSurrogate & 0x3C) >> 2;
                        int yyyyyy = (highSurrogate & 3) << 4 & 0x30;
                        ch = stringArray[++i];
                        int lowSurrogate = ch & 0x3FF;
                        int xxxxxx = lowSurrogate & 0x3F;
                        int byte1 = 0xF0 | uuuuu >> 2;
                        int byte2 = 0x80 | (uuuuu & 3) << 4 & 0x30 | zzzz;
                        int byte3 = 0x80 | (yyyyyy |= (lowSurrogate & 0x3C0) >> 6);
                        int byte4 = 0x80 | xxxxxx;
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(byte1));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(byte2));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(byte3));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(byte4));
                    } else {
                        high = ch >> 12 | 0xE0;
                        int middle = (ch & 0xFC0) >> 6 | 0x80;
                        int low = ch & 0x3F | 0x80;
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(high));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(middle));
                        this.m_writer.write(37);
                        this.m_writer.write(this.makeHHString(low));
                    }
                } else if (this.escapingNotNeeded(ch)) {
                    this.m_writer.write(ch);
                } else {
                    this.m_writer.write("&#");
                    this.m_writer.write(Integer.toString(ch));
                    this.m_writer.write(59);
                }
            } else if ('%' == ch) {
                this.m_writer.write(ch);
            } else if (ch == '\"') {
                if (doURLEscaping) {
                    this.m_writer.write("%22");
                } else {
                    this.m_writer.write("&quot;");
                }
            } else {
                this.m_writer.write(ch);
            }
            ++i;
        }
    }

    public void writeAttrString(String string, String encoding) throws IOException {
        char[] chars = string.toCharArray();
        int strLen = chars.length;
        int i = 0;
        while (i < strLen) {
            char ch = chars[i];
            if (this.escapingNotNeeded(ch) && !this.m_charInfo.isSpecial(ch)) {
                this.m_writer.write(ch);
            } else if ('<' == ch || '>' == ch) {
                this.m_writer.write(ch);
            } else if ('&' == ch && i + 1 < strLen && '{' == chars[i + 1]) {
                this.m_writer.write(ch);
            } else {
                int pos = this.accumDefaultEntity(this.m_writer, ch, i, chars, strLen, false);
                if (i != pos) {
                    i = pos - 1;
                } else {
                    String entityName;
                    if (ToStream.isUTF16Surrogate(ch)) {
                        i = this.writeUTF16Surrogate(ch, chars, i, strLen);
                    }
                    if (null != (entityName = this.m_charInfo.getEntityNameForChar(ch))) {
                        this.m_writer.write(38);
                        this.m_writer.write(entityName);
                        this.m_writer.write(59);
                    } else if (this.escapingNotNeeded(ch)) {
                        this.m_writer.write(ch);
                    } else {
                        this.m_writer.write("&#");
                        this.m_writer.write(Integer.toString(ch));
                        this.m_writer.write(59);
                    }
                }
            }
            ++i;
        }
    }

    public final void characters(char[] chars, int start, int length) throws SAXException {
        if (this.m_isRawStack.peekOrFalse()) {
            try {
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                this.writeNormalizedChars(chars, start, length, false);
                if (this.m_tracer != null) {
                    super.fireCharEvent(chars, start, length);
                }
                return;
            }
            catch (IOException ioe) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), ioe);
            }
        }
        super.characters(chars, start, length);
    }

    public final void cdata(char[] ch, int start, int length) throws SAXException {
        if (null != this.m_elementName && (this.m_elementName.equalsIgnoreCase("SCRIPT") || this.m_elementName.equalsIgnoreCase("STYLE"))) {
            try {
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                }
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.writeNormalizedChars(ch, start, length, true);
            }
            catch (IOException ioe) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), ioe);
            }
        } else {
            super.cdata(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushPending();
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                } else if (this.m_needToCallStartDocument) {
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.m_writer.write("<?" + target);
                if (data.length() > 0 && !Character.isSpaceChar(data.charAt(0))) {
                    this.m_writer.write(" ");
                }
                this.m_writer.write(data + ">");
                if (this.m_currentElemDepth <= 0) {
                    this.outputLineSep();
                }
                this.m_startNewLine = true;
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(target, data);
        }
    }

    public final void entityReference(String name) throws SAXException {
        try {
            this.m_writer.write("&");
            this.m_writer.write(name);
            this.m_writer.write(";");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public final void endElement(String elemName) throws SAXException {
        this.endElement(null, null, elemName);
    }

    public void processAttributes(int nAttrs) throws IOException, SAXException {
        int i = 0;
        while (i < nAttrs) {
            this.processAttribute(this.m_attributes.getQName(i), this.m_attributes.getValue(i), this.m_elementDesc);
            ++i;
        }
        this.m_attributes.clear();
    }

    protected void closeStartTag() throws SAXException {
        try {
            int nAttrs;
            if (this.m_tracer != null) {
                super.fireStartElem(this.m_elementName);
            }
            if ((nAttrs = this.m_attributes.getLength()) > 0) {
                this.processAttributes(nAttrs);
            }
            this.m_writer.write(62);
            if (this.m_cdataSectionElements != null) {
                this.pushCdataSectionState();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected synchronized void init(OutputStream output, Properties format) throws UnsupportedEncodingException {
        if (null == format) {
            format = OutputPropertiesFactory.getDefaultMethodProperties("html");
        }
        super.init(output, format, false);
    }

    public void setOutputStream(OutputStream output) {
        try {
            Properties format = null == this.m_format ? OutputPropertiesFactory.getDefaultMethodProperties("html") : this.m_format;
            this.init(output, format, true);
        }
        catch (UnsupportedEncodingException uee) {}
    }

    public void namespaceAfterStartElement(String prefix, String uri) throws SAXException {
        String prefix1;
        if (this.m_elementURI == null && (prefix1 = SerializerBase.getPrefixPart(this.m_elementName)) == null && "".equals(prefix)) {
            this.m_elementURI = uri;
        }
        this.startPrefixMapping(prefix, uri, false);
    }

    public void endDTD() throws SAXException {
    }

    static {
        m_elementFlags.put("BASEFONT", new ElemDesc(2));
        m_elementFlags.put("FRAME", new ElemDesc(10));
        m_elementFlags.put("FRAMESET", new ElemDesc(8));
        m_elementFlags.put("NOFRAMES", new ElemDesc(8));
        m_elementFlags.put("ISINDEX", new ElemDesc(10));
        m_elementFlags.put("APPLET", new ElemDesc(0x200000));
        m_elementFlags.put("CENTER", new ElemDesc(8));
        m_elementFlags.put("DIR", new ElemDesc(8));
        m_elementFlags.put("MENU", new ElemDesc(8));
        m_elementFlags.put("TT", new ElemDesc(4096));
        m_elementFlags.put("I", new ElemDesc(4096));
        m_elementFlags.put("B", new ElemDesc(4096));
        m_elementFlags.put("BIG", new ElemDesc(4096));
        m_elementFlags.put("SMALL", new ElemDesc(4096));
        m_elementFlags.put("EM", new ElemDesc(8192));
        m_elementFlags.put("STRONG", new ElemDesc(8192));
        m_elementFlags.put("DFN", new ElemDesc(8192));
        m_elementFlags.put("CODE", new ElemDesc(8192));
        m_elementFlags.put("SAMP", new ElemDesc(8192));
        m_elementFlags.put("KBD", new ElemDesc(8192));
        m_elementFlags.put("VAR", new ElemDesc(8192));
        m_elementFlags.put("CITE", new ElemDesc(8192));
        m_elementFlags.put("ABBR", new ElemDesc(8192));
        m_elementFlags.put("ACRONYM", new ElemDesc(8192));
        m_elementFlags.put("SUP", new ElemDesc(98304));
        m_elementFlags.put("SUB", new ElemDesc(98304));
        m_elementFlags.put("SPAN", new ElemDesc(98304));
        m_elementFlags.put("BDO", new ElemDesc(98304));
        m_elementFlags.put("BR", new ElemDesc(98314));
        m_elementFlags.put("BODY", new ElemDesc(8));
        m_elementFlags.put("ADDRESS", new ElemDesc(56));
        m_elementFlags.put("DIV", new ElemDesc(56));
        m_elementFlags.put("A", new ElemDesc(32768));
        m_elementFlags.put("MAP", new ElemDesc(98312));
        m_elementFlags.put("AREA", new ElemDesc(10));
        m_elementFlags.put("LINK", new ElemDesc(131082));
        m_elementFlags.put("IMG", new ElemDesc(2195458));
        m_elementFlags.put("OBJECT", new ElemDesc(2326528));
        m_elementFlags.put("PARAM", new ElemDesc(2));
        m_elementFlags.put("HR", new ElemDesc(58));
        m_elementFlags.put("P", new ElemDesc(56));
        m_elementFlags.put("H1", new ElemDesc(262152));
        m_elementFlags.put("H2", new ElemDesc(262152));
        m_elementFlags.put("H3", new ElemDesc(262152));
        m_elementFlags.put("H4", new ElemDesc(262152));
        m_elementFlags.put("H5", new ElemDesc(262152));
        m_elementFlags.put("H6", new ElemDesc(262152));
        m_elementFlags.put("PRE", new ElemDesc(0x100008));
        m_elementFlags.put("Q", new ElemDesc(98304));
        m_elementFlags.put("BLOCKQUOTE", new ElemDesc(56));
        m_elementFlags.put("INS", new ElemDesc(0));
        m_elementFlags.put("DEL", new ElemDesc(0));
        m_elementFlags.put("DL", new ElemDesc(56));
        m_elementFlags.put("DT", new ElemDesc(8));
        m_elementFlags.put("DD", new ElemDesc(8));
        m_elementFlags.put("OL", new ElemDesc(524296));
        m_elementFlags.put("UL", new ElemDesc(524296));
        m_elementFlags.put("LI", new ElemDesc(8));
        m_elementFlags.put("FORM", new ElemDesc(8));
        m_elementFlags.put("LABEL", new ElemDesc(16384));
        m_elementFlags.put("INPUT", new ElemDesc(18434));
        m_elementFlags.put("SELECT", new ElemDesc(18432));
        m_elementFlags.put("OPTGROUP", new ElemDesc(0));
        m_elementFlags.put("OPTION", new ElemDesc(0));
        m_elementFlags.put("TEXTAREA", new ElemDesc(18432));
        m_elementFlags.put("FIELDSET", new ElemDesc(24));
        m_elementFlags.put("LEGEND", new ElemDesc(0));
        m_elementFlags.put("BUTTON", new ElemDesc(18432));
        m_elementFlags.put("TABLE", new ElemDesc(56));
        m_elementFlags.put("CAPTION", new ElemDesc(8));
        m_elementFlags.put("THEAD", new ElemDesc(8));
        m_elementFlags.put("TFOOT", new ElemDesc(8));
        m_elementFlags.put("TBODY", new ElemDesc(8));
        m_elementFlags.put("COLGROUP", new ElemDesc(8));
        m_elementFlags.put("COL", new ElemDesc(10));
        m_elementFlags.put("TR", new ElemDesc(8));
        m_elementFlags.put("TH", new ElemDesc(0));
        m_elementFlags.put("TD", new ElemDesc(0));
        m_elementFlags.put("HEAD", new ElemDesc(0x400008));
        m_elementFlags.put("TITLE", new ElemDesc(8));
        m_elementFlags.put("BASE", new ElemDesc(10));
        m_elementFlags.put("META", new ElemDesc(131082));
        m_elementFlags.put("STYLE", new ElemDesc(131336));
        m_elementFlags.put("SCRIPT", new ElemDesc(229632));
        m_elementFlags.put("NOSCRIPT", new ElemDesc(56));
        m_elementFlags.put("HTML", new ElemDesc(8));
        m_elementFlags.put("FONT", new ElemDesc(4096));
        m_elementFlags.put("S", new ElemDesc(4096));
        m_elementFlags.put("STRIKE", new ElemDesc(4096));
        m_elementFlags.put("U", new ElemDesc(4096));
        m_elementFlags.put("NOBR", new ElemDesc(4096));
        m_elementFlags.put("IFRAME", new ElemDesc(56));
        m_elementFlags.put("LAYER", new ElemDesc(56));
        m_elementFlags.put("ILAYER", new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)m_elementFlags.get("AREA");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LINK");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SELECT");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc = (ElemDesc)m_elementFlags.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("FRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("IFRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("LAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("ILAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)m_elementFlags.get("DIV");
        elemDesc.setAttr("SRC", 2);
        m_dummy = new ElemDesc(8);
    }
}

