/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class NamespaceMappings {
    private int count = 0;
    private Stack m_prefixStack;
    private Hashtable m_namespaces;
    private Stack m_nodeStack;
    private static final String EMPTYSTRING = "";
    private static final String XML_PREFIX = "xml";

    public NamespaceMappings() {
        this.initNamespaces();
    }

    private void initNamespaces() {
        this.m_namespaces = new Hashtable();
        this.m_nodeStack = new Stack();
        this.m_prefixStack = new Stack();
        Stack<String> stack = new Stack<String>();
        this.m_namespaces.put(EMPTYSTRING, stack);
        stack.push(EMPTYSTRING);
        this.m_prefixStack.push(EMPTYSTRING);
        stack = new Stack();
        this.m_namespaces.put(XML_PREFIX, stack);
        stack.push("http://www.w3.org/XML/1998/namespace");
        this.m_prefixStack.push(XML_PREFIX);
        this.m_nodeStack.push(new Integer(-1));
    }

    public String lookupNamespace(String prefix) {
        Stack stack = (Stack)this.m_namespaces.get(prefix);
        return stack != null && !stack.isEmpty() ? (String)stack.peek() : null;
    }

    public String lookupPrefix(String uri) {
        String foundPrefix = null;
        Enumeration prefixes = this.m_namespaces.keys();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            String uri2 = this.lookupNamespace(prefix);
            if (uri2 == null || !uri2.equals(uri)) continue;
            foundPrefix = prefix;
            break;
        }
        return foundPrefix;
    }

    public boolean popNamespace(String prefix) {
        if (prefix.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack stack = (Stack)this.m_namespaces.get(prefix);
        if (stack != null) {
            stack.pop();
            return true;
        }
        return false;
    }

    public boolean pushNamespace(String prefix, String uri, int elemDepth) {
        if (prefix.startsWith(XML_PREFIX)) {
            return false;
        }
        Stack<String> stack = (Stack<String>)this.m_namespaces.get(prefix);
        if (stack == null) {
            stack = new Stack<String>();
            this.m_namespaces.put(prefix, stack);
        }
        if (!stack.empty() && uri.equals(stack.peek())) {
            return false;
        }
        stack.push(uri);
        this.m_prefixStack.push(prefix);
        this.m_nodeStack.push(new Integer(elemDepth));
        return true;
    }

    public void popNamespaces(int elemDepth) {
        while (!this.m_nodeStack.isEmpty()) {
            Integer i = (Integer)this.m_nodeStack.peek();
            if (i < elemDepth) {
                return;
            }
            this.m_nodeStack.pop();
            this.popNamespace((String)this.m_prefixStack.pop());
        }
        return;
    }

    public String generateNextPrefix() {
        return "ns" + this.count++;
    }

    public Object clone() throws CloneNotSupportedException {
        NamespaceMappings clone = new NamespaceMappings();
        clone.m_prefixStack = (Stack)this.m_prefixStack.clone();
        clone.m_nodeStack = (Stack)this.m_nodeStack.clone();
        clone.m_namespaces = (Hashtable)this.m_namespaces.clone();
        clone.count = this.count;
        return clone;
    }
}

