/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.xalan.xsltc.compiler.ApplyTemplates;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Closure;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.ForEach;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.VariableRef;
import org.apache.xalan.xsltc.compiler.VariableRefBase;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.CompareGenerator;
import org.apache.xalan.xsltc.compiler.util.IntType;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSortRecordFactGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSortRecordGenerator;
import org.apache.xalan.xsltc.compiler.util.StringType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Sort
extends Instruction
implements Closure {
    private Expression _select;
    private AttributeValue _order;
    private AttributeValue _caseOrder;
    private AttributeValue _dataType;
    private String _data = null;
    public String _lang;
    public String _country;
    private String _className = null;
    private ArrayList _closureVars = null;
    private boolean _needsSortRecordFactory = false;

    Sort() {
    }

    public boolean inInnerClass() {
        return this._className != null;
    }

    public Closure getParentClosure() {
        return null;
    }

    public String getInnerClassName() {
        return this._className;
    }

    public void addVariable(VariableRefBase variableRef) {
        if (this._closureVars == null) {
            this._closureVars = new ArrayList();
        }
        if (!this._closureVars.contains(variableRef)) {
            this._closureVars.add(variableRef);
            this._needsSortRecordFactory = true;
        }
    }

    private void setInnerClassName(String className) {
        this._className = className;
    }

    public void parseContents(Parser parser2) {
        block8: {
            SyntaxTreeNode parent = this.getParent();
            if (!(parent instanceof ApplyTemplates) && !(parent instanceof ForEach)) {
                this.reportError(this, parser2, "STRAY_SORT_ERR", null);
                return;
            }
            this._select = parser2.parseExpression(this, "select", "string(.)");
            String val = this.getAttribute("order");
            if (val.length() == 0) {
                val = "ascending";
            }
            this._order = AttributeValue.create(this, val, parser2);
            val = this.getAttribute("case-order");
            if (val.length() == 0) {
                val = "upper-first";
            }
            this._caseOrder = AttributeValue.create(this, val, parser2);
            val = this.getAttribute("data-type");
            if (val.length() == 0) {
                try {
                    Type type = this._select.typeCheck(parser2.getSymbolTable());
                    val = type instanceof IntType ? "number" : "text";
                }
                catch (TypeCheckError e) {
                    val = "text";
                }
            }
            this._dataType = AttributeValue.create(this, val, parser2);
            val = this.getAttribute("lang");
            if (val == null) break block8;
            try {
                StringTokenizer st = new StringTokenizer(val, "-", false);
                this._lang = st.nextToken();
                this._country = st.nextToken();
            }
            catch (NoSuchElementException e) {}
        }
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Type tselect = this._select.typeCheck(stable);
        if (!(tselect instanceof StringType)) {
            this._select = new CastExpr(this._select, Type.String);
        }
        this._order.typeCheck(stable);
        this._caseOrder.typeCheck(stable);
        this._dataType.typeCheck(stable);
        return Type.Void;
    }

    public void translateSortType(ClassGenerator classGen, MethodGenerator methodGen) {
        this._dataType.translate(classGen, methodGen);
    }

    public void translateSortOrder(ClassGenerator classGen, MethodGenerator methodGen) {
        this._order.translate(classGen, methodGen);
    }

    public void translateSelect(ClassGenerator classGen, MethodGenerator methodGen) {
        this._select.translate(classGen, methodGen);
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
    }

    public static void translateSortIterator(ClassGenerator classGen, MethodGenerator methodGen, Expression nodeSet, Vector sortObjects) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        int init = cpg.addMethodref("org.apache.xalan.xsltc.dom.SortingIterator", "<init>", "(Lorg/apache/xml/dtm/DTMAxisIterator;Lorg/apache/xalan/xsltc/dom/NodeSortRecordFactory;)V");
        il.append(new NEW(cpg.addClass("org.apache.xalan.xsltc.dom.SortingIterator")));
        il.append(InstructionConstants.DUP);
        if (nodeSet == null) {
            int children = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getAxisIterator", "(I)Lorg/apache/xml/dtm/DTMAxisIterator;");
            il.append(methodGen.loadDOM());
            il.append(new PUSH(cpg, 3));
            il.append(new INVOKEINTERFACE(children, 2));
        } else {
            nodeSet.translate(classGen, methodGen);
        }
        Sort.compileSortRecordFactory(sortObjects, classGen, methodGen);
        il.append(new INVOKESPECIAL(init));
    }

    public static void compileSortRecordFactory(Vector sortObjects, ClassGenerator classGen, MethodGenerator methodGen) {
        String sortRecordClass = Sort.compileSortRecord(sortObjects, classGen, methodGen);
        boolean needsSortRecordFactory = false;
        int nsorts = sortObjects.size();
        int i = 0;
        while (i < nsorts) {
            Sort sort = (Sort)sortObjects.elementAt(i);
            needsSortRecordFactory |= sort._needsSortRecordFactory;
            ++i;
        }
        String sortRecordFactoryClass = "org/apache/xalan/xsltc/dom/NodeSortRecordFactory";
        if (needsSortRecordFactory) {
            sortRecordFactoryClass = Sort.compileSortRecordFactory(sortObjects, classGen, methodGen, sortRecordClass);
        }
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        il.append(new NEW(cpg.addClass(sortRecordFactoryClass)));
        il.append(InstructionConstants.DUP);
        il.append(methodGen.loadDOM());
        il.append(new PUSH(cpg, sortRecordClass));
        il.append(classGen.loadTranslet());
        il.append(new PUSH(cpg, nsorts));
        il.append(new ANEWARRAY(cpg.addClass("java.lang.String")));
        int level = 0;
        while (level < nsorts) {
            Sort sort = (Sort)sortObjects.elementAt(level);
            il.append(InstructionConstants.DUP);
            il.append(new PUSH(cpg, level));
            sort.translateSortOrder(classGen, methodGen);
            il.append(InstructionConstants.AASTORE);
            ++level;
        }
        il.append(new PUSH(cpg, nsorts));
        il.append(new ANEWARRAY(cpg.addClass("java.lang.String")));
        int level2 = 0;
        while (level2 < nsorts) {
            Sort sort = (Sort)sortObjects.elementAt(level2);
            il.append(InstructionConstants.DUP);
            il.append(new PUSH(cpg, level2));
            sort.translateSortType(classGen, methodGen);
            il.append(InstructionConstants.AASTORE);
            ++level2;
        }
        il.append(new INVOKESPECIAL(cpg.addMethodref(sortRecordFactoryClass, "<init>", "(Lorg/apache/xalan/xsltc/DOM;Ljava/lang/String;Lorg/apache/xalan/xsltc/Translet;[Ljava/lang/String;[Ljava/lang/String;)V")));
        ArrayList<VariableRefBase> dups = new ArrayList<VariableRefBase>();
        int j = 0;
        while (j < nsorts) {
            Sort sort = (Sort)sortObjects.get(j);
            int length = sort._closureVars == null ? 0 : sort._closureVars.size();
            int i2 = 0;
            while (i2 < length) {
                VariableRefBase varRef = (VariableRefBase)sort._closureVars.get(i2);
                if (!dups.contains(varRef)) {
                    VariableBase var = varRef.getVariable();
                    il.append(InstructionConstants.DUP);
                    il.append(var.loadInstruction());
                    il.append(new PUTFIELD(cpg.addFieldref(sortRecordFactoryClass, var.getVariable(), var.getType().toSignature())));
                    dups.add(varRef);
                }
                ++i2;
            }
            ++j;
        }
    }

    public static String compileSortRecordFactory(Vector sortObjects, ClassGenerator classGen, MethodGenerator methodGen, String sortRecordClass) {
        XSLTC xsltc = ((Sort)sortObjects.firstElement()).getXSLTC();
        String className = xsltc.getHelperClassName();
        NodeSortRecordFactGenerator sortRecordFactory = new NodeSortRecordFactGenerator(className, "org/apache/xalan/xsltc/dom/NodeSortRecordFactory", className + ".java", 49, new String[0], classGen.getStylesheet());
        ConstantPoolGen cpg = sortRecordFactory.getConstantPool();
        int nsorts = sortObjects.size();
        ArrayList<VariableRef> dups = new ArrayList<VariableRef>();
        int j = 0;
        while (j < nsorts) {
            Sort sort = (Sort)sortObjects.get(j);
            int length = sort._closureVars == null ? 0 : sort._closureVars.size();
            int i = 0;
            while (i < length) {
                VariableRef varRef = (VariableRef)sort._closureVars.get(i);
                if (!dups.contains(varRef)) {
                    VariableBase var = varRef.getVariable();
                    sortRecordFactory.addField(new Field(1, cpg.addUtf8(var.getVariable()), cpg.addUtf8(var.getType().toSignature()), null, cpg.getConstantPool()));
                    dups.add(varRef);
                }
                ++i;
            }
            ++j;
        }
        org.apache.bcel.generic.Type[] argTypes = new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Ljava/lang/String;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/Translet;"), Util.getJCRefType("[Ljava/lang/String;"), Util.getJCRefType("[Ljava/lang/String;")};
        String[] argNames = new String[]{"document", "className", "translet", "order", "type"};
        InstructionList il = new InstructionList();
        MethodGenerator constructor = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, argTypes, argNames, "<init>", className, il, cpg);
        il.append(InstructionConstants.ALOAD_0);
        il.append(InstructionConstants.ALOAD_1);
        il.append(InstructionConstants.ALOAD_2);
        il.append(new ALOAD(3));
        il.append(new ALOAD(4));
        il.append(new ALOAD(5));
        il.append(new INVOKESPECIAL(cpg.addMethodref("org/apache/xalan/xsltc/dom/NodeSortRecordFactory", "<init>", "(Lorg/apache/xalan/xsltc/DOM;Ljava/lang/String;Lorg/apache/xalan/xsltc/Translet;[Ljava/lang/String;[Ljava/lang/String;)V")));
        il.append(InstructionConstants.RETURN);
        il = new InstructionList();
        MethodGenerator makeNodeSortRecord = new MethodGenerator(1, Util.getJCRefType("Lorg/apache/xalan/xsltc/dom/NodeSortRecord;"), new org.apache.bcel.generic.Type[]{org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT}, new String[]{"node", "last"}, "makeNodeSortRecord", className, il, cpg);
        il.append(InstructionConstants.ALOAD_0);
        il.append(InstructionConstants.ILOAD_1);
        il.append(InstructionConstants.ILOAD_2);
        il.append(new INVOKESPECIAL(cpg.addMethodref("org/apache/xalan/xsltc/dom/NodeSortRecordFactory", "makeNodeSortRecord", "(II)Lorg/apache/xalan/xsltc/dom/NodeSortRecord;")));
        il.append(InstructionConstants.DUP);
        il.append(new CHECKCAST(cpg.addClass(sortRecordClass)));
        int ndups = dups.size();
        int i = 0;
        while (i < ndups) {
            VariableRef varRef = (VariableRef)dups.get(i);
            VariableBase var = varRef.getVariable();
            Type varType = var.getType();
            il.append(InstructionConstants.DUP);
            il.append(InstructionConstants.ALOAD_0);
            il.append(new GETFIELD(cpg.addFieldref(className, var.getVariable(), varType.toSignature())));
            il.append(new PUTFIELD(cpg.addFieldref(sortRecordClass, var.getVariable(), varType.toSignature())));
            ++i;
        }
        il.append(InstructionConstants.POP);
        il.append(InstructionConstants.ARETURN);
        constructor.setMaxLocals();
        constructor.setMaxStack();
        sortRecordFactory.addMethod(constructor.getMethod());
        makeNodeSortRecord.setMaxLocals();
        makeNodeSortRecord.setMaxStack();
        sortRecordFactory.addMethod(makeNodeSortRecord.getMethod());
        xsltc.dumpClass(sortRecordFactory.getJavaClass());
        return className;
    }

    private static String compileSortRecord(Vector sortObjects, ClassGenerator classGen, MethodGenerator methodGen) {
        XSLTC xsltc = ((Sort)sortObjects.firstElement()).getXSLTC();
        String className = xsltc.getHelperClassName();
        NodeSortRecordGenerator sortRecord = new NodeSortRecordGenerator(className, "org.apache.xalan.xsltc.dom.NodeSortRecord", "sort$0.java", 49, new String[0], classGen.getStylesheet());
        ConstantPoolGen cpg = sortRecord.getConstantPool();
        int nsorts = sortObjects.size();
        ArrayList<VariableRef> dups = new ArrayList<VariableRef>();
        int j = 0;
        while (j < nsorts) {
            Sort sort = (Sort)sortObjects.get(j);
            sort.setInnerClassName(className);
            int length = sort._closureVars == null ? 0 : sort._closureVars.size();
            int i = 0;
            while (i < length) {
                VariableRef varRef = (VariableRef)sort._closureVars.get(i);
                if (!dups.contains(varRef)) {
                    VariableBase var = varRef.getVariable();
                    sortRecord.addField(new Field(1, cpg.addUtf8(var.getVariable()), cpg.addUtf8(var.getType().toSignature()), null, cpg.getConstantPool()));
                    dups.add(varRef);
                }
                ++i;
            }
            ++j;
        }
        Method init = Sort.compileInit(sortObjects, sortRecord, cpg, className);
        Method extract = Sort.compileExtract(sortObjects, sortRecord, cpg, className);
        sortRecord.addMethod(init);
        sortRecord.addMethod(extract);
        xsltc.dumpClass(sortRecord.getJavaClass());
        return className;
    }

    private static Method compileInit(Vector sortObjects, NodeSortRecordGenerator sortRecord, ConstantPoolGen cpg, String className) {
        InstructionList il = new InstructionList();
        MethodGenerator init = new MethodGenerator(1, org.apache.bcel.generic.Type.VOID, null, null, "<init>", className, il, cpg);
        il.append(InstructionConstants.ALOAD_0);
        il.append(new INVOKESPECIAL(cpg.addMethodref("org.apache.xalan.xsltc.dom.NodeSortRecord", "<init>", "()V")));
        int initLocale = cpg.addMethodref("java/util/Locale", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        int getCollator = cpg.addMethodref("java/text/Collator", "getInstance", "(Ljava/util/Locale;)Ljava/text/Collator;");
        int setStrength = cpg.addMethodref("java/text/Collator", "setStrength", "(I)V");
        int levels = sortObjects.size();
        String language = null;
        String country = null;
        Sort sort = (Sort)sortObjects.elementAt(0);
        int level = 0;
        while (level < levels) {
            if (language == null && sort._lang != null) {
                language = sort._lang;
            }
            if (country == null && sort._country != null) {
                country = sort._country;
            }
            ++level;
        }
        int collator = cpg.addFieldref(className, "_collator", "Ljava/text/Collator;");
        int locale = cpg.addFieldref(className, "_locale", "Ljava/util/Locale;");
        if (language != null) {
            il.append(new NEW(cpg.addClass("java/util/Locale")));
            il.append(InstructionConstants.DUP);
            il.append(InstructionConstants.DUP);
            il.append(new PUSH(cpg, language));
            il.append(new PUSH(cpg, country != null ? country : ""));
            il.append(new INVOKESPECIAL(initLocale));
            il.append(InstructionConstants.ALOAD_0);
            il.append(InstructionConstants.SWAP);
            il.append(new PUTFIELD(locale));
            il.append(new INVOKESTATIC(getCollator));
            il.append(InstructionConstants.ALOAD_0);
            il.append(InstructionConstants.SWAP);
            il.append(new PUTFIELD(collator));
        }
        il.append(InstructionConstants.ALOAD_0);
        il.append(new GETFIELD(collator));
        il.append(new ICONST(2));
        il.append(new INVOKEVIRTUAL(setStrength));
        il.append(InstructionConstants.RETURN);
        init.stripAttributes(true);
        init.setMaxLocals();
        init.setMaxStack();
        return init.getMethod();
    }

    private static Method compileExtract(Vector sortObjects, NodeSortRecordGenerator sortRecord, ConstantPoolGen cpg, String className) {
        InstructionList il = new InstructionList();
        CompareGenerator extractMethod = new CompareGenerator(17, org.apache.bcel.generic.Type.STRING, new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT, Util.getJCRefType("Lorg/apache/xalan/xsltc/runtime/AbstractTranslet;"), org.apache.bcel.generic.Type.INT}, new String[]{"dom", "current", "level", "translet", "last"}, "extractValueFromDOM", className, il, cpg);
        int levels = sortObjects.size();
        int[] match = new int[levels];
        InstructionHandle[] target = new InstructionHandle[levels];
        InstructionHandle tblswitch = null;
        if (levels > 1) {
            il.append(new ILOAD(extractMethod.getLocalIndex("level")));
            tblswitch = il.append(new NOP());
        }
        int level = 0;
        while (level < levels) {
            match[level] = level;
            Sort sort = (Sort)sortObjects.elementAt(level);
            target[level] = il.append(InstructionConstants.NOP);
            sort.translateSelect(sortRecord, extractMethod);
            il.append(InstructionConstants.ARETURN);
            ++level;
        }
        if (levels > 1) {
            InstructionHandle defaultTarget = il.append(new PUSH(cpg, ""));
            il.insert(tblswitch, new TABLESWITCH(match, target, defaultTarget));
            il.append(InstructionConstants.ARETURN);
        }
        extractMethod.stripAttributes(true);
        extractMethod.setMaxLocals();
        extractMethod.setMaxStack();
        extractMethod.removeNOPs();
        return extractMethod.getMethod();
    }
}

