/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.SAXException;

public class ElemValueOf
extends ElemTemplateElement {
    private XPath m_selectExpression = null;
    private boolean m_isDot = false;
    private boolean m_disableOutputEscaping = false;

    public void setSelect(XPath v) {
        if (null != v) {
            String s = v.getPatternString();
            this.m_isDot = null != s && s.equals(".");
        }
        this.m_selectExpression = v;
    }

    public XPath getSelect() {
        return this.m_selectExpression;
    }

    public void setDisableOutputEscaping(boolean v) {
        this.m_disableOutputEscaping = v;
    }

    public boolean getDisableOutputEscaping() {
        return this.m_disableOutputEscaping;
    }

    public int getXSLToken() {
        return 30;
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        Vector vnames = sroot.getComposeState().getVariableNames();
        if (null != this.m_selectExpression) {
            this.m_selectExpression.fixupVariables(vnames, sroot.getComposeState().getGlobalsSize());
        }
    }

    public String getNodeName() {
        return "value-of";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(TransformerImpl transformer) throws TransformerException {
        XPathContext xctxt = transformer.getXPathContext();
        SerializationHandler rth = transformer.getResultTreeHandler();
        if (TransformerImpl.S_DEBUG) {
            transformer.getTraceManager().fireTraceEvent(this);
        }
        try {
            try {
                xctxt.pushNamespaceContext(this);
                int current = xctxt.getCurrentNode();
                xctxt.pushCurrentNodeAndExpression(current, current);
                if (this.m_disableOutputEscaping) {
                    rth.processingInstruction("javax.xml.transform.disable-output-escaping", "");
                }
                try {
                    Expression expr = this.m_selectExpression.getExpression();
                    if (TransformerImpl.S_DEBUG) {
                        XObject obj = expr.execute(xctxt);
                        transformer.getTraceManager().fireSelectedEvent(current, this, "select", this.m_selectExpression, obj);
                        obj.dispatchCharactersEvents(rth);
                    } else {
                        expr.executeCharsToContentHandler(xctxt, rth);
                    }
                }
                finally {
                    if (this.m_disableOutputEscaping) {
                        rth.processingInstruction("javax.xml.transform.enable-output-escaping", "");
                    }
                    xctxt.popNamespaceContext();
                    xctxt.popCurrentNodeAndExpression();
                }
                Object var9_11 = null;
                if (!TransformerImpl.S_DEBUG) return;
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            catch (RuntimeException re) {
                TransformerException te = new TransformerException(re);
                te.setLocator(this);
                throw te;
            }
            transformer.getTraceManager().fireTraceEndEvent(this);
            return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TransformerImpl.S_DEBUG) throw throwable;
            transformer.getTraceManager().fireTraceEndEvent(this);
            throw throwable;
        }
    }

    public ElemTemplateElement appendChild(ElemTemplateElement newChild) {
        this.error("ER_CANNOT_ADD", new Object[]{newChild.getNodeName(), this.getNodeName()});
        return null;
    }

    protected void callChildVisitors(XSLTVisitor visitor, boolean callAttrs) {
        if (callAttrs) {
            this.m_selectExpression.getExpression().callVisitors(this.m_selectExpression, visitor);
        }
        super.callChildVisitors(visitor, callAttrs);
    }
}

