/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.admin.security;

import com.systinet.wasp.dd.DescriptorConverter;
import org.systinet.wasp.admin.Package;
import org.systinet.wasp.dd.ServiceEndpoint;
import org.systinet.wasp.dd.ServiceInstance;

public class PermissionHelper {
    protected static String encode(String context, String targetNS, String name) {
        return DescriptorConverter.encodeName((String)context, (String)targetNS, (String)name);
    }

    protected static Holder decode(String id) {
        DescriptorConverter.NameHolder holder = new DescriptorConverter.NameHolder();
        DescriptorConverter.decodeName((String)id, (DescriptorConverter.NameHolder)holder);
        Holder result = new Holder(holder.context, holder.targetNamespace, holder.name);
        return result;
    }

    public static String getPackageId(Package pckg) {
        return PermissionHelper.getPackageId(pckg.context, pckg.targetNamespace, pckg.name);
    }

    public static String getPackageId(String context, String targetNS, String name) {
        return PermissionHelper.encode(context, targetNS, name);
    }

    public static String getServiceInstanceId(String context, ServiceInstance serviceInstance) {
        return PermissionHelper.getServiceInstanceId(context, serviceInstance.getName().getNamespaceURI(), serviceInstance.getName().getLocalPart());
    }

    public static String getServiceInstanceId(String context, String targetNS, String name) {
        return PermissionHelper.encode(context, targetNS, name);
    }

    public static String getServiceEndpointId(String context, ServiceEndpoint serviceEndpoint) {
        return PermissionHelper.getServiceEndpointId(context, serviceEndpoint.getPath());
    }

    public static String getServiceEndpointId(String context, String endpointPath) {
        return DescriptorConverter.ddEndpointToConfigEndpoint((String)context, (String)endpointPath);
    }

    public static String getMethodId(String wsdlTargetNamespace, String operationName) {
        return operationName;
    }

    public static Holder decodePackageId(String packageId) {
        return PermissionHelper.decode(packageId);
    }

    public static Holder decodeServiceInstanceId(String serviceInstanceId) {
        return PermissionHelper.decode(serviceInstanceId);
    }

    public static String decodeServiceEndpointId(String context, String serviceEndpointId) {
        return serviceEndpointId.substring(context.length());
    }

    public static Holder decodeMethodId(String methodId) {
        return PermissionHelper.decode(methodId);
    }

    public static class Holder {
        public String context;
        public String targetNS;
        public String name;

        public Holder(String context, String targetNS, String name) {
            this.context = context;
            this.targetNS = targetNS;
            this.name = name;
        }
    }
}

