/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.core;

import com.idoox.debug.Category;
import com.idoox.wasp.Constants;
import com.idoox.wasp.server.ServiceConnector;
import com.systinet.wasp.ServiceManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.idoox.transport.Connection;
import org.idoox.transport.OutputMessage;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.systinet.wasp.webservice.RawService;

public class DebugFileServiceImpl
implements RawService {
    protected static Category cat = Category.getCategory((String)"com.systinet.wasp.core.DebugFileServiceImpl");
    private static String PATH_SUFFIX = "/debug";
    private static final byte[] closeLine;

    /*
     * WARNING - void declaration
     */
    public void process(Connection connection) {
        String path = connection.getURI().getPath();
        if (path.endsWith(PATH_SUFFIX)) {
            path = path.substring(0, path.length() - PATH_SUFFIX.length());
        }
        OutputMessage out = connection.getOutputMessage();
        try {
            int length;
            FileInputStream debugFile;
            ServiceManagerImpl serviceManager = (ServiceManagerImpl)Context.getInstance((String)"org.systinet.wasp.webservice.IRegistry");
            ServiceConnector connector = serviceManager.getConnector(path);
            if (connector == null) {
                out.setStatusCode(404);
                return;
            }
            if (connector.getService().getState() == 1) {
                out.setStatusCode(503);
                return;
            }
            String filePath = connector.getRootPath() + File.separator + "debug.txt";
            try {
                URL url = new URL(filePath);
                filePath = url.getFile();
            }
            catch (MalformedURLException e) {
                out.setStatusCode(404);
                return;
            }
            try {
                debugFile = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                out.setStatusCode(404);
                return;
            }
            out.setStatusCode(200);
            out.setContentType("text/html");
            out.write("<html>\r\n<head>\r\n<style>\r\n  body { font-family: monospace; font-size: 13px; }\r\n  .first { background-color: lightblue; }\r\n  .second { background-color: lightyellow; }\r\n</style>\r\n</head>\r\n<body>\r\n".getBytes(Constants.UTF_8));
            byte[] buffer = new byte[2048];
            int state = 0;
            int closeLineNum = 0;
            while ((length = debugFile.read(buffer, 0, buffer.length)) >= 0) {
                void var9_14;
                int i = 0;
                while (i < var9_14) {
                    if (closeLineNum >= closeLine.length) {
                        out.write("\r\n</div>\r\n".getBytes(Constants.UTF_8));
                        closeLineNum = 0;
                        if (++state >= 4) {
                            state = 0;
                        }
                    } else {
                        closeLineNum = buffer[i] == closeLine[closeLineNum] ? ++closeLineNum : 0;
                    }
                    if (buffer[i] != 13) {
                        if (buffer[i] == 10) {
                            out.write("<br>\r\n".getBytes(Constants.UTF_8));
                        } else {
                            if (state == 0) {
                                out.write("<div class=\"first\">\r\n".getBytes(Constants.UTF_8));
                                ++state;
                            } else if (state == 2) {
                                out.write("<div class=\"second\">\r\n".getBytes(Constants.UTF_8));
                                ++state;
                            }
                            if (buffer[i] == 9) {
                                out.write("&nbsp;&nbsp;&nbsp;&nbsp;".getBytes(Constants.UTF_8));
                            } else if (buffer[i] < 32 && buffer[i] != 9 && buffer[i] != 10 && buffer[i] != 13 || buffer[i] == 60 || buffer[i] == 62 || buffer[i] == 38) {
                                out.write("&#".getBytes(Constants.UTF_8));
                                int n = buffer[i] & 0xFF;
                                out.write(Integer.toString(n).getBytes(Constants.UTF_8));
                                out.write(59);
                            } else {
                                out.write(buffer[i]);
                            }
                        }
                    }
                    ++i;
                }
            }
            debugFile.close();
            out.write("\r\n</body></html>".getBytes(Constants.UTF_8));
        }
        catch (IOException e) {
            out.setStatusCode(503);
        }
    }

    static {
        try {
            closeLine = "==== CLOSE =====================================================================".getBytes(Constants.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }
}

