/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.bc;

import com.idoox.debug.Category;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.ClassSpaceNotFoundException;
import com.systinet.wasp.bc.Converted;
import com.systinet.wasp.bc.Convertor;
import com.systinet.wasp.bc.SysServicesConfig;
import com.systinet.wasp.webservice.RegistryImpl;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.Credentials;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspSecurity;
import org.idoox.webservice.client.WebServiceLookupException;
import org.systinet.wasp.admin.PackageInfo;
import org.systinet.wasp.admin.PackageRepository;
import org.systinet.wasp.admin.PingService;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.ServiceClient;

public class SysServices {
    private Category log = Category.getCategory((String)"com.systinet.wasp.bc.SysServices");
    public static final String PING = "Ping";
    public static final String DEPLOY = "Deploy";
    public static final String SECURITY_INFO = "Security Info";
    public static final String POLICY = "Policy Management";
    public static final String PSTORE = "PStore";
    public static final String ADMINISTRATION = "Administration";
    public static final String WSDL2JAVA = "WSDL2Java";
    public static final String WSDISCOVERY = "WsDiscovery";
    public static final String WSDISCOVERY_MGMT_API = "WsDiscoveryMgmtApi";
    public static final String WASP_46 = "4.6";
    public static final String WASP_45 = "4.5";
    public static final String WASP_40 = "4.0";
    public static final String WASP_31 = "3.1";
    public static final String WASP_30 = "3.0";
    public static String WASP_FORWARD = "+";
    private static final String[] waspVersions = new String[]{"4.6", "4.5", "4.0", "3.1", "3.0", WASP_FORWARD};
    public static final String WASP_LATEST = "4.6";
    private static final String systemContext = "system";
    private static final String PING_SERVICE_URL = "/PingService/";
    private static SysServices instance = null;
    private Map convertors = new HashMap();
    private Map url2Version = new HashMap();
    private boolean initialized = false;
    private static final String CONFIG_ELEMENT_TYPE = "sysServicesConvertors";
    private static final String CONFIG_ELEMENT_NAME = "main";
    static /* synthetic */ Class class$org$systinet$wasp$admin$PackageRepository;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$IRegistry;
    static /* synthetic */ Class class$com$systinet$wasp$bc$SysServicesConfig;
    static /* synthetic */ Class class$org$systinet$wasp$admin$PingService;

    private void load(SysServicesConfig sysServicesConfig) {
        instance = this;
        SysServicesConfig.Convertor[] convertors = sysServicesConfig.getConvertors();
        int i = 0;
        while (i < convertors.length) {
            SysServicesConfig.Convertor convertor = convertors[i];
            this.loadConvertor(convertor);
            ++i;
        }
    }

    private void loadConvertor(SysServicesConfig.Convertor convertorConfig) {
        String className = convertorConfig.getClassName();
        String packageName = convertorConfig.getPackageName();
        Class convertorClass = null;
        try {
            convertorClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            convertorClass = null;
        }
        if (convertorClass == null) {
            convertorClass = this.loadClassFromPackage(packageName, className);
        }
        if (convertorClass == null) {
            this.log.debug("Cannot load the backward compatibility convertor from the package " + packageName + ", " + convertorClass);
            return;
        }
        Convertor convertor = null;
        try {
            convertor = (Convertor)convertorClass.newInstance();
        }
        catch (Exception e) {
            this.log.error("Unable to load class : " + className);
        }
        Convertor.SysServiceItem[] sysServiceItems = convertor.getMaintainedServiceItems();
        if (sysServiceItems == null || sysServiceItems.length == 0) {
            return;
        }
        int i = 0;
        while (i < sysServiceItems.length) {
            Convertor.SysServiceItem sysServiceItem = sysServiceItems[i];
            String serviceName = sysServiceItem.getServiceName();
            String sourceVersion = sysServiceItem.getSourceVersion();
            if (!this.checkWaspVersion(sourceVersion)) {
                this.log.error("Unknown source version : " + sourceVersion);
            } else {
                String targetVersion = sysServiceItem.getTargetVersion();
                if (!this.checkWaspVersion(targetVersion)) {
                    this.log.error("Unknown target version : " + targetVersion);
                } else {
                    Vector<Convertor> registeredConvertors = (Vector<Convertor>)this.convertors.get(serviceName);
                    if (registeredConvertors == null) {
                        registeredConvertors = new Vector<Convertor>();
                        this.convertors.put(serviceName, registeredConvertors);
                    }
                    registeredConvertors.add(convertor);
                }
            }
            ++i;
        }
    }

    private boolean checkWaspVersion(String targetVersion) {
        int i = 0;
        while (i < waspVersions.length) {
            if (targetVersion.equals(waspVersions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    PackageRepository getPackageRepository() {
        return (PackageRepository)Context.getInstance((Class)(class$org$systinet$wasp$admin$PackageRepository == null ? (class$org$systinet$wasp$admin$PackageRepository = SysServices.class$("org.systinet.wasp.admin.PackageRepository")) : class$org$systinet$wasp$admin$PackageRepository));
    }

    private static RegistryImpl getRegistryImpl() {
        return (RegistryImpl)Context.getInstance((Class)(class$org$systinet$wasp$webservice$IRegistry == null ? (class$org$systinet$wasp$webservice$IRegistry = SysServices.class$("org.systinet.wasp.webservice.IRegistry")) : class$org$systinet$wasp$webservice$IRegistry));
    }

    protected Class loadClassFromPackage(String packageName, String className) {
        QName qName;
        PackageRepository packageRepository = this.getPackageRepository();
        PackageInfo pi = packageRepository.findPackage((qName = QName.valueOf(packageName)).getNamespaceURI(), qName.getLocalPart(), systemContext);
        if (pi == null) {
            return null;
        }
        ClassSpace cs = null;
        try {
            cs = ClassSpaceHelper.getClassSpace((String)pi.classLoader);
        }
        catch (ClassSpaceNotFoundException e) {
            cs = null;
        }
        if (cs == null) {
            return null;
        }
        ClassLoader cl = cs.getClassLoader();
        if (cl == null) {
            return null;
        }
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private synchronized void init() {
        if (!this.initialized) {
            Configurator cfg = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
            Configurable configurable = Configurator.getConfigurable((String)CONFIG_ELEMENT_TYPE, (String)CONFIG_ELEMENT_NAME);
            if (configurable == null) {
                return;
            }
            SysServicesConfig sysServicesConfig = (SysServicesConfig)configurable.narrow(class$com$systinet$wasp$bc$SysServicesConfig == null ? (class$com$systinet$wasp$bc$SysServicesConfig = SysServices.class$("com.systinet.wasp.bc.SysServicesConfig")) : class$com$systinet$wasp$bc$SysServicesConfig);
            if (sysServicesConfig == null) {
                return;
            }
            this.load(sysServicesConfig);
            this.initialized = true;
        }
    }

    public static String[] getAnRequirementsForEndpoint(String serverURL, String serviceId) throws WebServiceLookupException {
        serverURL = SysServices.checkServerUrl(serverURL);
        return SysServices.getInstance().getAnRequirementsForEndpointServiceSPI(serverURL, serviceId);
    }

    private static String checkServerUrl(String serverUrl) {
        if (serverUrl == null || serverUrl.length() < 1) {
            throw new IllegalArgumentException("Invalid server URL");
        }
        if (serverUrl.charAt(serverUrl.length() - 1) == '/') {
            return serverUrl.substring(0, serverUrl.length() - 1);
        }
        return serverUrl;
    }

    private String[] getAnRequirementsForEndpointServiceSPI(String serverURL, String serviceId) throws WebServiceLookupException {
        this.init();
        Vector serviceConvertors = (Vector)this.convertors.get(serviceId);
        if (serviceConvertors == null) {
            throw new IllegalArgumentException("No convertor provided for the service : " + serviceId);
        }
        String sourceVersion = null;
        try {
            sourceVersion = this.getSourceServerVersion(serverURL);
        }
        catch (LookupException e) {
            throw new WebServiceLookupException((Throwable)e);
        }
        Convertor theConvertor = this.getConvertor(serviceConvertors, sourceVersion, null, serviceId);
        if (theConvertor == null) {
            throw new WebServiceLookupException("Unable to get convertor for the conversion of the " + serviceId + " service to Wasp version " + sourceVersion);
        }
        Convertor.SysServiceItem[] sysServiceItems = theConvertor.getMaintainedServiceItems();
        String serviceEndpointPath = null;
        int i = 0;
        while (i < sysServiceItems.length) {
            Convertor.SysServiceItem sysServiceItem = sysServiceItems[i];
            String serviceName = sysServiceItem.getServiceName();
            String convertorSourceVersion = sysServiceItem.getSourceVersion();
            if (serviceName != null && serviceName.equals(serviceId) && convertorSourceVersion != null && convertorSourceVersion.equals(sourceVersion)) {
                serviceEndpointPath = sysServiceItem.getServiceEndpoint();
            }
            ++i;
        }
        return WaspSecurity.getAnRequirementsForEndpoint((String)serverURL, serviceEndpointPath, (boolean)false);
    }

    public static ServiceClient getServiceClient(Object proxy) {
        if (proxy == null) {
            return null;
        }
        if (proxy instanceof Converted) {
            return ((Converted)proxy).getServiceClient();
        }
        return SysServices.getRegistryImpl().getServiceClient(proxy);
    }

    public static void setCredentials(Object proxy, Credentials[] credentials) {
        if (proxy == null) {
            WaspSecurity.setCredentials((ServiceClient)null, (Credentials[])credentials);
        } else if (proxy instanceof Converted) {
            ((Converted)proxy).setCredentials(credentials);
        } else {
            WaspSecurity.setCredentials((ServiceClient)SysServices.getRegistryImpl().getServiceClient(proxy), (Credentials[])credentials);
        }
    }

    public static void setInitiatingProvider(Object proxy, String providerName) throws NoSuchProviderException {
        if (proxy instanceof Converted) {
            ((Converted)proxy).setInitiatingProvider(providerName);
        } else {
            WaspSecurity.setInitiatingProvider((ServiceClient)SysServices.getRegistryImpl().getServiceClient(proxy), (String)providerName);
        }
    }

    public static Object lookup(String serverURL, String serviceId, String requiredVersion) throws IllegalArgumentException, LookupException {
        serverURL = SysServices.checkServerUrl(serverURL);
        return SysServices.getInstance().lookupService(serverURL, serviceId, requiredVersion, null);
    }

    public static Object lookup(String serverURL, String serviceId, String requiredVersion, Map lookupParams) throws IllegalArgumentException, LookupException {
        serverURL = SysServices.checkServerUrl(serverURL);
        return SysServices.getInstance().lookupService(serverURL, serviceId, requiredVersion, lookupParams);
    }

    public static Object lookup(String serverURL, String serviceId, Class iface, String requiredVersion, Map lookupParams) throws IllegalArgumentException, LookupException {
        serverURL = SysServices.checkServerUrl(serverURL);
        if (serviceId == null || serviceId.length() == 0) {
            throw new IllegalArgumentException("Invalid service id or service endpoint path: " + serviceId);
        }
        if (!serviceId.startsWith("/")) {
            return SysServices.getInstance().lookupService(serverURL, serviceId, requiredVersion, lookupParams);
        }
        ServiceClient sc = ServiceClient.create((String)(serverURL + serviceId), (Class)iface, (Map)lookupParams);
        return Registry.lookup((ServiceClient)sc);
    }

    private Object lookupService(String serverURL, String serviceId, String requiredVersion, Map lookupParams) throws IllegalArgumentException, LookupException {
        this.init();
        Vector serviceConvertors = (Vector)this.convertors.get(serviceId);
        if (serviceConvertors == null) {
            throw new IllegalArgumentException("No convertor provided for the service : " + serviceId);
        }
        String sourceVersion = this.getSourceServerVersion(serverURL);
        Convertor theConvertor = this.getConvertor(serviceConvertors, sourceVersion, requiredVersion, serviceId);
        if (theConvertor != null) {
            if (lookupParams != null) {
                return theConvertor.lookup(serviceId, serverURL, sourceVersion, requiredVersion, lookupParams);
            }
            return theConvertor.lookup(serviceId, serverURL, sourceVersion, requiredVersion);
        }
        throw new LookupException("Cannot find the convertor for " + serviceId + " " + requiredVersion + "->" + sourceVersion);
    }

    private Convertor getConvertor(Vector serviceConvertors, String sourceVersion, String requiredVersion, String serviceId) {
        Convertor theConvertor = null;
        int i = 0;
        while (i < serviceConvertors.size()) {
            Convertor convertor = (Convertor)serviceConvertors.elementAt(i);
            Convertor.SysServiceItem[] sysServiceItems = convertor.getMaintainedServiceItems();
            int j = 0;
            while (j < sysServiceItems.length) {
                Convertor.SysServiceItem sysServiceItem = sysServiceItems[j];
                if (sysServiceItem != null) {
                    String convertorSourceVersion = sysServiceItem.getSourceVersion();
                    String convertorTargetVersion = sysServiceItem.getTargetVersion();
                    String convertorServiceName = sysServiceItem.getServiceName();
                    if (convertorSourceVersion.equals(sourceVersion) && serviceId.equals(convertorServiceName) && (requiredVersion == null || convertorTargetVersion.equals(requiredVersion))) {
                        theConvertor = convertor;
                    }
                    if (theConvertor != null) break;
                }
                ++j;
            }
            if (theConvertor != null) break;
            ++i;
        }
        return theConvertor;
    }

    private String getSourceServerVersion(String serverURL) throws LookupException {
        String version = (String)this.url2Version.get(serverURL);
        String sourceVersion = null;
        if (version == null) {
            sourceVersion = this.getSourceVersion(serverURL);
            if (sourceVersion == null) {
                throw new LookupException("The sourceVersion is null" + serverURL);
            }
            version = this.convertVersion(sourceVersion);
        }
        if (version == null) {
            throw new LookupException("Unknown version : " + sourceVersion);
        }
        sourceVersion = version;
        return sourceVersion;
    }

    private String getSourceVersion(String serverURL) throws LookupException {
        PingService pingService = null;
        pingService = (PingService)Registry.lookup((String)(serverURL + PING_SERVICE_URL), (Class)(class$org$systinet$wasp$admin$PingService == null ? (class$org$systinet$wasp$admin$PingService = SysServices.class$("org.systinet.wasp.admin.PingService")) : class$org$systinet$wasp$admin$PingService));
        String pingVersion = pingService.getVersion();
        return pingVersion;
    }

    private String convertVersion(String pingVersion) {
        StringTokenizer st = new StringTokenizer(pingVersion);
        boolean found = false;
        while (!found && st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!t.equals("interface") || !(t = st.nextToken()).equals("version")) continue;
            pingVersion = st.nextToken();
            found = true;
        }
        if (!found) {
            return null;
        }
        return SysServices.converted2Const(pingVersion);
    }

    private static String converted2Const(String pingVersion) {
        int i = 0;
        while (i < waspVersions.length) {
            String waspVersion = waspVersions[i];
            if (pingVersion.startsWith(waspVersion)) {
                return waspVersion;
            }
            ++i;
        }
        return WASP_FORWARD;
    }

    protected static SysServices getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new SysServices();
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

