/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.bc;

import com.systinet.wasp.bc.Convertor;
import com.systinet.wasp.bc.IdentityConvertorConfig;
import com.systinet.wasp.bc.SysServices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.wasp.Context;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.Registry;

public class IdentityConvertor
implements Convertor {
    private static final String CONFIG_ELEMENT_TYPE = "identityConvertor";
    private static final String CONFIG_ELEMENT_NAME = "main";
    private boolean initialized = false;
    private Map serviceName2Infos = new HashMap();
    private Convertor.SysServiceItem[] sysServiceItems = null;
    static /* synthetic */ Class class$com$systinet$wasp$bc$IdentityConvertorConfig;

    public Object lookup(String SERVICE_NAME, String serverURL, String sourceVersion, String requestedVersion) throws IllegalArgumentException, LookupException {
        return this.lookup(SERVICE_NAME, serverURL, sourceVersion, requestedVersion, null);
    }

    public Object lookup(String serviceName, String serverURL, String sourceVersion, String requestedVersion, Map lookupParams) throws IllegalArgumentException, LookupException {
        this.init();
        IdentityServiceInfo isi = (IdentityServiceInfo)this.serviceName2Infos.get(serviceName);
        if (isi == null) {
            throw new IllegalArgumentException("No identity convertor configured for " + serviceName);
        }
        if (requestedVersion == null || !requestedVersion.equals("4.6")) {
            throw new IllegalArgumentException("Unable to provide identity conversion to interface version " + requestedVersion);
        }
        if (serverURL == null) {
            throw new IllegalArgumentException("serverURL must not be null");
        }
        int sourceVersionIndex = isi.versions.indexOf(sourceVersion);
        if (sourceVersionIndex == -1) {
            throw new IllegalArgumentException("Unable to provide identity conversion from the source version " + sourceVersion);
        }
        Class interfaceClass = null;
        try {
            interfaceClass = Class.forName(isi.interfaceName);
        }
        catch (ClassNotFoundException e) {
            interfaceClass = null;
        }
        if (interfaceClass == null) {
            SysServices sysServices = SysServices.getInstance();
            if (sysServices == null) {
                throw new LookupException("Unable to get instance of SysServices, it's null");
            }
            interfaceClass = sysServices.loadClassFromPackage(isi.packageName, isi.interfaceName);
        }
        if (interfaceClass == null) {
            throw new LookupException("Unable to load class " + isi.interfaceName + " either from the default classloder of from the package " + isi.packageName);
        }
        String serviceURL = serverURL + isi.url;
        if (lookupParams == null) {
            return Registry.lookup((String)serviceURL, (Class)interfaceClass);
        }
        return Registry.lookup((String)serviceURL, (Class)interfaceClass, (String)serviceURL, (Map)lookupParams);
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        Configurator cfg = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable configurable = Configurator.getConfigurable((String)CONFIG_ELEMENT_TYPE, (String)CONFIG_ELEMENT_NAME);
        if (configurable == null) {
            return;
        }
        IdentityConvertorConfig icc = (IdentityConvertorConfig)configurable.narrow(class$com$systinet$wasp$bc$IdentityConvertorConfig == null ? (class$com$systinet$wasp$bc$IdentityConvertorConfig = IdentityConvertor.class$("com.systinet.wasp.bc.IdentityConvertorConfig")) : class$com$systinet$wasp$bc$IdentityConvertorConfig);
        if (icc == null) {
            return;
        }
        IdentityConvertorConfig.ServiceConfig[] serviceConfigs = icc.getServices();
        Vector<SysServiceItemImpl> tmpServiceItems = new Vector<SysServiceItemImpl>();
        int i = 0;
        while (i < serviceConfigs.length) {
            IdentityConvertorConfig.ServiceConfig serviceConfig = serviceConfigs[i];
            if (serviceConfig != null) {
                IdentityServiceInfo isi = new IdentityServiceInfo();
                isi.interfaceName = serviceConfig.getInterfaceName();
                isi.packageName = serviceConfig.getPackageName();
                isi.url = serviceConfig.getServicePath();
                isi.versions = this.string2List(serviceConfig.getVersions());
                isi.serviceName = serviceConfig.getServiceName();
                this.serviceName2Infos.put(isi.serviceName, isi);
                int j = 0;
                while (j < isi.versions.size()) {
                    String v = (String)isi.versions.get(j);
                    if (v != null && !v.equals("")) {
                        tmpServiceItems.add(new SysServiceItemImpl(isi.serviceName, v, "4.6", isi.url));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.sysServiceItems = tmpServiceItems.toArray(new Convertor.SysServiceItem[0]);
        this.initialized = true;
    }

    private List string2List(String versions) {
        StringTokenizer st = new StringTokenizer(versions, ",");
        Vector<String> list = new Vector<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public Convertor.SysServiceItem[] getMaintainedServiceItems() {
        this.init();
        return this.sysServiceItems;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SysServiceItemImpl
    implements Convertor.SysServiceItem {
        private String serviceName;
        private String sourceVersion;
        private String targetVersion;
        private String serviceEndpoint;

        public SysServiceItemImpl(String serviceName, String sourceVersion, String targetVersion, String serviceEndpoint) {
            this.serviceName = serviceName;
            this.sourceVersion = sourceVersion;
            this.targetVersion = targetVersion;
            this.serviceEndpoint = serviceEndpoint;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getSourceVersion() {
            return this.sourceVersion;
        }

        public String getTargetVersion() {
            return this.targetVersion;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }
    }

    class IdentityServiceInfo {
        public String interfaceName;
        public String packageName;
        public String url;
        public List versions;
        public String serviceName;

        IdentityServiceInfo() {
        }
    }
}

