/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.security.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.systinet.wasp.security.ws.Reference;
import org.systinet.wasp.security.ws.SecurityElement;
import org.systinet.wasp.security.ws.SecurityToken;
import org.systinet.wasp.security.ws.UriReference;
import org.systinet.wasp.security.ws.conf.KeyInfoConf;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.ReferenceConf;
import org.systinet.wasp.security.ws.conf.SignatureConf;

public class Signature
extends SecurityElement {
    private List references = null;
    private boolean signBody = false;
    private String signatureMethod = null;
    private String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private static final ReferenceConf[] NULL_REFERENCE_CONF_ARRAY = new ReferenceConf[0];
    private String securityTokenReferenceId = null;

    public Signature(SecurityToken token) {
        super(token);
        this.signatureMethod = token.getSignatureMethodHint();
        token.getIdForced();
    }

    public Signature(SecurityToken token, UriReference reference) {
        super(token);
        this.signatureMethod = token.getSignatureMethodHint();
        token.getIdForced();
        this.addReference(reference);
    }

    public void addReference(UriReference reference) {
        if (this.references == null) {
            this.references = new ArrayList();
        }
        this.references.add(reference);
    }

    public void setSignBody() {
        this.signBody = true;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public void setSecurityTokenReferenceId(String strId) {
        this.securityTokenReferenceId = strId;
    }

    SignatureConf getSignatureConf(MessageConf messageConf) {
        SignatureConf signatureConf = messageConf.newSignature();
        if (this.getId() != null) {
            signatureConf.setWsuId(this.getId());
        }
        signatureConf.setCanonicalizationMethod(this.canonicalizationMethod);
        signatureConf.setSignatureMethod(this.signatureMethod);
        signatureConf.setSignBody(this.signBody ? Boolean.TRUE : Boolean.FALSE);
        if (this.references != null) {
            ArrayList<ReferenceConf> refs = new ArrayList<ReferenceConf>();
            Iterator it = this.references.iterator();
            while (it.hasNext()) {
                Reference reference = (Reference)it.next();
                ReferenceConf refConf = reference.getReferenceConf(signatureConf);
                refs.add(refConf);
            }
            ReferenceConf[] refConfs = refs.toArray(NULL_REFERENCE_CONF_ARRAY);
            signatureConf.setReferences(refConfs);
        }
        KeyInfoConf keyInfoConf = signatureConf.newKeyInfo();
        SecurityToken token = this.getToken();
        keyInfoConf.setSecurityTokenMode(token.getTokenReferenceModeHint(this));
        keyInfoConf.setSecurityTokenId(token.getId());
        keyInfoConf.setStrWsuId(this.securityTokenReferenceId);
        signatureConf.setKeyInfo(keyInfoConf);
        return signatureConf;
    }
}

