/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.idoox.util.UUID;
import com.systinet.wasp.security.secext.Init;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.Canonicalizer;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.iface.WSSecurityHeader;
import com.systinet.wasp.security.ws.iface.WSTimestampHeader;
import com.systinet.wasp.security.ws.impl.WSSecSerializer;
import com.systinet.wasp.security.ws.impl.WSSecurityHeaderImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import com.systinet.wasp.security.ws.impl.WSTimestampHeaderImpl;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenHandlerSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.EncryptedDataConf;
import org.systinet.wasp.security.ws.conf.EncryptedKeyConf;
import org.systinet.wasp.security.ws.conf.ExternalSecurityTokensConf;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.OrderedElementConf;
import org.systinet.wasp.security.ws.conf.ReferenceListConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.security.ws.conf.SignatureConf;
import org.systinet.wasp.security.ws.conf.WSSEGlobalConf;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSecurityImpl
extends WSSecurity {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.com.WSSecurityImpl");
    protected static String dsNamespace = null;
    protected static String dsPrefix = null;
    protected static String encPrefix = null;
    protected static String encNamespace = null;
    private static String wsuPrefix = null;
    private static String wssePrefix = null;
    private boolean initialized = false;
    public static final String TAG_REFERENCE_SECURITY_TOKEN = "SecurityTokenReference";
    public static final String TAG_XPATH = "XPath";
    public static final String TAG_TRANSFORMATION_PARAMETERS = "TransformationParameters";
    public static final String TAG_BODY = "Body";
    public static final String TAG_ENVELOPE = "Envelope";
    public static final String ATTR_MUST_UNDERSTAND = "mustUnderstand";
    public static final TimeZone tzUTC = TimeZone.getTimeZone("UTC");
    private Vector tokenHandlers = new Vector(2);
    public static String WSSECURITY_CONTEXT_KEY = "WSSECURITY_CONTEXT_KEY";
    public static String UNSESURE_OUTPUT = "UNSECURE_OUTPUT";
    private WSSEGlobalConf globalConf = null;
    public static final long DEFAULT_TIMESTAMP_EXPIRATION = 300000L;
    public static final long DEFAULT_CLOCK_SKEW = 300000L;
    public static final String CERT_WRAPPER_KEY = "CERT_WRAPPER_KEY";
    private long timestampExpiration = 300000L;
    public static final String INCOMING_EXCEPTION = "incomingException";
    public long clockSkew = 300000L;
    private static ThreadLocal utcDateFormat = new ThreadLocal();
    private static ThreadLocal utcDateFormatMs = new ThreadLocal();
    private static ThreadLocal utcCalendar = new ThreadLocal();

    public static SimpleDateFormat getUtcDateFormat() {
        SimpleDateFormat dateFormat = (SimpleDateFormat)utcDateFormat.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(tzUTC);
            utcDateFormat.set(dateFormat);
        }
        return dateFormat;
    }

    public static SimpleDateFormat getUtcDateFormatMs() {
        SimpleDateFormat dateFormat = (SimpleDateFormat)utcDateFormatMs.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            dateFormat.setTimeZone(tzUTC);
            utcDateFormatMs.set(dateFormat);
        }
        return dateFormat;
    }

    public static SimpleDateFormat getUtcDateFormatBaltimore() {
        SimpleDateFormat dateFormat = (SimpleDateFormat)utcDateFormatMs.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(tzUTC);
            utcDateFormatMs.set(dateFormat);
        }
        return dateFormat;
    }

    public static WSCalendar getUtcCalendar() {
        WSCalendar calendar = (WSCalendar)utcCalendar.get();
        if (calendar == null) {
            calendar = new WSCalendar(tzUTC);
            utcCalendar.set(calendar);
        }
        return calendar;
    }

    public WSSecurityHeader createSecurityHeader(MessageConf senderConf, Document message, Element timestampElement) throws WSSecurityException {
        int i;
        String wsuNamespace;
        this.init();
        if (senderConf == null || Boolean.TRUE.equals(senderConf.getNoSecurityHeader())) {
            return null;
        }
        String wsseNamespace = senderConf.getWsseNamespace();
        if (wsseNamespace == null) {
            wsseNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        }
        if ((wsuNamespace = senderConf.getWsuNamespace()) == null) {
            wsuNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        }
        if (!WSSecurity.KNOWN_SECURITY_URI_LIST.contains(wsseNamespace)) {
            log.error("Unknown WS Security namespace : " + wsseNamespace);
            log.error("Known namespaces are : ");
            int i2 = 0;
            while (i2 < WSSecurity.KNOWN_SECURITY_URI.length) {
                String s = WSSecurity.KNOWN_SECURITY_URI[i2];
                log.error(s);
                ++i2;
            }
            throw WSSecurityException.INVALID_SECURITY;
        }
        if (!WSSecurity.KNOWN_WSU_URI_LIST.contains(wsuNamespace)) {
            log.error("Unknown utility namespace : " + wsuNamespace);
            log.error("Known namespaces are : ");
            int i3 = 0;
            while (i3 < WSSecurity.KNOWN_WSU_URI.length) {
                String s = WSSecurity.KNOWN_WSU_URI[i3];
                log.error(s);
                ++i3;
            }
            throw WSSecurityException.INVALID_SECURITY;
        }
        String role = senderConf.getRole();
        String mustUnderstand = senderConf.getMustUnderstand() == null ? null : (Boolean.TRUE.equals(senderConf.getMustUnderstand()) ? "1" : "0");
        WSSecurityHeaderImpl securityHeader = new WSSecurityHeaderImpl(message, this.tokenHandlers, wsseNamespace, wsuNamespace, role, mustUnderstand, this.globalConf, timestampElement);
        CallContext callContext = Current.getCallContext();
        callContext.getContextData().put(WSSECURITY_CONTEXT_KEY, securityHeader);
        ExternalSecurityTokensConf externalSecurityTokens = WSSecurityHelper.getExternalSecurityTokensConf();
        if (externalSecurityTokens != null) {
            SecurityTokenConf[] securityTokenConfs = externalSecurityTokens.getSecurityTokens();
            i = 0;
            while (i < securityTokenConfs.length) {
                securityHeader.addSecurityToken(securityTokenConfs[i], true);
                ++i;
            }
        }
        try {
            OrderedElementConf[] actionConfs = this.getOrderedActions(senderConf);
            Vector<Object> securityObjects = new Vector<Object>();
            i = 0;
            while (i < actionConfs.length) {
                OrderedElementConf actionConf = actionConfs[i];
                if (actionConf instanceof SignatureConf) {
                    securityObjects.add(securityHeader.createSignature((SignatureConf)actionConf));
                } else if (actionConf instanceof EncryptedKeyConf) {
                    securityObjects.add(securityHeader.createEncryptedKey((EncryptedKeyConf)actionConf));
                } else if (actionConf instanceof EncryptedDataConf) {
                    securityObjects.add(securityHeader.createEncryptedData((EncryptedDataConf)actionConf));
                } else if (actionConf instanceof SecurityTokenConf) {
                    securityObjects.add(securityHeader.addSecurityToken((SecurityTokenConf)actionConf, false));
                } else if (actionConf instanceof ReferenceListConf) {
                    securityObjects.add(securityHeader.createReferenceList((ReferenceListConf)actionConf));
                }
                ++i;
            }
            int i4 = 0;
            while (i4 < securityObjects.size()) {
                WSSecurityObject securityObject = (WSSecurityObject)securityObjects.elementAt(i4);
                securityObject.doFinal();
                ++i4;
            }
            Object var16_20 = null;
            callContext.getContextData().remove(WSSECURITY_CONTEXT_KEY);
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            callContext.getContextData().remove(WSSECURITY_CONTEXT_KEY);
            throw throwable;
        }
        return securityHeader;
    }

    public static String getWsuPrefix() {
        return wsuPrefix;
    }

    public static String getWssePrefix() {
        return wssePrefix;
    }

    private synchronized void init() {
        if (!this.initialized) {
            int i;
            Init.init();
            try {
                ElementProxy.setDefaultPrefix(WSSecurityImpl.getDsNamespace(), WSSecurityImpl.getDsPrefix());
                ElementProxy.setDefaultPrefix(WSSecurityImpl.getEncNamespace(), WSSecurityImpl.getEncPrefix());
                int i2 = 0;
                while (i2 < WSSecurity.KNOWN_SECURITY_URI.length) {
                    ElementProxy.setDefaultPrefix(WSSecurity.KNOWN_SECURITY_URI[i2], WSSecurityImpl.getWssePrefix());
                    ++i2;
                }
                i = 0;
                while (i < WSSecurity.KNOWN_WSU_URI.length) {
                    ElementProxy.setDefaultPrefix(WSSecurity.KNOWN_WSU_URI[i], WSSecurityImpl.getWsuPrefix());
                    ++i;
                }
            }
            catch (XMLSecurityException e) {
                log.error((Object)e);
            }
            this.initialized = true;
            String[] handlerClassNames = this.globalConf.getSecurityTokenHandlers();
            if (handlerClassNames != null) {
                i = 0;
                while (i < handlerClassNames.length) {
                    try {
                        Class<?> clazz = Class.forName(handlerClassNames[i]);
                        Object handler = clazz.newInstance();
                        if (handler instanceof SecurityTokenHandlerSPI) {
                            this.addSecurityTokenHandler((SecurityTokenHandlerSPI)handler);
                        } else {
                            log.error("security token handler class \"" + handlerClassNames[i] + "\" is not type of SecurityTokenHandlerSPI");
                        }
                    }
                    catch (Exception e) {
                        log.error("cannot add security token handler class \"" + handlerClassNames[i] + "\"+because of exception", (Throwable)e);
                    }
                    ++i;
                }
            }
        }
    }

    public synchronized void setGlobalConfiguration(WSSEGlobalConf globalConf) {
        this.globalConf = globalConf;
        String string = dsNamespace = globalConf == null ? null : globalConf.getDsNamespace();
        if (dsNamespace == null) {
            dsNamespace = "http://www.w3.org/2000/09/xmldsig#";
        }
        String string2 = dsPrefix = globalConf == null ? null : globalConf.getDsPrefix();
        if (dsPrefix == null) {
            dsPrefix = "ds";
        }
        String string3 = encNamespace = globalConf == null ? null : globalConf.getEncNamespace();
        if (encNamespace == null) {
            encNamespace = "http://www.w3.org/2001/04/xmlenc#";
        }
        String string4 = encPrefix = globalConf == null ? null : globalConf.getEncPrefix();
        if (encPrefix == null) {
            encPrefix = "xenc";
        }
        String string5 = wssePrefix = globalConf == null ? null : globalConf.getWssePrefix();
        if (wssePrefix == null) {
            wssePrefix = "wsse";
        }
        String string6 = wsuPrefix = globalConf == null ? null : globalConf.getWsuPrefix();
        if (wsuPrefix == null) {
            wsuPrefix = "wsu";
        }
    }

    public WSSecurityHeader[] getSecurityHeaders(Document message) throws WSSecurityException {
        this.init();
        Element documentElement = message.getDocumentElement();
        String soapNamespaceURI = documentElement.getNamespaceURI();
        NodeList childs = documentElement.getChildNodes();
        Vector<WSSecurityHeaderImpl> securityHeaders = new Vector<WSSecurityHeaderImpl>();
        Element soapHeaderElement = null;
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            String nodeName = child.getLocalName();
            if (nodeName != null && nodeName.equals("Header") && child.getNamespaceURI().equals(soapNamespaceURI) && child.getNodeType() == 1) {
                soapHeaderElement = (Element)child;
                NodeList childNodes = child.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    Node header = childNodes.item(j);
                    String headerLocalName = header.getLocalName();
                    if (headerLocalName != null) {
                        if (headerLocalName.equals("Security") && WSSecurity.KNOWN_SECURITY_URI_LIST.contains(header.getNamespaceURI())) {
                            securityHeaders.add(new WSSecurityHeaderImpl(soapHeaderElement, (Element)header, this.tokenHandlers, header.getNamespaceURI(), this.globalConf, this.clockSkew));
                        }
                        if (headerLocalName.equals("Security") && !WSSecurity.KNOWN_SECURITY_URI_LIST.contains(header.getNamespaceURI())) {
                            log.warn("The header contains an element <Security> in the unsupported namesapce");
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return securityHeaders.toArray(new WSSecurityHeader[0]);
    }

    public WSTimestampHeader createTimestampHeader(MessageConf senderConf, Document message) {
        String wsuNamespace;
        String wsseNamespace = senderConf.getWsseNamespace();
        if (wsseNamespace == null) {
            wsseNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        }
        if ((wsuNamespace = senderConf.getWsuNamespace()) == null) {
            wsuNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        }
        String role = senderConf.getRole();
        String mustUnderstandTimestampHeader = senderConf.getMustUnderstandTimestampHeader() == null ? null : (Boolean.TRUE.equals(senderConf.getMustUnderstandTimestampHeader()) ? "1" : "0");
        return new WSTimestampHeaderImpl(message, wsseNamespace, wsuNamespace, role, mustUnderstandTimestampHeader);
    }

    public WSTimestampHeader getTimestampHeader(Document message) {
        this.init();
        Element documentElement = message.getDocumentElement();
        String soapNamespaceURI = documentElement.getNamespaceURI();
        NodeList childs = documentElement.getChildNodes();
        Element soapHeaderElement = null;
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            String nodeName = child.getLocalName();
            if (nodeName != null && nodeName.equals("Header") && child.getNamespaceURI().equals(soapNamespaceURI) && child.getNodeType() == 1) {
                soapHeaderElement = (Element)child;
                NodeList childNodes = child.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    Node header = childNodes.item(j);
                    String headerLocalName = header.getLocalName();
                    if (headerLocalName != null) {
                        String namespaceURI = header.getNamespaceURI();
                        if (headerLocalName.equals("Timestamp") && WSSecurity.KNOWN_WSU_URI_LIST.contains(namespaceURI)) {
                            return new WSTimestampHeaderImpl((Element)header);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public byte[] byteArrayFromDOM(Node node) {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
            byte[] ret = c14n.canonicalizeSubtree(node);
            return ret;
        }
        catch (InvalidCanonicalizerException e) {
        }
        catch (CanonicalizationException e) {
            log.error("", (Throwable)e);
        }
        return null;
    }

    private OrderedElementConf[] getOrderedActions(MessageConf senderConf) {
        SignatureConf[] signatureConfs = senderConf.getSignatures();
        SecurityTokenConf[] securityTokenConfs = senderConf.getSecurityTokens();
        EncryptedKeyConf[] encryptedKeyConfs = senderConf.getEncryptedKeys();
        EncryptedDataConf[] encryptedDataConfs = senderConf.getEncryptedData();
        ReferenceListConf[] referenceListConfs = senderConf.getReferenceLists();
        signatureConfs = signatureConfs == null ? new SignatureConf[]{} : signatureConfs;
        securityTokenConfs = securityTokenConfs == null ? new SecurityTokenConf[]{} : securityTokenConfs;
        encryptedKeyConfs = encryptedKeyConfs == null ? new EncryptedKeyConf[]{} : encryptedKeyConfs;
        encryptedDataConfs = encryptedDataConfs == null ? new EncryptedDataConf[]{} : encryptedDataConfs;
        referenceListConfs = referenceListConfs == null ? new ReferenceListConf[]{} : referenceListConfs;
        OrderedElementConf[] actionConfs = new OrderedElementConf[signatureConfs.length + encryptedKeyConfs.length + encryptedDataConfs.length + securityTokenConfs.length + referenceListConfs.length];
        System.arraycopy(signatureConfs, 0, actionConfs, 0, signatureConfs.length);
        System.arraycopy(encryptedKeyConfs, 0, actionConfs, signatureConfs.length, encryptedKeyConfs.length);
        System.arraycopy(encryptedDataConfs, 0, actionConfs, signatureConfs.length + encryptedKeyConfs.length, encryptedDataConfs.length);
        System.arraycopy(securityTokenConfs, 0, actionConfs, signatureConfs.length + encryptedKeyConfs.length + encryptedDataConfs.length, securityTokenConfs.length);
        System.arraycopy(referenceListConfs, 0, actionConfs, signatureConfs.length + encryptedKeyConfs.length + encryptedDataConfs.length + securityTokenConfs.length, referenceListConfs.length);
        Arrays.sort(actionConfs, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer order2;
                Integer order1 = o1 == null ? null : ((OrderedElementConf)o1).getOrder();
                Integer n = order2 = o2 == null ? null : ((OrderedElementConf)o2).getOrder();
                if (order1 == null || order2 == null) {
                    OrderedElementConf oe1 = (OrderedElementConf)o1;
                    OrderedElementConf oe2 = (OrderedElementConf)o2;
                    log.error("The operation is null or the order is not set");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                if (order1.equals(order2)) {
                    log.error("No items can have the same order value");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                return order1.compareTo(order2);
            }
        });
        return actionConfs;
    }

    public void addSecurityTokenHandler(SecurityTokenHandlerSPI tokenHandlerSPI) {
        Vector vector = this.tokenHandlers;
        synchronized (vector) {
            this.tokenHandlers.add(tokenHandlerSPI);
        }
    }

    public static String genId() {
        return "Id-" + UUID.uuidgen();
    }

    public static String getEncNamespace() {
        return encNamespace;
    }

    public static String getEncPrefix() {
        return encPrefix;
    }

    public static String getDsPrefix() {
        return dsPrefix;
    }

    public static String getDsNamespace() {
        return dsNamespace;
    }

    private void processSerializedWsuId(SecurityContext secCtx) {
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)secCtx.getMessageDocument(), (String)"//security-wsu-id-sadklfjakl34432423");
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node != null) {
                    if (node.getNodeType() != 1) {
                        log.error("WSUID Node is not Element node");
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    Element idel = (Element)node;
                    String wsuId = idel.getAttributeNS(WSSecSerializer.WSUID_ATTR_ID_NAMESPACE, "id");
                    Node childNode = idel.getFirstChild();
                    if (childNode.getNextSibling() != null) {
                        log.error("WSUIDzed element has sibbling");
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    if (childNode.getNodeType() != 1) {
                        log.error("WSUIDzed element is not DOM Element");
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    String origId = WSSecurityHelper.getAttributeNS(WSSecurity.KNOWN_WSU_URI, "Id", (Element)childNode);
                    if (origId != null) {
                        log.error("wsu:id already defined for WSUIDzed element");
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    Node idel_parent = idel.getParentNode();
                    idel_parent.appendChild(childNode);
                    idel_parent.replaceChild(childNode, idel);
                    String wsuPrefix = ElementProxy.getDefaultPrefix(secCtx.getWsuNamespace());
                    if (wsuPrefix == null) {
                        wsuPrefix = WSSecurityImpl.getWsuPrefix();
                    }
                    WSSecurityHelper.addNamespacePrefix(secCtx.getWsuNamespace(), wsuPrefix, (Element)childNode);
                    ((Element)childNode).setAttributeNS(secCtx.getWsuNamespace(), wsuPrefix + ":" + "Id", wsuId);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (TransformerException e) {
            log.error((Object)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    public static class WSCalendar
    extends GregorianCalendar {
        public WSCalendar(TimeZone tz) {
            super(tz);
        }

        public long getCurrentTimeInMillis() {
            super.setTimeInMillis(System.currentTimeMillis());
            return this.getTimeInMillis();
        }

        public Date getCurrentTime() {
            super.setTimeInMillis(System.currentTimeMillis());
            return super.getTime();
        }
    }
}

