/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.systinet.wasp.security.ws.impl.PWDPSHA1ParameterSpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.idoox.util.RuntimeWrappedException;

public final class PWDPSHA1Generator
extends KeyGeneratorSpi {
    public static final int TRIPLEDES_KEY_LENGTH = 24;
    private static final String HMACSHA1 = "HmacSHA1";
    private byte[] secret;
    private String label;
    private byte[] seed;
    private int keySize;
    private Mac mac = null;
    private SecretKey macInit = null;
    private byte[] aValue;
    private byte[] chunk = new byte[0];
    private int index = 0;

    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof PWDPSHA1ParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        PWDPSHA1ParameterSpec spec = (PWDPSHA1ParameterSpec)algorithmParameterSpec;
        this.secret = spec.getSecret();
        this.label = spec.getLabel();
        this.keySize = spec.getKeySize();
        byte[] seed = spec.getSeed();
        try {
            this.mac = Mac.getInstance(HMACSHA1);
            this.macInit = new SecretKeySpec(this.secret, HMACSHA1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        byte[] labelBytes = new byte[]{};
        try {
            labelBytes = this.label.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        this.seed = new byte[labelBytes.length + seed.length];
        System.arraycopy(labelBytes, 0, this.seed, 0, labelBytes.length);
        System.arraycopy(seed, 0, this.seed, labelBytes.length, seed.length);
        this.aValue = this.seed;
    }

    protected void engineInit(int i, SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    protected SecretKey engineGenerateKey() {
        int l = this.keySize;
        byte[] key = new byte[l];
        int i = 0;
        while (i < l) {
            try {
                key[i] = this.getByte();
            }
            catch (Exception e) {
                throw new RuntimeWrappedException((Throwable)e);
            }
            ++i;
        }
        return new SecretKeySpec(key, HMACSHA1);
    }

    private byte getByte() throws NoSuchAlgorithmException, InvalidKeyException {
        if (this.index >= this.chunk.length) {
            this.mac.reset();
            this.mac.init(this.macInit);
            this.aValue = this.mac.doFinal(this.aValue);
            this.mac.reset();
            byte[] temp = new byte[this.aValue.length + this.seed.length];
            System.arraycopy(this.aValue, 0, temp, 0, this.aValue.length);
            System.arraycopy(this.seed, 0, temp, this.aValue.length, this.seed.length);
            this.chunk = this.mac.doFinal(temp);
            this.index = 0;
        }
        return this.chunk[this.index++];
    }

    public void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.engineInit(algorithmParameterSpec, null);
    }

    public SecretKey generateKey() {
        return this.engineGenerateKey();
    }
}

