/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethod;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.algorithms.encryption.params.OAEPParams;
import com.systinet.wasp.security.secext.encryption.EncryptedData;
import com.systinet.wasp.security.secext.encryption.XMLCipher;
import com.systinet.wasp.security.secext.encryption.XMLEncryptionException;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.EncryptedTypeObject;
import com.systinet.wasp.security.ws.impl.WSIdResolver;
import com.systinet.wasp.security.ws.impl.WSKeyInfo;
import com.systinet.wasp.security.ws.impl.WSKeyInfoImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import com.systinet.wasp.security.ws.provider.WSProviderHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.EncryptedDataConf;
import org.systinet.wasp.security.ws.conf.KeyInfoConf;
import org.systinet.wasp.security.ws.conf.OrderedElementConf;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EncryptedDataObject
extends EncryptedTypeObject {
    private static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$ws$impl$EncryptedDataObject == null ? (class$com$systinet$wasp$security$ws$impl$EncryptedDataObject = EncryptedDataObject.class$("com.systinet.wasp.security.ws.impl.EncryptedDataObject")) : class$com$systinet$wasp$security$ws$impl$EncryptedDataObject).getName());
    protected byte[] encryptingIV;
    protected String targetId;
    protected boolean processContent;
    protected Element encryptedDataElement;
    protected WSKeyInfo wsKeyInfo;
    protected XMLCipher.Factory factory;
    protected boolean referenced;
    static /* synthetic */ Class class$com$systinet$wasp$security$ws$impl$EncryptedDataObject;

    public EncryptedDataObject(SecurityContext securityContext, OrderedElementConf conf) throws WSSecurityException {
        block19: {
            super(securityContext, conf);
            try {
                boolean encryptBody;
                EncryptedDataConf encryptedDataConf = (EncryptedDataConf)conf;
                this.wsKeyInfo = new WSKeyInfoImpl((WSSecurityObject)this, encryptedDataConf.getKeyInfo());
                this.referenced = false;
                this.factory = XMLCipher.getFactory(this.getSecurityContext().getMessageDocument());
                EncryptedData ed = this.factory.newEncryptedData(this.factory.newCipherData(1));
                String encryptionMethodAlgorithm = encryptedDataConf.getEncryptionMethodAlgorithm();
                if (encryptionMethodAlgorithm == null) {
                    encryptionMethodAlgorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                }
                com.systinet.wasp.security.secext.encryption.EncryptionMethod em = this.factory.newEncryptionMethod(encryptionMethodAlgorithm);
                PropertyConf[] emprop = encryptedDataConf.getEncryptionMethodProperties();
                if (em.getAlgorithm().equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                    String digest = null;
                    byte[] params = null;
                    if (emprop != null) {
                        int i = 0;
                        while (i < emprop.length) {
                            if ("OAEPParams".equals(emprop[i].getPropertyName())) {
                                params = Base64.decode(emprop[i].getPropertyValue());
                            } else if ("OAEPDigest".equals(emprop[i].getPropertyName())) {
                                digest = emprop[i].getPropertyValue();
                            } else {
                                cat.error("encryptedKey has encryption method properties that selected algorithm does not supports");
                                throw WSSecurityException.UNSUPPORTED_ALGORITHM;
                            }
                            ++i;
                        }
                    }
                    if (digest == null) {
                        cat.error("RSA-OAEP algorithm's digest parameter is mandatory");
                        throw WSSecurityException.UNSUPPORTED_ALGORITHM;
                    }
                    if (params != null) {
                        em.setOAEPparams(Base64.encode(params).getBytes());
                    }
                    em.setOAEPDigestAlgorithm(digest);
                } else if (emprop != null && emprop.length != 0) {
                    cat.error("encryptedKey has encryption method properties that selected algorithm does not supports");
                    throw WSSecurityException.UNSUPPORTED_ALGORITHM;
                }
                ed.setEncryptionMethod(em);
                ed.setId(encryptedDataConf.getWsuId());
                boolean type = encryptedDataConf.getEncryptElementContent() == null ? false : encryptedDataConf.getEncryptElementContent();
                ed.setType("http://www.w3.org/2001/04/xmlenc#" + (type ? "Content" : "Element"));
                this.setEncryptedTypeHolder(ed);
                this.encryptingIV = encryptedDataConf.getIV();
                this.processContent = encryptedDataConf.getEncryptElementContent() == null ? false : encryptedDataConf.getEncryptElementContent();
                boolean bl = encryptBody = encryptedDataConf.getEncryptBody() == null ? false : encryptedDataConf.getEncryptBody();
                if (encryptBody) {
                    if (encryptedDataConf.getEncryptionTargetId() == null) {
                        if (!this.processContent) {
                            cat.error("Only message Body element's content can be encrypted");
                            throw WSSecurityException.INVALID_SECURITY;
                        }
                        String bodyId = this.getSecurityContext().getWsuIdFor(0);
                        this.setTargetId(bodyId);
                        break block19;
                    }
                    cat.error("both encryptBody and TargetId set for encryptedData; id=" + conf.getWsuId());
                    throw WSSecurityException.INVALID_SECURITY;
                }
                if (encryptedDataConf.getEncryptionTargetId() != null) {
                    this.setTargetId(encryptedDataConf.getEncryptionTargetId());
                    break block19;
                }
                cat.error("neither body or targetId was set for encryptedData; id=" + conf.getWsuId());
                throw WSSecurityException.INVALID_SECURITY;
            }
            catch (XMLEncryptionException e) {
                cat.error("", (Throwable)e);
                throw WSSecurityException.INVALID_SECURITY;
            }
            catch (Base64DecodingException e) {
                cat.error("", (Throwable)e);
                throw WSSecurityException.INVALID_SECURITY;
            }
        }
        this.getSecurityContext().addSecurityObject(this);
    }

    public void doFinal() throws WSSecurityException {
        if (this.getMode() == 0) {
            this.doFinalEncryption();
        } else {
            this.doFinalDecryption();
        }
    }

    public EncryptedDataObject(SecurityContext securityContext, Element element) throws WSSecurityException {
        super(securityContext, element);
        try {
            this.encryptedDataElement = element;
            this.factory = XMLCipher.getFactory(this.getSecurityContext().getMessageDocument());
            EncryptedData encryptedData = this.factory.newEncryptedData(this.encryptedDataElement);
            if (encryptedData == null) {
                cat.error("encryptedData load failed");
                throw WSSecurityException.INVALID_SECURITY;
            }
            this.setEncryptedTypeHolder(encryptedData);
            this.processContent = this.getType() == 2;
            this.wsKeyInfo = new WSKeyInfoImpl((WSSecurityObject)this, encryptedData.getKeyInfo());
        }
        catch (XMLEncryptionException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.getSecurityContext().addSecurityObject(this);
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    protected void doFinalEncryption() throws WSSecurityException {
        if (!this.referenced) {
            cat.error("EncryptedData is not referenced from neither EncryptedKey nor ReferenceList, wsu:Id=" + this.getWsuId());
            throw WSSecurityException.INVALID_SECURITY;
        }
        this.wsKeyInfo.doFinal();
        this.getEncryptedTypeHolder().setKeyInfo(this.wsKeyInfo.getWrappedKeyInfo());
        String trgId = this.getTargetId();
        Key encryptionKey = null;
        if (this.getEncryptingKey() != null) {
            encryptionKey = this.getEncryptingKey().getTransportedKey(this);
        }
        if (encryptionKey == null) {
            encryptionKey = this.wsKeyInfo.getEncryptingKey();
        }
        if (encryptionKey == null) {
            cat.error("cannot get key for encryption of EncryptedData; id=" + this.getWsuId());
            throw WSSecurityException.INVALID_SECURITY;
        }
        EncryptionMethod em = this.getEncryptionMethod();
        if (!em.getUsableInEncryptedData()) {
            cat.error("EncryptedData algorithm is not usable; id=" + this.getWsuId());
            throw WSSecurityException.INVALID_SECURITY;
        }
        if (this.encryptingIV == null && em.getIvLength() > 0) {
            this.encryptingIV = WSSecurityHelper.getRandomBytes(em.getIvLength());
        }
        byte[] contentData = null;
        Element processedElement = WSIdResolver.getElementById(this.getSecurityContext().getMessageDocument(), trgId);
        if (processedElement == null) {
            cat.error("cannot resolve element id=" + trgId);
            throw WSSecurityException.INVALID_SECURITY;
        }
        try {
            contentData = XMLCipher.serialize(processedElement, this.processContent).getBytes();
        }
        catch (XMLEncryptionException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        String encryptedData = null;
        try {
            encryptedData = this.encryptingIV == null ? em.encryptB64(contentData, encryptionKey) : em.encryptB64(contentData, encryptionKey, this.encryptingIV);
        }
        catch (XMLSecurityException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        try {
            this.getEncryptedTypeHolder().getCipherData().setCipherValue(this.factory.newCipherValue(encryptedData));
        }
        catch (XMLEncryptionException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        Element encDataElement = this.factory.toElement((EncryptedData)this.getEncryptedTypeHolder());
        if (this.processContent) {
            Node child = processedElement.getFirstChild();
            while (child != null) {
                processedElement.removeChild(child);
                child = processedElement.getFirstChild();
            }
            processedElement.appendChild(encDataElement);
        } else {
            Node parent = processedElement.getParentNode();
            parent.replaceChild(encDataElement, processedElement);
        }
    }

    protected void doFinalDecryption() throws WSSecurityException {
        try {
            this.wsKeyInfo.doFinal();
            Key encryptionKey = this.getEncryptingKey() != null ? this.getEncryptingKey().getTransportedKey(this) : this.wsKeyInfo.getDecryptingKey();
            if (encryptionKey == null) {
                cat.error("cannot get key for decryption of EncryptedData; id=" + this.getWsuId());
                throw WSSecurityException.INVALID_SECURITY;
            }
            EncryptionMethod em = this.getEncryptionMethod();
            if (!em.getUsableInEncryptedData()) {
                cat.error("EncryptedData algorithm is not usable; id=" + this.getWsuId());
                throw WSSecurityException.UNSUPPORTED_ALGORITHM;
            }
            byte[] encryptedData = this.getEncryptedTypeHolder().getCipherData().getCipherValue().getValue();
            byte[] decryptedData = em.decryptB64(new String(encryptedData, WSSecurity.UTF_8), encryptionKey);
            Element parent = (Element)this.encryptedDataElement.getParentNode();
            Element xmlReplacement = this.getReplacement(new String(decryptedData, WSSecurity.UTF_8), parent);
            Document currentDoc = this.encryptedDataElement.getOwnerDocument();
            Element targetNode = null;
            if (this.processContent) {
                NodeList nl = xmlReplacement.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node newnode = currentDoc.importNode(nl.item(i), true);
                    parent.insertBefore(newnode, this.encryptedDataElement);
                    ++i;
                }
                parent.removeChild(this.encryptedDataElement);
                targetNode = parent;
            } else {
                if (xmlReplacement.getChildNodes().getLength() != 1) {
                    cat.error("EncryptedData encrypts element but there is not just one Element after decryption");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                targetNode = (Element)currentDoc.importNode(xmlReplacement.getFirstChild(), true);
                parent.replaceChild(targetNode, this.encryptedDataElement);
            }
            this.getSecurityContext().addReceivedEncryptedDataConf(this.getReceivedConf(targetNode));
        }
        catch (UnsupportedEncodingException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        catch (XMLSecurityException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    private Element getReplacement(String decryptedDOMString, Element insertionPoint) {
        HashMap namespaces = new HashMap();
        this.getDefinedNS(insertionPoint, namespaces);
        StringBuffer sb = new StringBuffer("<dummy");
        Iterator it = namespaces.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = (String)namespaces.get(key);
            sb.append(' ').append(key).append("=\"").append(val).append('\"');
        }
        sb.append('>').append(decryptedDOMString).append("</dummy>");
        Document xmlReplacementDom = null;
        try {
            DocumentBuilder db = WSProviderHelper.getDocumentBuilder();
            xmlReplacementDom = db.parse(new ByteArrayInputStream(sb.toString().getBytes()));
        }
        catch (SAXException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        catch (IOException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        return xmlReplacementDom.getDocumentElement();
    }

    private void getDefinedNS(Node node, HashMap namespaces) {
        if (node.getParentNode() != null) {
            this.getDefinedNS(node.getParentNode(), namespaces);
        }
        NamedNodeMap attrs = node.getAttributes();
        int i = 0;
        while (attrs != null && i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr != null && attr.getNamespaceURI() != null && attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                String name = attr.getNodeName();
                String val = attr.getNodeValue();
                namespaces.put(name, val);
            }
            ++i;
        }
    }

    protected EncryptedDataConf getReceivedConf(Element targetNode) {
        KeyInfoConf kiconf;
        String id;
        EncryptedDataConf conf = this.getSecurityContext().getMessageConf().newEncryptedData();
        conf.setWsuId(this.getWsuId());
        if (conf.getWsuId() == null) {
            conf.setWsuId(WSSecurityHelper.getWsuIdFromElement(this.encryptedDataElement));
        }
        if ((id = WSSecurityHelper.getAttributeNS(WSSecurity.KNOWN_WSU_URI, "Id", targetNode)) == null) {
            id = WSSecurityHelper.getAttributeNS((String)null, "Id", targetNode);
        }
        this.setTargetId(id);
        conf.setEncryptionTargetId(id);
        conf.setEncryptBody(Boolean.FALSE);
        if ("Body".equals(targetNode.getLocalName()) && this.getSecurityContext().getSoapNamespaceUri().equals(targetNode.getNamespaceURI())) {
            Node bodyParent = targetNode.getParentNode();
            Node bodyRoot = bodyParent.getParentNode();
            if ("Envelope".equals(bodyParent.getLocalName()) && this.getSecurityContext().getSoapNamespaceUri().equals(bodyParent.getNamespaceURI()) && bodyRoot.getNodeType() == 9) {
                conf.setEncryptBody(Boolean.TRUE);
            }
        }
        conf.setEncryptElementContent(new Boolean(this.processContent));
        EncryptionMethod em = this.getEncryptionMethod();
        conf.setEncryptionMethodAlgorithm(em.getAlgorithmURI());
        EncryptionMethodParams emParams = em.getParams();
        if (emParams instanceof OAEPParams) {
            String digestMethod = ((OAEPParams)emParams).getDigestMethodURI();
            byte[] paramBytes = ((OAEPParams)emParams).getOAEPParamBytes();
            PropertyConf pDigest = null;
            if (digestMethod != null) {
                pDigest = conf.newEncryptionMethodProperty();
                pDigest.setPropertyName("OAEPDigest");
                pDigest.setPropertyValue(digestMethod);
            }
            PropertyConf pPbytes = null;
            if (paramBytes != null && paramBytes.length > 0) {
                pPbytes = conf.newEncryptionMethodProperty();
                pPbytes.setPropertyName("OAEPParams");
                pPbytes.setPropertyValue(Base64.encode(paramBytes));
            }
            if (pDigest != null && pPbytes != null) {
                conf.setEncryptionMethodProperties(new PropertyConf[]{pDigest, pPbytes});
            } else if (pDigest != null) {
                conf.setEncryptionMethodProperties(new PropertyConf[]{pDigest});
            } else if (pPbytes != null) {
                conf.setEncryptionMethodProperties(new PropertyConf[]{pPbytes});
            }
        }
        if (this.wsKeyInfo.setupKeyInfoConf(kiconf = conf.newKeyInfo())) {
            conf.setKeyInfo(kiconf);
        }
        return conf;
    }

    public void setReferenced() {
        this.referenced = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

