/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws;

import com.idoox.debug.Category;
import com.idoox.security.httpdigest.AuthorizationStructureImpl;
import com.idoox.security.httpdigest.DigestCalculator;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.security.server.ReceivedCredentialsImpl;
import com.idoox.wasp.Constants;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.PWDPSHA1Generator;
import com.systinet.wasp.security.ws.impl.PWDPSHA1ParameterSpec;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.security.httpdigest.AuthorizationStructure;
import org.idoox.security.pstore.PStore;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.util.Base64;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UserNameToken
extends SecurityTokenSPI {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.UserNameToken");
    public static final String TOKEN_PROFILE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0";
    private String username = null;
    private String password = null;
    private byte[] nonce = null;
    private Date created = null;
    private byte[] receivedPasswordDigest = null;
    private int passwordType = -1;
    private String formattedCreated = null;
    private Key secretKey = null;
    private static final String ELEMENT_NONCE = "Nonce";
    private static final String ELEMENT_PASSWORD = "Password";
    private static final String ATTR_PASSWORD_TYPE = "Type";
    public static final int PT_DIGEST = 1;
    public static final int PT_TEXT = 0;
    private static final String ELEMENT_USERNAME = "Username";
    private static final String ELEMENT_TYPE = "Type";
    private boolean xmlProcessed = false;
    private static LinkedList nonceCache = new LinkedList();

    public SecurityTokenConf getReceivedConf() {
        SecurityTokenConf tokenConf = this.getSecurityContext().getMessageConf().newSecurityToken();
        PropertyConf typePropertyConf = tokenConf.newProperty();
        PropertyConf usernamePropertyConf = tokenConf.newProperty();
        tokenConf.setType(ELEMENT_USERNAME);
        tokenConf.setProperties(new PropertyConf[]{typePropertyConf, usernamePropertyConf});
        int passwordType = 0;
        try {
            passwordType = this.getPasswordType();
        }
        catch (XMLSecurityException e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        if (passwordType == 1) {
            typePropertyConf.setPropertyName("PasswordType");
            typePropertyConf.setPropertyValue("PasswordDigest");
        } else {
            typePropertyConf.setPropertyName("PasswordType");
            typePropertyConf.setPropertyValue("PasswordText");
        }
        usernamePropertyConf.setPropertyName("alias");
        String username = null;
        try {
            username = this.getUsername();
        }
        catch (XMLSecurityException e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
        usernamePropertyConf.setPropertyValue(username);
        return tokenConf;
    }

    public UserNameToken(Element element, SecurityContext securityContext) throws XMLSecurityException {
        super(element, securityContext);
    }

    public UserNameToken(SecurityContext securityContext, boolean isExternal) {
        super(securityContext, isExternal);
    }

    public byte[] getKeyIdentifier() {
        return null;
    }

    public String getValueType() {
        return null;
    }

    public Key getEncryptingKey() throws WSSecurityException {
        return this.getSecretKey();
    }

    public Key getDecryptingKey() throws WSSecurityException {
        return this.getSecretKey();
    }

    public Key getSigningKey() throws WSSecurityException {
        return this.getSecretKey();
    }

    public Key getAuthenticatingKey() throws WSSecurityException {
        return this.getSecretKey();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void doFinal(int mode) {
        if (mode == 1) {
            try {
                if (this.getPasswordType() == 0) {
                    WaspCallbackHandler handler = new WaspCallbackHandler(this.getUsername(), this.getPassword(), PStore.getInstance((String)"").getUserStore(), Current.getCallContext().getContextData());
                    org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
                    ReceivedCredentialsImpl recCred = new ReceivedCredentialsImpl(this.getUsername(), "WS-Security", "NamePasswordAN", (CallbackHandler)handler);
                    current.setReceivedCredentials((ReceivedCredentials)recCred);
                } else if (this.getPasswordType() == 1) {
                    AuthorizationStructureImpl authorizationStructure = new AuthorizationStructureImpl();
                    authorizationStructure.setNonce(new String(com.idoox.security.util.Base64.encode((byte[])this.getNonce()), Constants.UTF_8));
                    authorizationStructure.setUsername(this.getUsername());
                    authorizationStructure.setCreated(WSSecurityImpl.getUtcDateFormat().format(this.getCreated()));
                    authorizationStructure.setResponse(new String(com.idoox.security.util.Base64.encode((byte[])this.getReceivedPasswordDigest()), Constants.UTF_8));
                    authorizationStructure.setAlgorithm("WS-SHA1");
                    WaspCallbackHandler handler = new WaspCallbackHandler((AuthorizationStructure)authorizationStructure, PStore.getInstance((String)"").getUserStore());
                    org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
                    ReceivedCredentialsImpl recCred = new ReceivedCredentialsImpl(this.getUsername(), "WS-Security", "NameDigestAN", (CallbackHandler)handler);
                    current.setReceivedCredentials((ReceivedCredentials)recCred);
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw WSSecurityException.FAILED_AUTHENTICATION;
            }
        }
    }

    public void setPassword(String password, int passwordType) {
        this.password = password;
        this.passwordType = passwordType;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public void setCreated(Date date) {
        this.created = date;
    }

    public void finalizeCreation() {
        String valueType;
        if (this.created != null) {
            this.formattedCreated = WSSecurityImpl.getUtcDateFormat().format(this.created);
            if (this.formattedCreated == null) {
                throw new RuntimeException("An error occured when processing date : " + this.created.toString() + " " + WSSecurityImpl.getUtcDateFormat().toPattern());
            }
        }
        Element usernameElement = this.getDocument().createElementNS(this.getSecurityContext().getWsseNamespace(), WSSecurityImpl.getWssePrefix() + ":" + ELEMENT_USERNAME);
        usernameElement.setNodeValue(this.username);
        this.addAnyElement(usernameElement);
        Text t = this.getDocument().createTextNode(this.username);
        usernameElement.appendChild(t);
        switch (this.passwordType) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    if (this.nonce == null || this.created == null || this.password == null) {
                        throw new WSSecurityException(null, "For the digested password, nonce, created and password must be set. You probably disabled created and nonce creation and used the digested password");
                    }
                    this.password = new String(Base64.encode((byte[])DigestCalculator.getWsSha1PasswordDigest((byte[])this.nonce, (String)this.formattedCreated, (String)this.password), (boolean)false), Constants.UTF_8);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            default: {
                log.error("Unknown password type, must be either PasswordDigest or PasswordText");
                throw WSSecurityException.INVALID_SECURITY;
            }
        }
        Element passwordElement = this.getDocument().createElementNS(this.getSecurityContext().getWsseNamespace(), WSSecurityImpl.getWssePrefix() + ":" + ELEMENT_PASSWORD);
        if (this.passwordType == 0) {
            valueType = null;
            valueType = WSSecurity.RC_SECURITY_URI_LIST.contains(this.getSecurityContext().getWsseNamespace()) ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" : WSSecurityImpl.getWssePrefix() + ":" + "PasswordText";
            passwordElement.setAttribute("Type", valueType);
        } else {
            valueType = null;
            valueType = WSSecurity.RC_SECURITY_URI_LIST.contains(this.getSecurityContext().getWsseNamespace()) ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest" : WSSecurityImpl.getWssePrefix() + ":" + "PasswordDigest";
            passwordElement.setAttribute("Type", valueType);
        }
        t = null;
        t = this.getDocument().createTextNode(this.password);
        passwordElement.appendChild(t);
        this.addAnyElement(passwordElement);
        if (this.nonce != null) {
            Element nonceElement = this.getDocument().createElementNS(this.getSecurityContext().getWsseNamespace(), WSSecurityImpl.getWssePrefix() + ":" + ELEMENT_NONCE);
            String encodedNonce = new String(Base64.encode((byte[])this.nonce, (boolean)false));
            t = this.getDocument().createTextNode(encodedNonce);
            nonceElement.appendChild(t);
            this.addAnyElement(nonceElement);
        }
        if (this.created != null) {
            Element createdElement = this.getDocument().createElementNS(this.getSecurityContext().getWsuNamespace(), WSSecurityImpl.getWsuPrefix() + ":" + "Created");
            t = this.getDocument().createTextNode(this.formattedCreated);
            createdElement.appendChild(t);
            this.addAnyElement(createdElement);
        }
    }

    public String getBaseNamespace() {
        SecurityContext securityContext = this.getSecurityContext();
        if (securityContext == null) {
            securityContext = (SecurityContext)Current.getCallContext().getContextData().get(WSSecurityImpl.WSSECURITY_CONTEXT_KEY);
        }
        return securityContext.getWsseNamespace();
    }

    public String getBaseLocalName() {
        return "UsernameToken";
    }

    public int getPasswordType() throws XMLSecurityException {
        this.processXML();
        return this.passwordType;
    }

    public String getPassword() throws XMLSecurityException {
        this.processXML();
        return this.password;
    }

    public String getUsername() throws XMLSecurityException {
        this.processXML();
        return this.username;
    }

    public Date getCreated() throws XMLSecurityException {
        this.processXML();
        return this.created;
    }

    public byte[] getNonce() throws XMLSecurityException {
        this.processXML();
        return this.nonce;
    }

    public byte[] getReceivedPasswordDigest() throws XMLSecurityException {
        this.processXML();
        return this.receivedPasswordDigest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processXML() throws XMLSecurityException {
        Element nonceElement;
        Element createdElement;
        Element usernameElement;
        block36: {
            String tmpVal;
            Element passwordElement;
            block37: {
                if (this.xmlProcessed) {
                    return;
                }
                this.xmlProcessed = true;
                if (!WSSecurity.KNOWN_SECURITY_URI_LIST.contains(this.getElement().getNamespaceURI())) throw new XMLSecurityException("The element has uncorrect namespace or local name{" + this.getElement().getNamespaceURI() + "}" + this.getElement().getLocalName());
                if (!this.getElement().getLocalName().equals("UsernameToken")) {
                    throw new XMLSecurityException("The element has uncorrect namespace or local name{" + this.getElement().getNamespaceURI() + "}" + this.getElement().getLocalName());
                }
                passwordElement = null;
                usernameElement = null;
                createdElement = null;
                nonceElement = null;
                NodeList childs = this.getElement().getChildNodes();
                int i = 0;
                while (i < childs.getLength()) {
                    Node child = childs.item(i);
                    if (child.getNodeType() == 1) {
                        Element el = null;
                        el = (Element)child;
                        if (el.getLocalName().equals(ELEMENT_PASSWORD)) {
                            if (!WSSecurity.KNOWN_SECURITY_URI_LIST.contains(el.getNamespaceURI())) {
                                throw new XMLSecurityException("Password element has incorrect namespace : " + el.getNamespaceURI());
                            }
                            passwordElement = el;
                        } else {
                            el = (Element)child;
                            if (el.getLocalName().equals(ELEMENT_USERNAME)) {
                                if (!WSSecurity.KNOWN_SECURITY_URI_LIST.contains(el.getNamespaceURI())) {
                                    throw new XMLSecurityException("Password element has incorrect namespace : " + el.getNamespaceURI());
                                }
                                usernameElement = el;
                            } else {
                                el = (Element)child;
                                if (el.getLocalName().equals("Created")) {
                                    if (!WSSecurity.KNOWN_WSU_URI_LIST.contains(el.getNamespaceURI())) {
                                        throw new XMLSecurityException("Password element has incorrect namespace : " + el.getNamespaceURI());
                                    }
                                    createdElement = el;
                                } else {
                                    el = (Element)child;
                                    if (el.getLocalName().equals(ELEMENT_NONCE)) {
                                        if (!WSSecurity.KNOWN_SECURITY_URI_LIST.contains(el.getNamespaceURI())) {
                                            throw new XMLSecurityException("Password element has incorrect namespace : " + el.getNamespaceURI());
                                        }
                                        nonceElement = el;
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
                if (passwordElement == null) break block36;
                String wsseNamespace = this.getSecurityContext().getWsseNamespace();
                tmpVal = passwordElement.getAttribute("Type");
                if (WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace)) break block37;
                if ((WSSecurityImpl.getWssePrefix() + ":" + "PasswordDigest").equals(tmpVal)) {
                    this.passwordType = 1;
                    String tmpStr = WSSecurityHelper.getTextNodeValue(passwordElement);
                    if (tmpStr != null) {
                        this.receivedPasswordDigest = Base64.decode((byte[])tmpStr.getBytes());
                    }
                    break block36;
                } else if ((WSSecurityImpl.getWssePrefix() + ":" + "PasswordText").equals(tmpVal)) {
                    this.passwordType = 0;
                    this.password = WSSecurityHelper.getTextNodeValue(passwordElement);
                    break block36;
                } else {
                    if (tmpVal != null && !"".equals(tmpVal)) {
                        log.error("Unsupported password type " + tmpVal);
                        throw WSSecurityException.UNSUPPORTED_SECURITY_TOKEN;
                    }
                    this.passwordType = 0;
                    this.password = WSSecurityHelper.getTextNodeValue(passwordElement);
                }
                break block36;
            }
            if (tmpVal != null && !"".equals(tmpVal) && !tmpVal.startsWith(TOKEN_PROFILE_URI)) {
                log.error("Unsupported password type " + tmpVal);
                throw WSSecurityException.UNSUPPORTED_SECURITY_TOKEN;
            }
            String valueType = null;
            if (tmpVal != null) {
                int index = tmpVal.indexOf(35);
                if (index == -1) {
                    log.error("Unsupported password type " + tmpVal);
                    throw WSSecurityException.UNSUPPORTED_SECURITY_TOKEN;
                }
                valueType = tmpVal.substring(index + 1);
            }
            if ("PasswordDigest".equals(valueType)) {
                this.passwordType = 1;
                String tmpStr = WSSecurityHelper.getTextNodeValue(passwordElement);
                if (tmpStr != null) {
                    this.receivedPasswordDigest = Base64.decode((byte[])tmpStr.getBytes());
                }
            } else if ("PasswordText".equals(valueType)) {
                this.passwordType = 0;
                this.password = WSSecurityHelper.getTextNodeValue(passwordElement);
            } else {
                if (tmpVal != null && !"".equals(tmpVal)) {
                    log.error("Unsupported password type " + tmpVal);
                    throw WSSecurityException.UNSUPPORTED_SECURITY_TOKEN;
                }
                this.passwordType = 0;
                this.password = WSSecurityHelper.getTextNodeValue(passwordElement);
            }
        }
        if (usernameElement != null) {
            this.username = WSSecurityHelper.getTextNodeValue(usernameElement);
        }
        if (createdElement != null) {
            try {
                this.created = WSSecurityHelper.parseDate(WSSecurityHelper.getTextNodeValue(createdElement));
            }
            catch (Exception e) {
                this.created = null;
                throw new XMLSecurityException(e);
            }
        }
        if (nonceElement == null) return;
        String tmpVal = WSSecurityHelper.getTextNodeValue(nonceElement);
        if (tmpVal == null) return;
        try {
            this.nonce = Base64.decode((byte[])tmpVal.getBytes(Constants.UTF_8));
            return;
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLSecurityException(e);
        }
    }

    public static boolean validate(byte[] nonce, Date created, boolean addToCache, long expirationLimit) {
        LinkedList linkedList = nonceCache;
        synchronized (linkedList) {
            if (nonce == null || created == null) {
                boolean bl = false;
                return bl;
            }
            long currentTime = WSSecurityImpl.getUtcCalendar().getCurrentTimeInMillis();
            if (currentTime - created.getTime() > expirationLimit) {
                boolean bl = false;
                return bl;
            }
            Iterator it = nonceCache.iterator();
            while (it.hasNext()) {
                NonceWrapper nonceWrapper = (NonceWrapper)it.next();
                if (Arrays.equals(nonceWrapper.nonce, nonce)) {
                    boolean bl = false;
                    return bl;
                }
                if (nonceWrapper.created == null || currentTime - nonceWrapper.created.getTime() <= expirationLimit) continue;
                it.remove();
            }
            if (addToCache) {
                nonceCache.add(new NonceWrapper(nonce, created));
            }
            boolean bl = true;
            return bl;
        }
    }

    public String getType() {
        return ELEMENT_USERNAME;
    }

    private Key getSecretKey() throws WSSecurityException {
        if (this.secretKey == null) {
            try {
                byte[] pwdDigest = null;
                if (this.getPasswordType() == 0) {
                    if (this.nonce == null || this.created == null || this.password == null) {
                        throw new WSSecurityException(null, "For the digested password, nonce, created and password must be set. You probably disabled created and nonce creation and used the digested password");
                    }
                    String formattedCreated = this.formattedCreated;
                    if (formattedCreated == null) {
                        formattedCreated = WSSecurityImpl.getUtcDateFormat().format(this.created);
                    }
                    if (formattedCreated == null) {
                        throw new WSSecurityException(null, "An error occured when formating date: " + this.created.toString() + " " + WSSecurityImpl.getUtcDateFormat().toPattern());
                    }
                    pwdDigest = DigestCalculator.getWsSha1PasswordDigest((byte[])this.nonce, (String)formattedCreated, (String)this.password);
                } else {
                    String password = this.getPassword();
                    if (password == null) {
                        if (this.receivedPasswordDigest != null) {
                            pwdDigest = this.receivedPasswordDigest;
                        }
                    } else {
                        pwdDigest = Base64.decode((byte[])password.getBytes(Constants.UTF_8));
                    }
                }
                PWDPSHA1Generator keyGen = new PWDPSHA1Generator();
                PWDPSHA1ParameterSpec spec = new PWDPSHA1ParameterSpec(pwdDigest, "WS-Security", this.getNonce(), 24);
                keyGen.init(spec);
                this.secretKey = keyGen.generateKey();
            }
            catch (Exception e) {
                throw new WSSecurityException(e);
            }
        }
        return this.secretKey;
    }

    private static class NonceWrapper {
        public byte[] nonce = null;
        public Date created;

        public NonceWrapper(byte[] nonce, Date created) {
            this.nonce = nonce;
            this.created = created;
        }
    }
}

