/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.utils.resolver.implementations;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolverException;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolverSpi;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;

public class ResolverDirectHTTP
extends ResourceResolverSpi {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$utils$resolver$implementations$ResolverDirectHTTP == null ? (class$com$systinet$wasp$security$secext$utils$resolver$implementations$ResolverDirectHTTP = ResolverDirectHTTP.class$("com.systinet.wasp.security.secext.utils.resolver.implementations.ResolverDirectHTTP")) : class$com$systinet$wasp$security$secext$utils$resolver$implementations$ResolverDirectHTTP).getName());
    static final String[] properties = new String[]{"http.proxy.host", "http.proxy.port", "http.proxy.username", "http.proxy.password", "http.basic.username", "http.basic.password"};
    private static final int HttpProxyHost = 0;
    private static final int HttpProxyPort = 1;
    private static final int HttpProxyUser = 2;
    private static final int HttpProxyPass = 3;
    private static final int HttpBasicUser = 4;
    private static final int HttpBasicPass = 5;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$utils$resolver$implementations$ResolverDirectHTTP;

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        try {
            String auth;
            boolean switchBackProxy;
            boolean useProxy = false;
            String proxyHost = this.engineGetProperty(properties[0]);
            String proxyPort = this.engineGetProperty(properties[1]);
            if (proxyHost != null && proxyPort != null) {
                useProxy = true;
            }
            String oldProxySet = (String)((Hashtable)System.getProperties()).get("http.proxySet");
            String oldProxyHost = (String)((Hashtable)System.getProperties()).get("http.proxyHost");
            String oldProxyPort = (String)((Hashtable)System.getProperties()).get("http.proxyPort");
            boolean bl = switchBackProxy = oldProxySet != null && oldProxyHost != null && oldProxyPort != null;
            if (useProxy) {
                ((Hashtable)System.getProperties()).put("http.proxySet", "true");
                ((Hashtable)System.getProperties()).put("http.proxyHost", proxyHost);
                ((Hashtable)System.getProperties()).put("http.proxyPort", proxyPort);
            }
            URI uriNew = this.getNewURI(uri.getNodeValue(), BaseURI);
            URI uriNewNoFrag = new URI(uriNew);
            uriNewNoFrag.setFragment(null);
            URL url = new URL(uriNewNoFrag.toString());
            URLConnection urlConnection = url.openConnection();
            String proxyUser = this.engineGetProperty(properties[2]);
            String proxyPass = this.engineGetProperty(properties[3]);
            if (proxyUser != null && proxyPass != null) {
                String password = proxyUser + ":" + proxyPass;
                String encodedPassword = Base64.encode(password.getBytes());
                urlConnection.setRequestProperty("Proxy-Authorization", encodedPassword);
            }
            if ((auth = urlConnection.getHeaderField("WWW-Authenticate")) != null && auth.startsWith("Basic")) {
                String user = this.engineGetProperty(properties[4]);
                String pass = this.engineGetProperty(properties[5]);
                if (user != null && pass != null) {
                    urlConnection = url.openConnection();
                    String password = user + ":" + pass;
                    String encodedPassword = Base64.encode(password.getBytes());
                    urlConnection.setRequestProperty("Authorization", "Basic " + encodedPassword);
                }
            }
            String mimeType = urlConnection.getHeaderField("Content-Type");
            String contentLength = urlConnection.getHeaderField("Content-Length");
            InputStream inputStream = urlConnection.getInputStream();
            BufferedInputStream bufIn = new BufferedInputStream(inputStream);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int read = 0;
            int summarized = 0;
            while ((read = inputStream.read(buf)) >= 0) {
                baos.write(buf, 0, read);
                summarized += read;
            }
            XMLSignatureInput result = new XMLSignatureInput(baos.toByteArray());
            result.setSourceURI(uriNew.toString());
            result.setMIMEType(mimeType);
            if (switchBackProxy) {
                ((Hashtable)System.getProperties()).put("http.proxySet", oldProxySet);
                ((Hashtable)System.getProperties()).put("http.proxyHost", oldProxyHost);
                ((Hashtable)System.getProperties()).put("http.proxyPort", oldProxyPort);
            }
            return result;
        }
        catch (MalformedURLException ex) {
            throw new ResourceResolverException("generic.EmptyMessage", ex, uri, BaseURI);
        }
        catch (IOException ex) {
            throw new ResourceResolverException("generic.EmptyMessage", ex, uri, BaseURI);
        }
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        if (uriNodeValue.equals("") || uriNodeValue.startsWith("#")) {
            return false;
        }
        URI uriNew = null;
        try {
            uriNew = this.getNewURI(uri.getNodeValue(), BaseURI);
        }
        catch (URI.MalformedURIException ex) {
            // empty catch block
        }
        return uriNew != null && uriNew.getScheme().equals("http");
    }

    public String[] engineGetPropertyKeys() {
        return properties;
    }

    private URI getNewURI(String uri, String BaseURI) throws URI.MalformedURIException {
        if (BaseURI == null || "".equals(BaseURI)) {
            return new URI(uri);
        }
        return new URI(new URI(BaseURI), uri);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

