/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.utils;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.Canonicalizer;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.Constants;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.secext.utils.EncryptionConstants;
import com.systinet.wasp.security.secext.utils.HelperNodeList;
import com.systinet.wasp.security.secext.utils.I18n;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$utils$XMLUtils == null ? (class$com$systinet$wasp$security$secext$utils$XMLUtils = XMLUtils.class$("com.systinet.wasp.security.secext.utils.XMLUtils")) : class$com$systinet$wasp$security$secext$utils$XMLUtils).getName());
    private static String[] nodeTypeString = new String[]{"", "ELEMENT", "ATTRIBUTE", "TEXT_NODE", "CDATA_SECTION", "ENTITY_REFERENCE", "ENTITY", "PROCESSING_INSTRUCTION", "COMMENT", "DOCUMENT", "DOCUMENT_TYPE", "DOCUMENT_FRAGMENT", "NOTATION"};
    private static String randomNS = null;
    public static final String randomNSprefix = "http://www.xmlsecurity.org/NS#randomval";
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$utils$XMLUtils;
    static /* synthetic */ Class class$java$lang$Thread;

    private XMLUtils() {
    }

    public static String getXalanVersion() {
        String version = XMLUtils.getXalan1Version();
        if (version != null) {
            return version;
        }
        version = XMLUtils.getXalan20Version();
        if (version != null) {
            return version;
        }
        version = XMLUtils.getXalan2Version();
        if (version != null) {
            return version;
        }
        return "Apache Xalan not installed";
    }

    public static String getXercesVersion() {
        String version = XMLUtils.getXerces1Version();
        if (version != null) {
            return version;
        }
        version = XMLUtils.getXerces2Version();
        if (version != null) {
            return version;
        }
        return "Apache Xerces not installed";
    }

    private static String getXalan1Version() {
        try {
            String XALAN1_VERSION_CLASS = "org.apache.xalan.xslt.XSLProcessorVersion";
            Class clazz = XMLUtils.classForName("org.apache.xalan.xslt.XSLProcessorVersion");
            StringBuffer buf = new StringBuffer();
            Field f = clazz.getField("PRODUCT");
            buf.append(f.get(null));
            buf.append(';');
            f = clazz.getField("LANGUAGE");
            buf.append(f.get(null));
            buf.append(';');
            f = clazz.getField("S_VERSION");
            buf.append(f.get(null));
            buf.append(';');
            return buf.toString();
        }
        catch (Exception e1) {
            return null;
        }
    }

    private static String getXalan20Version() {
        try {
            String XALAN2_2_VERSION_CLASS = "org.apache.xalan.Version";
            String XALAN2_2_VERSION_METHOD = "getVersion";
            Class[] noArgs = new Class[]{};
            Class clazz = XMLUtils.classForName("org.apache.xalan.Version");
            Method method = clazz.getMethod("getVersion", noArgs);
            Object returnValue = method.invoke(null, new Object[0]);
            return (String)returnValue;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String getXalan2Version() {
        try {
            String XALAN2_VERSION_CLASS = "org.apache.xalan.processor.XSLProcessorVersion";
            Class clazz = XMLUtils.classForName("org.apache.xalan.processor.XSLProcessorVersion");
            StringBuffer buf = new StringBuffer();
            Field f = clazz.getField("S_VERSION");
            buf.append(f.get(null));
            return buf.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String getXerces1Version() {
        try {
            String XERCES1_VERSION_CLASS = "org.apache.xerces.framework.Version";
            Class clazz = XMLUtils.classForName("org.apache.xerces.framework.Version");
            Field f = clazz.getField("fVersion");
            String parserVersion = (String)f.get(null);
            return parserVersion;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getXerces2Version() {
        try {
            String XERCES2_VERSION_CLASS = "org.apache.xerces.impl.Version";
            Class clazz = XMLUtils.classForName("org.apache.xerces.impl.Version");
            Field f = clazz.getField("fVersion");
            String parserVersion = (String)f.get(null);
            return parserVersion;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static Class classForName(String className) throws ClassNotFoundException {
        ClassLoader classLoader = XMLUtils.findClassLoader();
        if (classLoader == null) {
            return Class.forName(className);
        }
        return classLoader.loadClass(className);
    }

    protected static ClassLoader findClassLoader() throws ClassNotFoundException {
        Object classLoader = null;
        Method m = null;
        try {
            m = (class$java$lang$Thread == null ? (class$java$lang$Thread = XMLUtils.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            return (class$com$systinet$wasp$security$secext$utils$XMLUtils == null ? (class$com$systinet$wasp$security$secext$utils$XMLUtils = XMLUtils.class$("com.systinet.wasp.security.secext.utils.XMLUtils")) : class$com$systinet$wasp$security$secext$utils$XMLUtils).getClassLoader();
        }
        try {
            return (ClassLoader)m.invoke((Object)Thread.currentThread(), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void spitOutVersions(Category cat) {
    }

    public static String getNodeTypeString(short nodeType) {
        if (nodeType > 0 && nodeType < 13) {
            return nodeTypeString[nodeType];
        }
        return "";
    }

    public static String getNodeTypeString(Node n) {
        return XMLUtils.getNodeTypeString(n.getNodeType());
    }

    public static Vector getAncestorElements(Node ctxNode) {
        if (ctxNode.getNodeType() != 1) {
            return null;
        }
        Vector<Node> ancestorVector = new Vector<Node>();
        Node parent = ctxNode;
        while ((parent = parent.getParentNode()) != null && parent.getNodeType() == 1) {
            ancestorVector.add(parent);
        }
        ancestorVector.trimToSize();
        return ancestorVector;
    }

    public static Vector getAncestorElements(Node ctxNode, Node rootElement) {
        Vector<Node> ancestorVector = new Vector<Node>();
        if (ctxNode.getNodeType() != 1) {
            return ancestorVector;
        }
        Node parent = ctxNode;
        Node parentOfRoot = rootElement.getParentNode();
        while ((parent = parent.getParentNode()) != null && parent.getNodeType() == 1 && parent != parentOfRoot) {
            ancestorVector.add(parent);
        }
        ancestorVector.trimToSize();
        return ancestorVector;
    }

    public static NodeList getDirectChildrenElements(Element parentElement) {
        NodeList allNodes = parentElement.getChildNodes();
        HelperNodeList selectedNodes = new HelperNodeList();
        int i = 0;
        while (i < allNodes.getLength()) {
            Node currentNode = allNodes.item(i);
            if (currentNode.getNodeType() == 1) {
                selectedNodes.appendChild(currentNode);
            }
            ++i;
        }
        return selectedNodes;
    }

    public static Element getDirectChild(Element parentElement, String childLocalName, String childNamespaceURI) {
        NodeList nl = parentElement.getChildNodes();
        Vector<Node> results = new Vector<Node>();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && ((Element)n).getLocalName().equals(childLocalName) && ((Element)n).getNamespaceURI().equals(childNamespaceURI)) {
                results.add(n);
            }
            ++i;
        }
        if (results.size() != 1) {
            return null;
        }
        return (Element)results.elementAt(0);
    }

    public static void outputDOM(Node contextNode, String filename) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(filename);
        XMLUtils.outputDOM(contextNode, os);
    }

    public static void outputDOM(Node contextNode, OutputStream os) {
        XMLUtils.outputDOM(contextNode, os, false);
    }

    public static void outputDOM(Node contextNode, OutputStream os, boolean addPreamble) {
        try {
            if (addPreamble) {
                os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            os.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (IOException ex) {
        }
        catch (InvalidCanonicalizerException ex) {
            ex.printStackTrace();
        }
        catch (CanonicalizationException ex) {
            ex.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node contextNode, OutputStream os) {
        try {
            os.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (IOException ex) {
        }
        catch (InvalidCanonicalizerException ex) {
        }
        catch (CanonicalizationException ex) {
            // empty catch block
        }
    }

    public static NodeList elementToNodeList(Node node) {
        HelperNodeList nl = new HelperNodeList();
        nl.appendChild(node);
        return nl;
    }

    public static Attr createAttr(Document doc, String QName, String Value, String NamespaceURI) {
        Attr attr = doc.createAttributeNS(NamespaceURI, QName);
        attr.setNodeValue(Value);
        return attr;
    }

    public static void setAttr(Element elem, String QName, String Value) {
        Document doc = elem.getOwnerDocument();
        Attr attr = doc.createAttributeNS("http://www.w3.org/2000/09/xmldsig#", QName);
        attr.setNodeValue(Value);
        elem.setAttributeNode(attr);
    }

    public static Element createElementFromBigint(Document doc, String elementName, BigInteger bigInteger) throws XMLSignatureException {
        Element element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", Constants.getSignatureSpecNSprefix() + ":" + elementName);
        if (bigInteger.signum() != 1) {
            throw new XMLSignatureException("signature.Util.BignumNonPositive");
        }
        byte[] byteRepresentation = bigInteger.toByteArray();
        while (byteRepresentation[0] == 0) {
            byte[] oldByteRepresentation = byteRepresentation;
            byteRepresentation = new byte[oldByteRepresentation.length - 1];
            System.arraycopy(oldByteRepresentation, 1, byteRepresentation, 0, oldByteRepresentation.length - 1);
        }
        Text text = doc.createTextNode(Base64.encode(byteRepresentation));
        element.appendChild(text);
        return element;
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        int i = 0;
        while (i < iMax) {
            Node curr = children.item(i);
            if (curr.getNodeType() == 3) {
                sb.append(((Text)curr).getData());
            }
            ++i;
        }
        return sb.toString();
    }

    public static BigInteger getBigintFromElement(Element element) throws XMLSignatureException {
        try {
            if (element.getChildNodes().getLength() != 1) {
                throw new XMLSignatureException("signature.Util.TooManyChilds");
            }
            Node child = element.getFirstChild();
            if (child == null || child.getNodeType() != 3) {
                throw new XMLSignatureException("signature.Util.NonTextNode");
            }
            Text text = (Text)child;
            String textData = text.getData();
            byte[] magnitude = Base64.decode(textData);
            int signum = 1;
            BigInteger bigInteger = new BigInteger(signum, magnitude);
            return bigInteger;
        }
        catch (Base64DecodingException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public static byte[] getBytesFromElement(Element element) throws XMLSignatureException {
        try {
            if (element.getChildNodes().getLength() != 1) {
                throw new XMLSignatureException("signature.Util.TooManyChilds");
            }
            Node child = element.getFirstChild();
            if (child == null || child.getNodeType() != 3) {
                throw new XMLSignatureException("signature.Util.NonTextNode");
            }
            Text text = (Text)child;
            String textData = text.getData();
            byte[] bytes = Base64.decode(textData);
            return bytes;
        }
        catch (Base64DecodingException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public static Element createElementInSignatureSpace(Document doc, String elementName) {
        if (doc == null) {
            throw new RuntimeException("Document is null");
        }
        String ds = Constants.getSignatureSpecNSprefix();
        if (ds == null || ds.length() == 0) {
            Element element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", elementName);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        Element element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", ds + ":" + elementName);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + ds, "http://www.w3.org/2000/09/xmldsig#");
        return element;
    }

    public static Element createElementInEncryptionSpace(Document doc, String elementName) {
        if (doc == null) {
            throw new RuntimeException("Document is null");
        }
        String xenc = EncryptionConstants.getEncryptionSpecNSprefix();
        if (xenc == null || xenc.length() == 0) {
            Element element = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", elementName);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        Element element = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", xenc + ":" + elementName);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xenc, "http://www.w3.org/2001/04/xmlenc#");
        return element;
    }

    public static boolean elementIsInSignatureSpace(Element element, String localName) {
        if (element == null) {
            return false;
        }
        if (element.getNamespaceURI() == null) {
            return false;
        }
        if (!element.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
            return false;
        }
        return element.getLocalName().equals(localName);
    }

    public static boolean elementIsInEncryptionSpace(Element element, String localName) {
        if (element == null) {
            return false;
        }
        if (element.getNamespaceURI() == null) {
            return false;
        }
        if (!element.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
            return false;
        }
        return element.getLocalName().equals(localName);
    }

    public static void guaranteeThatElementInSignatureSpace(Element element, String localName) throws XMLSignatureException {
        if (element == null) {
            Object[] exArgs = new Object[]{localName, null};
            throw new XMLSignatureException("xml.WrongElement", exArgs);
        }
        if (localName == null || localName.equals("") || !XMLUtils.elementIsInSignatureSpace(element, localName)) {
            Object[] exArgs = new Object[]{localName, element.getLocalName()};
            throw new XMLSignatureException("xml.WrongElement", exArgs);
        }
    }

    public static void guaranteeThatElementInEncryptionSpace(Element element, String localName) throws XMLSecurityException {
        if (element == null) {
            Object[] exArgs = new Object[]{localName, null};
            throw new XMLSecurityException("xml.WrongElement", exArgs);
        }
        if (localName == null || localName.equals("") || !XMLUtils.elementIsInEncryptionSpace(element, localName)) {
            Object[] exArgs = new Object[]{localName, element.getLocalName()};
            throw new XMLSecurityException("xml.WrongElement", exArgs);
        }
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException npe) {
            throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + ((Throwable)npe).getMessage() + "\"");
        }
    }

    public static String getRandomNamespacePrefix() {
        if (randomNS == null) {
            byte[] randomData = new byte[21];
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(randomData);
            String prefix = "xmlsecurityOrgPref" + Base64.encode(randomData);
            randomNS = "";
            int i = 0;
            while (i < prefix.length()) {
                if (prefix.charAt(i) != '+' && prefix.charAt(i) != '/' && prefix.charAt(i) != '=') {
                    randomNS = randomNS + prefix.charAt(i);
                }
                ++i;
            }
        }
        return randomNS;
    }

    public static Element createDSctx(Document doc, String prefix, String namespace) {
        if (prefix == null || prefix.trim().length() == 0) {
            throw new IllegalArgumentException("You must supply a prefix");
        }
        Element ctx = doc.createElementNS(null, "namespaceContext");
        ctx.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix.trim(), namespace);
        return ctx;
    }

    public static Element createDSctx(Document doc, String prefix) {
        return XMLUtils.createDSctx(doc, prefix, "http://www.w3.org/2000/09/xmldsig#");
    }

    public static void addReturnToElement(ElementProxy elementProxy) {
    }

    public static void addReturnToElement(Element e) {
    }

    public static void addReturnToNode(Node n) {
    }

    public static Set convertNodelistToSet(NodeList xpathNodeSet) {
        if (xpathNodeSet == null) {
            return new HashSet();
        }
        int length = xpathNodeSet.getLength();
        HashSet<Node> set = new HashSet<Node>(length);
        int i = 0;
        while (i < length) {
            set.add(xpathNodeSet.item(i));
            ++i;
        }
        return set;
    }

    public static NodeList convertSetToNodelist(Set set) {
        HelperNodeList result = new HelperNodeList();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            result.appendChild((Node)it.next());
        }
        return result;
    }

    public static void circumventBug2650(Document doc) {
        Element documentElement = doc.getDocumentElement();
        Attr xmlnsAttr = documentElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (xmlnsAttr == null) {
            documentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650recurse(doc);
    }

    private static void circumventBug2650recurse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int attributesLength = attributes.getLength();
            NodeList children = element.getChildNodes();
            int childrenLength = children.getLength();
            int j = 0;
            while (j < childrenLength) {
                Node child = children.item(j);
                if (child.getNodeType() == 1) {
                    Element childElement = (Element)child;
                    int i = 0;
                    while (i < attributesLength) {
                        Attr currentAttr = (Attr)attributes.item(i);
                        boolean isNamespace = "http://www.w3.org/2000/xmlns/".equals(currentAttr.getNamespaceURI());
                        if (isNamespace) {
                            boolean mustBeDefinedInChild;
                            boolean bl = mustBeDefinedInChild = !childElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getLocalName());
                            if (mustBeDefinedInChild) {
                                childElement.setAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getName(), currentAttr.getNodeValue());
                            }
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        Node child = node.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 1: 
                case 5: 
                case 9: {
                    XMLUtils.circumventBug2650recurse(child);
                }
            }
            child = child.getNextSibling();
        }
    }

    private static String getXPath(Node n, String result) {
        if (n == null) {
            return result;
        }
        switch (n.getNodeType()) {
            case 2: {
                return XMLUtils.getXPath(((Attr)n).getOwnerElement(), "/@" + ((Attr)n).getNodeName() + "=\"" + ((Attr)n).getNodeValue() + "\"");
            }
            case 1: {
                return XMLUtils.getXPath(n.getParentNode(), "/" + ((Element)n).getTagName() + result);
            }
            case 3: {
                return XMLUtils.getXPath(n.getParentNode(), "/#text");
            }
            case 9: {
                if (result.length() > 0) {
                    return result;
                }
                return "/";
            }
        }
        return result;
    }

    public static String getXPath(Node n) {
        return XMLUtils.getXPath(n, "");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

