/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms.implementations;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.TransformSpi;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.transforms.params.XPath2FilterContainer;
import com.systinet.wasp.security.secext.utils.CachedXPathFuncHereAPI;
import com.systinet.wasp.security.secext.utils.HelperNodeList;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformXPath2Filter
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2002/06/xmldsig-filter2";
    Vector _filterTypes = new Vector();
    Vector _filterNodes = new Vector();
    Set _F = null;
    Vector _ancestors = null;
    private static final String FUnion = "union";
    private static final String FSubtract = "subtract";
    private static final String FIntersect = "intersect";
    Set _inputSet = null;

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return false;
    }

    public boolean returnsNodeSet() {
        return true;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        try {
            long start = System.currentTimeMillis();
            this._inputSet = input.getNodeSet();
            if (this._inputSet.size() == 0) {
                return input;
            }
            CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(input.getCachedXPathAPI());
            CachedXPathAPI myXPathAPI = new CachedXPathAPI(input.getCachedXPathAPI());
            Document inputDoc = null;
            Iterator it = this._inputSet.iterator();
            inputDoc = XMLUtils.getOwnerDocument((Node)it.next());
            int noOfSteps = this._transformObject.length(implementedTransformURI, "XPath");
            if (noOfSteps == 0) {
                Object[] exArgs = new Object[]{implementedTransformURI, "XPath"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            XPath2FilterContainer unionDocFilter = XPath2FilterContainer.newInstanceUnion(this._transformObject.getDocument(), "/");
            this._filterTypes.add(FUnion);
            HelperNodeList root = new HelperNodeList();
            root.appendChild(inputDoc);
            this._filterNodes.add(root);
            int i = 0;
            while (i < noOfSteps) {
                Element xpathElement = this._transformObject.getChildElementLocalName(i, implementedTransformURI, "XPath");
                XPath2FilterContainer xpathContainer = XPath2FilterContainer.newInstance(xpathElement, input.getSourceURI());
                if (xpathContainer.isIntersect()) {
                    this._filterTypes.add(FIntersect);
                } else if (xpathContainer.isSubtract()) {
                    this._filterTypes.add(FSubtract);
                } else if (xpathContainer.isUnion()) {
                    this._filterTypes.add(FUnion);
                } else {
                    this._filterTypes.add(null);
                }
                NodeList subtreeRoots = xPathFuncHereAPI.selectNodeList(inputDoc, xpathContainer.getXPathFilterTextNode(), xpathContainer.getElement());
                this._filterNodes.add(subtreeRoots);
                ++i;
            }
            this._F = new HashSet();
            this._ancestors = new Vector();
            this.traversal(inputDoc);
            HashSet<Node> resultSet = new HashSet<Node>();
            Iterator it2 = this._inputSet.iterator();
            while (it2.hasNext()) {
                Node n = (Node)it2.next();
                if (!this._F.contains(n)) continue;
                resultSet.add(n);
            }
            XMLSignatureInput result = new XMLSignatureInput(resultSet, input.getCachedXPathAPI());
            result.setSourceURI(input.getSourceURI());
            long end = System.currentTimeMillis();
            return result;
        }
        catch (TransformerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (DOMException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private void traversal(Node currentNode) {
        this._ancestors.add(currentNode);
        if (this._inputSet.contains(currentNode)) {
            int iMax = this._filterTypes.size();
            int i = 0;
            i = iMax - 1;
            while (i >= 0) {
                NodeList rootNodes = (NodeList)this._filterNodes.elementAt(i);
                String type = (String)this._filterTypes.elementAt(i);
                if (type == FUnion && this.rooted(currentNode, this._ancestors, rootNodes)) break;
                --i;
            }
            int IStart = i;
            if (IStart == -1) {
                IStart = 0;
            }
            boolean include = true;
            int I = IStart;
            while (I < iMax) {
                NodeList rootNodes = (NodeList)this._filterNodes.elementAt(I);
                String type = (String)this._filterTypes.elementAt(I);
                boolean rooted = this.rooted(currentNode, this._ancestors, rootNodes);
                if (type == FIntersect && !rooted) {
                    include = false;
                    break;
                }
                if (type == FSubtract && rooted) {
                    include = false;
                    break;
                }
                ++I;
            }
            if (include) {
                this._F.add(currentNode);
            }
        }
        if (currentNode.getNodeType() == 1) {
            NamedNodeMap attributes = ((Element)currentNode).getAttributes();
            int attributesLength = attributes.getLength();
            int x = 0;
            while (x < attributesLength) {
                Node attr = attributes.item(x);
                this.traversal(attr);
                ++x;
            }
        }
        Node currentChild = currentNode.getFirstChild();
        while (currentChild != null) {
            this.traversal(currentChild);
            currentChild = currentChild.getNextSibling();
        }
        this._ancestors.remove(currentNode);
    }

    boolean rooted(Node currentNode, Vector ancestors, NodeList rootNodes) {
        int length = rootNodes.getLength();
        int i = 0;
        while (i < length) {
            Node rootNode = rootNodes.item(i);
            if (ancestors.contains(rootNode)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean __isRootedBy(Node ctx, Node rootInQuestion) {
        if (ctx == null || rootInQuestion == null) {
            return false;
        }
        if (rootInQuestion.getNodeType() == 9) {
            return true;
        }
        Node n = ctx;
        while (n != null) {
            if (n == rootInQuestion) {
                return true;
            }
            n = n.getNodeType() == 2 ? ((Attr)n).getOwnerElement() : n.getParentNode();
        }
        return false;
    }
}

